<!-- Source: https://github.com/MattIPv4/template/blob/master/README.md -->

<!-- Title -->
<h1 align="center" id="statcordpy">
    statcord.py
</h1>

<!-- Tag line --> 
<h3 align="center">A simple API wrapper for statcord.com  to connect your bot and get your bot stats.</h3>



----

<!-- Content -->
## Installation

Install via pip (recommended)

```Shell
python3 -m pip install statcord.py
```

## Features

* AUTOMATIC server & user counts updating.
* AUTOMATIC commands & active users updating.
* AUTOMATIC resource usage posting.
* AUTOMATIC custom function usage.
* Support provided via [discord](https://statcord.com/discord)

## Posting Server & User Counts, Active Users and Popular Commands.

### Example Cogs System

```Python
from discord.ext import commands

import statcord


class StatcordPost(commands.Cog):
    def __init__(self, bot):
        self.bot = bot
        self.key = "statcord.com-ADDYOURKEYHERE"
        self.api = statcord.Client(self.bot,self.key,custom1=self.custom1,custom2=self.custom2)
        self.api.start_loop()
        

    @commands.Cog.listener()
    async def on_command(self,ctx):
        self.api.command_run(ctx)

    async def custom1(self):
        # Do Things Here
        return "10" # Return a string.

    async def custom2(self):
        # Do Things Here
        return "10" # Return a string.


def setup(bot):
    bot.add_cog(StatcordPost(bot))

```

### Example non-cogs system.
```Python
import discord
from discord.ext import commands
import statcord 

bot = commands.Bot(command_prefix='!')

key = "statcord.com-ADDYOURKEYHERE"
api = statcord.Client(bot,key)
api.start_loop()

@bot.event
async def on_command(ctx):
    api.command_run(ctx)


bot.run(TOKEN)
```
### Configuration
To turn Memory tracking off, `statcord.Client(bot,key,mem = False)`
To turn CPU tracking off, `statcord.Client(bot,key,cpu = False)`


## Contributing

Contributions are always welcome!\
Take a look at any existing issues on this repository for starting places to help contribute towards, or simply create your own new contribution to the project.

When you are ready, simply create a pull request for your contribution and we will review it whenever we can!

### Donating

You can also help me and the project out by sponsoring me through a [donation on PayPal](http://paypal.me/labdiscord).


<!-- Discussion & Support -->
## Discussion, Support and Issues

Need support with this project, have found an issue or want to chat with others about contributing to the project?
> Please check the project's issues page first for support & bugs!

Not found what you need here?

* If you have an issue, please create a GitHub issue here to report it, include as much detail as you can.
* _Alternatively,_ You can join our Discord server to discuss any issue or to get support for the project.:

<a href="http://statcord.com/discord" target="_blank">
    <img src="https://discordapp.com/api/guilds/608711879858192479/embed.png" alt="Discord" height="30">
</a>
