# coding: utf-8

"""
    Files

    Upload and manage files.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.files.files.configuration import Configuration


class ImportFromUrlInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'access': 'str',
        'ttl': 'str',
        'name': 'str',
        'url': 'str',
        'folder_id': 'str',
        'folder_path': 'str',
        'duplicate_validation_strategy': 'str',
        'duplicate_validation_scope': 'str',
        'overwrite': 'bool'
    }

    attribute_map = {
        'access': 'access',
        'ttl': 'ttl',
        'name': 'name',
        'url': 'url',
        'folder_id': 'folderId',
        'folder_path': 'folderPath',
        'duplicate_validation_strategy': 'duplicateValidationStrategy',
        'duplicate_validation_scope': 'duplicateValidationScope',
        'overwrite': 'overwrite'
    }

    def __init__(self, access=None, ttl=None, name=None, url=None, folder_id=None, folder_path=None, duplicate_validation_strategy=None, duplicate_validation_scope=None, overwrite=None, local_vars_configuration=None):  # noqa: E501
        """ImportFromUrlInput - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._access = None
        self._ttl = None
        self._name = None
        self._url = None
        self._folder_id = None
        self._folder_path = None
        self._duplicate_validation_strategy = None
        self._duplicate_validation_scope = None
        self._overwrite = None
        self.discriminator = None

        self.access = access
        if ttl is not None:
            self.ttl = ttl
        if name is not None:
            self.name = name
        self.url = url
        if folder_id is not None:
            self.folder_id = folder_id
        if folder_path is not None:
            self.folder_path = folder_path
        self.duplicate_validation_strategy = duplicate_validation_strategy
        self.duplicate_validation_scope = duplicate_validation_scope
        self.overwrite = overwrite

    @property
    def access(self):
        """Gets the access of this ImportFromUrlInput.  # noqa: E501

        PUBLIC_INDEXABLE: File is publicly accessible by anyone who has the URL. Search engines can index the file. PUBLIC_NOT_INDEXABLE: File is publicly accessible by anyone who has the URL. Search engines *can't* index the file. PRIVATE: File is NOT publicly accessible. Requires a signed URL to see content. Search engines *can't* index the file.   # noqa: E501

        :return: The access of this ImportFromUrlInput.  # noqa: E501
        :rtype: str
        """
        return self._access

    @access.setter
    def access(self, access):
        """Sets the access of this ImportFromUrlInput.

        PUBLIC_INDEXABLE: File is publicly accessible by anyone who has the URL. Search engines can index the file. PUBLIC_NOT_INDEXABLE: File is publicly accessible by anyone who has the URL. Search engines *can't* index the file. PRIVATE: File is NOT publicly accessible. Requires a signed URL to see content. Search engines *can't* index the file.   # noqa: E501

        :param access: The access of this ImportFromUrlInput.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and access is None:  # noqa: E501
            raise ValueError("Invalid value for `access`, must not be `None`")  # noqa: E501
        allowed_values = ["PUBLIC_INDEXABLE", "PUBLIC_NOT_INDEXABLE", "HIDDEN_INDEXABLE", "HIDDEN_NOT_INDEXABLE", "HIDDEN_PRIVATE", "PRIVATE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and access not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `access` ({0}), must be one of {1}"  # noqa: E501
                .format(access, allowed_values)
            )

        self._access = access

    @property
    def ttl(self):
        """Gets the ttl of this ImportFromUrlInput.  # noqa: E501

        Time to live. If specified the file will be deleted after the given time frame.  # noqa: E501

        :return: The ttl of this ImportFromUrlInput.  # noqa: E501
        :rtype: str
        """
        return self._ttl

    @ttl.setter
    def ttl(self, ttl):
        """Sets the ttl of this ImportFromUrlInput.

        Time to live. If specified the file will be deleted after the given time frame.  # noqa: E501

        :param ttl: The ttl of this ImportFromUrlInput.  # noqa: E501
        :type: str
        """

        self._ttl = ttl

    @property
    def name(self):
        """Gets the name of this ImportFromUrlInput.  # noqa: E501

        Name to give the resulting file in the file manager.  # noqa: E501

        :return: The name of this ImportFromUrlInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ImportFromUrlInput.

        Name to give the resulting file in the file manager.  # noqa: E501

        :param name: The name of this ImportFromUrlInput.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def url(self):
        """Gets the url of this ImportFromUrlInput.  # noqa: E501

        URL to download the new file from.  # noqa: E501

        :return: The url of this ImportFromUrlInput.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ImportFromUrlInput.

        URL to download the new file from.  # noqa: E501

        :param url: The url of this ImportFromUrlInput.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and url is None:  # noqa: E501
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501

        self._url = url

    @property
    def folder_id(self):
        """Gets the folder_id of this ImportFromUrlInput.  # noqa: E501

        One of folderId or folderPath is required. Destination folder ID for the uploaded file.  # noqa: E501

        :return: The folder_id of this ImportFromUrlInput.  # noqa: E501
        :rtype: str
        """
        return self._folder_id

    @folder_id.setter
    def folder_id(self, folder_id):
        """Sets the folder_id of this ImportFromUrlInput.

        One of folderId or folderPath is required. Destination folder ID for the uploaded file.  # noqa: E501

        :param folder_id: The folder_id of this ImportFromUrlInput.  # noqa: E501
        :type: str
        """

        self._folder_id = folder_id

    @property
    def folder_path(self):
        """Gets the folder_path of this ImportFromUrlInput.  # noqa: E501

        One of folderPath or folderId is required. Destination folder path for the uploaded file. If the folder path does not exist, there will be an attempt to create the folder path.  # noqa: E501

        :return: The folder_path of this ImportFromUrlInput.  # noqa: E501
        :rtype: str
        """
        return self._folder_path

    @folder_path.setter
    def folder_path(self, folder_path):
        """Sets the folder_path of this ImportFromUrlInput.

        One of folderPath or folderId is required. Destination folder path for the uploaded file. If the folder path does not exist, there will be an attempt to create the folder path.  # noqa: E501

        :param folder_path: The folder_path of this ImportFromUrlInput.  # noqa: E501
        :type: str
        """

        self._folder_path = folder_path

    @property
    def duplicate_validation_strategy(self):
        """Gets the duplicate_validation_strategy of this ImportFromUrlInput.  # noqa: E501

        NONE: Do not run any duplicate validation. REJECT: Reject the upload if a duplicate is found. RETURN_EXISTING: If a duplicate file is found, do not upload a new file and return the found duplicate instead.   # noqa: E501

        :return: The duplicate_validation_strategy of this ImportFromUrlInput.  # noqa: E501
        :rtype: str
        """
        return self._duplicate_validation_strategy

    @duplicate_validation_strategy.setter
    def duplicate_validation_strategy(self, duplicate_validation_strategy):
        """Sets the duplicate_validation_strategy of this ImportFromUrlInput.

        NONE: Do not run any duplicate validation. REJECT: Reject the upload if a duplicate is found. RETURN_EXISTING: If a duplicate file is found, do not upload a new file and return the found duplicate instead.   # noqa: E501

        :param duplicate_validation_strategy: The duplicate_validation_strategy of this ImportFromUrlInput.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and duplicate_validation_strategy is None:  # noqa: E501
            raise ValueError("Invalid value for `duplicate_validation_strategy`, must not be `None`")  # noqa: E501
        allowed_values = ["NONE", "REJECT", "RETURN_EXISTING"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and duplicate_validation_strategy not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `duplicate_validation_strategy` ({0}), must be one of {1}"  # noqa: E501
                .format(duplicate_validation_strategy, allowed_values)
            )

        self._duplicate_validation_strategy = duplicate_validation_strategy

    @property
    def duplicate_validation_scope(self):
        """Gets the duplicate_validation_scope of this ImportFromUrlInput.  # noqa: E501

        ENTIRE_PORTAL: Look for a duplicate file in the entire account. EXACT_FOLDER: Look for a duplicate file in the provided folder.   # noqa: E501

        :return: The duplicate_validation_scope of this ImportFromUrlInput.  # noqa: E501
        :rtype: str
        """
        return self._duplicate_validation_scope

    @duplicate_validation_scope.setter
    def duplicate_validation_scope(self, duplicate_validation_scope):
        """Sets the duplicate_validation_scope of this ImportFromUrlInput.

        ENTIRE_PORTAL: Look for a duplicate file in the entire account. EXACT_FOLDER: Look for a duplicate file in the provided folder.   # noqa: E501

        :param duplicate_validation_scope: The duplicate_validation_scope of this ImportFromUrlInput.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and duplicate_validation_scope is None:  # noqa: E501
            raise ValueError("Invalid value for `duplicate_validation_scope`, must not be `None`")  # noqa: E501
        allowed_values = ["ENTIRE_PORTAL", "EXACT_FOLDER"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and duplicate_validation_scope not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `duplicate_validation_scope` ({0}), must be one of {1}"  # noqa: E501
                .format(duplicate_validation_scope, allowed_values)
            )

        self._duplicate_validation_scope = duplicate_validation_scope

    @property
    def overwrite(self):
        """Gets the overwrite of this ImportFromUrlInput.  # noqa: E501

        If true, it will overwrite existing files if a file with the same name exists in the given folder.  # noqa: E501

        :return: The overwrite of this ImportFromUrlInput.  # noqa: E501
        :rtype: bool
        """
        return self._overwrite

    @overwrite.setter
    def overwrite(self, overwrite):
        """Sets the overwrite of this ImportFromUrlInput.

        If true, it will overwrite existing files if a file with the same name exists in the given folder.  # noqa: E501

        :param overwrite: The overwrite of this ImportFromUrlInput.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and overwrite is None:  # noqa: E501
            raise ValueError("Invalid value for `overwrite`, must not be `None`")  # noqa: E501

        self._overwrite = overwrite

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ImportFromUrlInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ImportFromUrlInput):
            return True

        return self.to_dict() != other.to_dict()
