# coding: utf-8

"""
    Accounting Extension

    These APIs allow you to interact with HubSpot's Accounting Extension. It allows you to: * Specify the URLs that HubSpot will use when making webhook requests to your external accounting system. * Respond to webhook calls made to your external accounting system by HubSpot   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.extensions.accounting.configuration import Configuration


class UnitPrice(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amount': 'float',
        'tax_included': 'bool'
    }

    attribute_map = {
        'amount': 'amount',
        'tax_included': 'taxIncluded'
    }

    def __init__(self, amount=None, tax_included=None, local_vars_configuration=None):  # noqa: E501
        """UnitPrice - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amount = None
        self._tax_included = None
        self.discriminator = None

        if amount is not None:
            self.amount = amount
        self.tax_included = tax_included

    @property
    def amount(self):
        """Gets the amount of this UnitPrice.  # noqa: E501

        The actual unit price amount.  # noqa: E501

        :return: The amount of this UnitPrice.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this UnitPrice.

        The actual unit price amount.  # noqa: E501

        :param amount: The amount of this UnitPrice.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def tax_included(self):
        """Gets the tax_included of this UnitPrice.  # noqa: E501

        Indicates if the unit price amount already includes taxes.  # noqa: E501

        :return: The tax_included of this UnitPrice.  # noqa: E501
        :rtype: bool
        """
        return self._tax_included

    @tax_included.setter
    def tax_included(self, tax_included):
        """Sets the tax_included of this UnitPrice.

        Indicates if the unit price amount already includes taxes.  # noqa: E501

        :param tax_included: The tax_included of this UnitPrice.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and tax_included is None:  # noqa: E501
            raise ValueError("Invalid value for `tax_included`, must not be `None`")  # noqa: E501

        self._tax_included = tax_included

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UnitPrice):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UnitPrice):
            return True

        return self.to_dict() != other.to_dict()
