# coding: utf-8

"""
    Accounting Extension

    These APIs allow you to interact with HubSpot's Accounting Extension. It allows you to: * Specify the URLs that HubSpot will use when making webhook requests to your external accounting system. * Respond to webhook calls made to your external accounting system by HubSpot   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.extensions.accounting.configuration import Configuration


class InvoiceUpdateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'external_invoice_number': 'str',
        'currency_code': 'str',
        'due_date': 'date',
        'external_recipient_id': 'str',
        'received_by_recipient_date': 'int',
        'is_voided': 'bool',
        'received_by_customer_date': 'str',
        'invoice_number': 'str'
    }

    attribute_map = {
        'external_invoice_number': 'externalInvoiceNumber',
        'currency_code': 'currencyCode',
        'due_date': 'dueDate',
        'external_recipient_id': 'externalRecipientId',
        'received_by_recipient_date': 'receivedByRecipientDate',
        'is_voided': 'isVoided',
        'received_by_customer_date': 'receivedByCustomerDate',
        'invoice_number': 'invoiceNumber'
    }

    def __init__(self, external_invoice_number=None, currency_code=None, due_date=None, external_recipient_id=None, received_by_recipient_date=None, is_voided=None, received_by_customer_date=None, invoice_number=None, local_vars_configuration=None):  # noqa: E501
        """InvoiceUpdateRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._external_invoice_number = None
        self._currency_code = None
        self._due_date = None
        self._external_recipient_id = None
        self._received_by_recipient_date = None
        self._is_voided = None
        self._received_by_customer_date = None
        self._invoice_number = None
        self.discriminator = None

        if external_invoice_number is not None:
            self.external_invoice_number = external_invoice_number
        if currency_code is not None:
            self.currency_code = currency_code
        if due_date is not None:
            self.due_date = due_date
        if external_recipient_id is not None:
            self.external_recipient_id = external_recipient_id
        if received_by_recipient_date is not None:
            self.received_by_recipient_date = received_by_recipient_date
        if is_voided is not None:
            self.is_voided = is_voided
        if received_by_customer_date is not None:
            self.received_by_customer_date = received_by_customer_date
        if invoice_number is not None:
            self.invoice_number = invoice_number

    @property
    def external_invoice_number(self):
        """Gets the external_invoice_number of this InvoiceUpdateRequest.  # noqa: E501


        :return: The external_invoice_number of this InvoiceUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._external_invoice_number

    @external_invoice_number.setter
    def external_invoice_number(self, external_invoice_number):
        """Sets the external_invoice_number of this InvoiceUpdateRequest.


        :param external_invoice_number: The external_invoice_number of this InvoiceUpdateRequest.  # noqa: E501
        :type: str
        """

        self._external_invoice_number = external_invoice_number

    @property
    def currency_code(self):
        """Gets the currency_code of this InvoiceUpdateRequest.  # noqa: E501

        The ISO 4217 currency code that represents the currency used in the invoice to bill the recipient  # noqa: E501

        :return: The currency_code of this InvoiceUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """Sets the currency_code of this InvoiceUpdateRequest.

        The ISO 4217 currency code that represents the currency used in the invoice to bill the recipient  # noqa: E501

        :param currency_code: The currency_code of this InvoiceUpdateRequest.  # noqa: E501
        :type: str
        """

        self._currency_code = currency_code

    @property
    def due_date(self):
        """Gets the due_date of this InvoiceUpdateRequest.  # noqa: E501

        The ISO-8601 due date of the invoice.  # noqa: E501

        :return: The due_date of this InvoiceUpdateRequest.  # noqa: E501
        :rtype: date
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this InvoiceUpdateRequest.

        The ISO-8601 due date of the invoice.  # noqa: E501

        :param due_date: The due_date of this InvoiceUpdateRequest.  # noqa: E501
        :type: date
        """

        self._due_date = due_date

    @property
    def external_recipient_id(self):
        """Gets the external_recipient_id of this InvoiceUpdateRequest.  # noqa: E501

        The ID of the invoice recipient. This is the recipient ID from the external accounting system.  # noqa: E501

        :return: The external_recipient_id of this InvoiceUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._external_recipient_id

    @external_recipient_id.setter
    def external_recipient_id(self, external_recipient_id):
        """Sets the external_recipient_id of this InvoiceUpdateRequest.

        The ID of the invoice recipient. This is the recipient ID from the external accounting system.  # noqa: E501

        :param external_recipient_id: The external_recipient_id of this InvoiceUpdateRequest.  # noqa: E501
        :type: str
        """

        self._external_recipient_id = external_recipient_id

    @property
    def received_by_recipient_date(self):
        """Gets the received_by_recipient_date of this InvoiceUpdateRequest.  # noqa: E501


        :return: The received_by_recipient_date of this InvoiceUpdateRequest.  # noqa: E501
        :rtype: int
        """
        return self._received_by_recipient_date

    @received_by_recipient_date.setter
    def received_by_recipient_date(self, received_by_recipient_date):
        """Sets the received_by_recipient_date of this InvoiceUpdateRequest.


        :param received_by_recipient_date: The received_by_recipient_date of this InvoiceUpdateRequest.  # noqa: E501
        :type: int
        """

        self._received_by_recipient_date = received_by_recipient_date

    @property
    def is_voided(self):
        """Gets the is_voided of this InvoiceUpdateRequest.  # noqa: E501

        States if the invoice is voided or not.  # noqa: E501

        :return: The is_voided of this InvoiceUpdateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_voided

    @is_voided.setter
    def is_voided(self, is_voided):
        """Sets the is_voided of this InvoiceUpdateRequest.

        States if the invoice is voided or not.  # noqa: E501

        :param is_voided: The is_voided of this InvoiceUpdateRequest.  # noqa: E501
        :type: bool
        """

        self._is_voided = is_voided

    @property
    def received_by_customer_date(self):
        """Gets the received_by_customer_date of this InvoiceUpdateRequest.  # noqa: E501

        The ISO-8601 datetime of when the customer received the invoice.  # noqa: E501

        :return: The received_by_customer_date of this InvoiceUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._received_by_customer_date

    @received_by_customer_date.setter
    def received_by_customer_date(self, received_by_customer_date):
        """Sets the received_by_customer_date of this InvoiceUpdateRequest.

        The ISO-8601 datetime of when the customer received the invoice.  # noqa: E501

        :param received_by_customer_date: The received_by_customer_date of this InvoiceUpdateRequest.  # noqa: E501
        :type: str
        """

        self._received_by_customer_date = received_by_customer_date

    @property
    def invoice_number(self):
        """Gets the invoice_number of this InvoiceUpdateRequest.  # noqa: E501

        The number / name of the invoice.  # noqa: E501

        :return: The invoice_number of this InvoiceUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._invoice_number

    @invoice_number.setter
    def invoice_number(self, invoice_number):
        """Sets the invoice_number of this InvoiceUpdateRequest.

        The number / name of the invoice.  # noqa: E501

        :param invoice_number: The invoice_number of this InvoiceUpdateRequest.  # noqa: E501
        :type: str
        """

        self._invoice_number = invoice_number

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InvoiceUpdateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InvoiceUpdateRequest):
            return True

        return self.to_dict() != other.to_dict()
