# coding: utf-8

"""
    Accounting Extension

    These APIs allow you to interact with HubSpot's Accounting Extension. It allows you to: * Specify the URLs that HubSpot will use when making webhook requests to your external accounting system. * Respond to webhook calls made to your external accounting system by HubSpot   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.extensions.accounting.configuration import Configuration


class ExchangeRateResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'result': 'str',
        'exchange_rate': 'float',
        'source_currency_code': 'str',
        'target_currency_code': 'str'
    }

    attribute_map = {
        'result': '@result',
        'exchange_rate': 'exchangeRate',
        'source_currency_code': 'sourceCurrencyCode',
        'target_currency_code': 'targetCurrencyCode'
    }

    def __init__(self, result=None, exchange_rate=None, source_currency_code=None, target_currency_code=None, local_vars_configuration=None):  # noqa: E501
        """ExchangeRateResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._result = None
        self._exchange_rate = None
        self._source_currency_code = None
        self._target_currency_code = None
        self.discriminator = None

        self.result = result
        self.exchange_rate = exchange_rate
        self.source_currency_code = source_currency_code
        self.target_currency_code = target_currency_code

    @property
    def result(self):
        """Gets the result of this ExchangeRateResponse.  # noqa: E501

        Designates if the response is a success ('OK') or failure ('ERR').  # noqa: E501

        :return: The result of this ExchangeRateResponse.  # noqa: E501
        :rtype: str
        """
        return self._result

    @result.setter
    def result(self, result):
        """Sets the result of this ExchangeRateResponse.

        Designates if the response is a success ('OK') or failure ('ERR').  # noqa: E501

        :param result: The result of this ExchangeRateResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and result is None:  # noqa: E501
            raise ValueError("Invalid value for `result`, must not be `None`")  # noqa: E501
        allowed_values = ["OK", "ERR"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and result not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `result` ({0}), must be one of {1}"  # noqa: E501
                .format(result, allowed_values)
            )

        self._result = result

    @property
    def exchange_rate(self):
        """Gets the exchange_rate of this ExchangeRateResponse.  # noqa: E501

        The exchange rate between the 2 currencies  # noqa: E501

        :return: The exchange_rate of this ExchangeRateResponse.  # noqa: E501
        :rtype: float
        """
        return self._exchange_rate

    @exchange_rate.setter
    def exchange_rate(self, exchange_rate):
        """Sets the exchange_rate of this ExchangeRateResponse.

        The exchange rate between the 2 currencies  # noqa: E501

        :param exchange_rate: The exchange_rate of this ExchangeRateResponse.  # noqa: E501
        :type: float
        """
        if self.local_vars_configuration.client_side_validation and exchange_rate is None:  # noqa: E501
            raise ValueError("Invalid value for `exchange_rate`, must not be `None`")  # noqa: E501

        self._exchange_rate = exchange_rate

    @property
    def source_currency_code(self):
        """Gets the source_currency_code of this ExchangeRateResponse.  # noqa: E501

        The ISO 4217 currency code that represents the source currency of the exchange rate.  # noqa: E501

        :return: The source_currency_code of this ExchangeRateResponse.  # noqa: E501
        :rtype: str
        """
        return self._source_currency_code

    @source_currency_code.setter
    def source_currency_code(self, source_currency_code):
        """Sets the source_currency_code of this ExchangeRateResponse.

        The ISO 4217 currency code that represents the source currency of the exchange rate.  # noqa: E501

        :param source_currency_code: The source_currency_code of this ExchangeRateResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and source_currency_code is None:  # noqa: E501
            raise ValueError("Invalid value for `source_currency_code`, must not be `None`")  # noqa: E501

        self._source_currency_code = source_currency_code

    @property
    def target_currency_code(self):
        """Gets the target_currency_code of this ExchangeRateResponse.  # noqa: E501

        The ISO 4217 currency code that represents the target currency of the exchange rate.  # noqa: E501

        :return: The target_currency_code of this ExchangeRateResponse.  # noqa: E501
        :rtype: str
        """
        return self._target_currency_code

    @target_currency_code.setter
    def target_currency_code(self, target_currency_code):
        """Sets the target_currency_code of this ExchangeRateResponse.

        The ISO 4217 currency code that represents the target currency of the exchange rate.  # noqa: E501

        :param target_currency_code: The target_currency_code of this ExchangeRateResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and target_currency_code is None:  # noqa: E501
            raise ValueError("Invalid value for `target_currency_code`, must not be `None`")  # noqa: E501

        self._target_currency_code = target_currency_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExchangeRateResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExchangeRateResponse):
            return True

        return self.to_dict() != other.to_dict()
