# coding: utf-8

"""
    Accounting Extension

    These APIs allow you to interact with HubSpot's Accounting Extension. It allows you to: * Specify the URLs that HubSpot will use when making webhook requests to your external accounting system. * Respond to webhook calls made to your external accounting system by HubSpot   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.extensions.accounting.configuration import Configuration


class Address(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'country': 'str',
        'country_sub_division_code': 'str',
        'city': 'str',
        'postal_code': 'str',
        'line_one': 'str'
    }

    attribute_map = {
        'country': 'country',
        'country_sub_division_code': 'countrySubDivisionCode',
        'city': 'city',
        'postal_code': 'postalCode',
        'line_one': 'lineOne'
    }

    def __init__(self, country=None, country_sub_division_code=None, city=None, postal_code=None, line_one=None, local_vars_configuration=None):  # noqa: E501
        """Address - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._country = None
        self._country_sub_division_code = None
        self._city = None
        self._postal_code = None
        self._line_one = None
        self.discriminator = None

        if country is not None:
            self.country = country
        if country_sub_division_code is not None:
            self.country_sub_division_code = country_sub_division_code
        if city is not None:
            self.city = city
        if postal_code is not None:
            self.postal_code = postal_code
        if line_one is not None:
            self.line_one = line_one

    @property
    def country(self):
        """Gets the country of this Address.  # noqa: E501

        The country of the address.  # noqa: E501

        :return: The country of this Address.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this Address.

        The country of the address.  # noqa: E501

        :param country: The country of this Address.  # noqa: E501
        :type: str
        """

        self._country = country

    @property
    def country_sub_division_code(self):
        """Gets the country_sub_division_code of this Address.  # noqa: E501

        A region of the county of the address.  May represent county, state etc.  # noqa: E501

        :return: The country_sub_division_code of this Address.  # noqa: E501
        :rtype: str
        """
        return self._country_sub_division_code

    @country_sub_division_code.setter
    def country_sub_division_code(self, country_sub_division_code):
        """Sets the country_sub_division_code of this Address.

        A region of the county of the address.  May represent county, state etc.  # noqa: E501

        :param country_sub_division_code: The country_sub_division_code of this Address.  # noqa: E501
        :type: str
        """

        self._country_sub_division_code = country_sub_division_code

    @property
    def city(self):
        """Gets the city of this Address.  # noqa: E501

        The city of the address.  # noqa: E501

        :return: The city of this Address.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this Address.

        The city of the address.  # noqa: E501

        :param city: The city of this Address.  # noqa: E501
        :type: str
        """

        self._city = city

    @property
    def postal_code(self):
        """Gets the postal_code of this Address.  # noqa: E501

        The postcode/zipcode of the address.  # noqa: E501

        :return: The postal_code of this Address.  # noqa: E501
        :rtype: str
        """
        return self._postal_code

    @postal_code.setter
    def postal_code(self, postal_code):
        """Sets the postal_code of this Address.

        The postcode/zipcode of the address.  # noqa: E501

        :param postal_code: The postal_code of this Address.  # noqa: E501
        :type: str
        """

        self._postal_code = postal_code

    @property
    def line_one(self):
        """Gets the line_one of this Address.  # noqa: E501

        The first line of the address.  # noqa: E501

        :return: The line_one of this Address.  # noqa: E501
        :rtype: str
        """
        return self._line_one

    @line_one.setter
    def line_one(self, line_one):
        """Sets the line_one of this Address.

        The first line of the address.  # noqa: E501

        :param line_one: The line_one of this Address.  # noqa: E501
        :type: str
        """

        self._line_one = line_one

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Address):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Address):
            return True

        return self.to_dict() != other.to_dict()
