# coding: utf-8

"""
    Accounting Extension

    These APIs allow you to interact with HubSpot's Accounting Extension. It allows you to: * Specify the URLs that HubSpot will use when making webhook requests to your external accounting system. * Respond to webhook calls made to your external accounting system by HubSpot   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.extensions.accounting.configuration import Configuration


class AccountingAppUrls(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'get_invoice_url': 'str',
        'search_customer_url': 'str',
        'get_invoice_pdf_url': 'str',
        'customer_url_template': 'str',
        'product_url_template': 'str',
        'invoice_url_template': 'str',
        'create_invoice_url': 'str',
        'search_invoice_url': 'str',
        'search_product_url': 'str',
        'get_terms_url': 'str',
        'create_customer_url': 'str',
        'search_tax_url': 'str',
        'exchange_rate_url': 'str',
        'search_url': 'str',
        'search_count_url': 'str'
    }

    attribute_map = {
        'get_invoice_url': 'getInvoiceUrl',
        'search_customer_url': 'searchCustomerUrl',
        'get_invoice_pdf_url': 'getInvoicePdfUrl',
        'customer_url_template': 'customerUrlTemplate',
        'product_url_template': 'productUrlTemplate',
        'invoice_url_template': 'invoiceUrlTemplate',
        'create_invoice_url': 'createInvoiceUrl',
        'search_invoice_url': 'searchInvoiceUrl',
        'search_product_url': 'searchProductUrl',
        'get_terms_url': 'getTermsUrl',
        'create_customer_url': 'createCustomerUrl',
        'search_tax_url': 'searchTaxUrl',
        'exchange_rate_url': 'exchangeRateUrl',
        'search_url': 'searchUrl',
        'search_count_url': 'searchCountUrl'
    }

    def __init__(self, get_invoice_url=None, search_customer_url=None, get_invoice_pdf_url=None, customer_url_template=None, product_url_template=None, invoice_url_template=None, create_invoice_url=None, search_invoice_url=None, search_product_url=None, get_terms_url=None, create_customer_url=None, search_tax_url=None, exchange_rate_url=None, search_url=None, search_count_url=None, local_vars_configuration=None):  # noqa: E501
        """AccountingAppUrls - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._get_invoice_url = None
        self._search_customer_url = None
        self._get_invoice_pdf_url = None
        self._customer_url_template = None
        self._product_url_template = None
        self._invoice_url_template = None
        self._create_invoice_url = None
        self._search_invoice_url = None
        self._search_product_url = None
        self._get_terms_url = None
        self._create_customer_url = None
        self._search_tax_url = None
        self._exchange_rate_url = None
        self._search_url = None
        self._search_count_url = None
        self.discriminator = None

        self.get_invoice_url = get_invoice_url
        self.search_customer_url = search_customer_url
        self.get_invoice_pdf_url = get_invoice_pdf_url
        self.customer_url_template = customer_url_template
        self.product_url_template = product_url_template
        self.invoice_url_template = invoice_url_template
        if create_invoice_url is not None:
            self.create_invoice_url = create_invoice_url
        if search_invoice_url is not None:
            self.search_invoice_url = search_invoice_url
        if search_product_url is not None:
            self.search_product_url = search_product_url
        if get_terms_url is not None:
            self.get_terms_url = get_terms_url
        if create_customer_url is not None:
            self.create_customer_url = create_customer_url
        if search_tax_url is not None:
            self.search_tax_url = search_tax_url
        if exchange_rate_url is not None:
            self.exchange_rate_url = exchange_rate_url
        if search_url is not None:
            self.search_url = search_url
        if search_count_url is not None:
            self.search_count_url = search_count_url

    @property
    def get_invoice_url(self):
        """Gets the get_invoice_url of this AccountingAppUrls.  # noqa: E501

        A URL that specifies the endpoint where invoices can be retrieved.  # noqa: E501

        :return: The get_invoice_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._get_invoice_url

    @get_invoice_url.setter
    def get_invoice_url(self, get_invoice_url):
        """Sets the get_invoice_url of this AccountingAppUrls.

        A URL that specifies the endpoint where invoices can be retrieved.  # noqa: E501

        :param get_invoice_url: The get_invoice_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and get_invoice_url is None:  # noqa: E501
            raise ValueError("Invalid value for `get_invoice_url`, must not be `None`")  # noqa: E501

        self._get_invoice_url = get_invoice_url

    @property
    def search_customer_url(self):
        """Gets the search_customer_url of this AccountingAppUrls.  # noqa: E501

        A URL that specifies the endpoint where a customer search can be performed.  # noqa: E501

        :return: The search_customer_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._search_customer_url

    @search_customer_url.setter
    def search_customer_url(self, search_customer_url):
        """Sets the search_customer_url of this AccountingAppUrls.

        A URL that specifies the endpoint where a customer search can be performed.  # noqa: E501

        :param search_customer_url: The search_customer_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and search_customer_url is None:  # noqa: E501
            raise ValueError("Invalid value for `search_customer_url`, must not be `None`")  # noqa: E501

        self._search_customer_url = search_customer_url

    @property
    def get_invoice_pdf_url(self):
        """Gets the get_invoice_pdf_url of this AccountingAppUrls.  # noqa: E501

        A URL that specifies the endpoint where an invoice PDF can be retrieved.  # noqa: E501

        :return: The get_invoice_pdf_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._get_invoice_pdf_url

    @get_invoice_pdf_url.setter
    def get_invoice_pdf_url(self, get_invoice_pdf_url):
        """Sets the get_invoice_pdf_url of this AccountingAppUrls.

        A URL that specifies the endpoint where an invoice PDF can be retrieved.  # noqa: E501

        :param get_invoice_pdf_url: The get_invoice_pdf_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and get_invoice_pdf_url is None:  # noqa: E501
            raise ValueError("Invalid value for `get_invoice_pdf_url`, must not be `None`")  # noqa: E501

        self._get_invoice_pdf_url = get_invoice_pdf_url

    @property
    def customer_url_template(self):
        """Gets the customer_url_template of this AccountingAppUrls.  # noqa: E501

        A template URL that indicates the endpoint where a customer can be fetched by ID. Note that ${CUSTOMER_ID} in this URL will be replaced by the actual customer ID. For example: https://myapp.com/api/customers/${CUSTOMER_ID}  # noqa: E501

        :return: The customer_url_template of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._customer_url_template

    @customer_url_template.setter
    def customer_url_template(self, customer_url_template):
        """Sets the customer_url_template of this AccountingAppUrls.

        A template URL that indicates the endpoint where a customer can be fetched by ID. Note that ${CUSTOMER_ID} in this URL will be replaced by the actual customer ID. For example: https://myapp.com/api/customers/${CUSTOMER_ID}  # noqa: E501

        :param customer_url_template: The customer_url_template of this AccountingAppUrls.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and customer_url_template is None:  # noqa: E501
            raise ValueError("Invalid value for `customer_url_template`, must not be `None`")  # noqa: E501

        self._customer_url_template = customer_url_template

    @property
    def product_url_template(self):
        """Gets the product_url_template of this AccountingAppUrls.  # noqa: E501

        A template URL that indicates the endpoint where a product can be fetched by ID. Note that ${PRODUCT_ID} in this URL will be replaced by the actual product ID. For example: https://myapp.com/api/products/${PRODUCT_ID}  # noqa: E501

        :return: The product_url_template of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._product_url_template

    @product_url_template.setter
    def product_url_template(self, product_url_template):
        """Sets the product_url_template of this AccountingAppUrls.

        A template URL that indicates the endpoint where a product can be fetched by ID. Note that ${PRODUCT_ID} in this URL will be replaced by the actual product ID. For example: https://myapp.com/api/products/${PRODUCT_ID}  # noqa: E501

        :param product_url_template: The product_url_template of this AccountingAppUrls.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and product_url_template is None:  # noqa: E501
            raise ValueError("Invalid value for `product_url_template`, must not be `None`")  # noqa: E501

        self._product_url_template = product_url_template

    @property
    def invoice_url_template(self):
        """Gets the invoice_url_template of this AccountingAppUrls.  # noqa: E501

        A template URL that indicates the endpoint where an invoice can be fetched by ID. Note that ${INVOICE_ID} in this URL will be replaced by the actual invoice ID. For example: https://myapp.com/api/invoices/${INVOICE_ID}  # noqa: E501

        :return: The invoice_url_template of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._invoice_url_template

    @invoice_url_template.setter
    def invoice_url_template(self, invoice_url_template):
        """Sets the invoice_url_template of this AccountingAppUrls.

        A template URL that indicates the endpoint where an invoice can be fetched by ID. Note that ${INVOICE_ID} in this URL will be replaced by the actual invoice ID. For example: https://myapp.com/api/invoices/${INVOICE_ID}  # noqa: E501

        :param invoice_url_template: The invoice_url_template of this AccountingAppUrls.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and invoice_url_template is None:  # noqa: E501
            raise ValueError("Invalid value for `invoice_url_template`, must not be `None`")  # noqa: E501

        self._invoice_url_template = invoice_url_template

    @property
    def create_invoice_url(self):
        """Gets the create_invoice_url of this AccountingAppUrls.  # noqa: E501

        A URL that specifies the endpoint where an invoices can be created.  # noqa: E501

        :return: The create_invoice_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._create_invoice_url

    @create_invoice_url.setter
    def create_invoice_url(self, create_invoice_url):
        """Sets the create_invoice_url of this AccountingAppUrls.

        A URL that specifies the endpoint where an invoices can be created.  # noqa: E501

        :param create_invoice_url: The create_invoice_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """

        self._create_invoice_url = create_invoice_url

    @property
    def search_invoice_url(self):
        """Gets the search_invoice_url of this AccountingAppUrls.  # noqa: E501

        A URL that specifies the endpoint where an invoice search can be performed.  # noqa: E501

        :return: The search_invoice_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._search_invoice_url

    @search_invoice_url.setter
    def search_invoice_url(self, search_invoice_url):
        """Sets the search_invoice_url of this AccountingAppUrls.

        A URL that specifies the endpoint where an invoice search can be performed.  # noqa: E501

        :param search_invoice_url: The search_invoice_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """

        self._search_invoice_url = search_invoice_url

    @property
    def search_product_url(self):
        """Gets the search_product_url of this AccountingAppUrls.  # noqa: E501

        A URL that specifies the endpoint where a product search can be performed.  # noqa: E501

        :return: The search_product_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._search_product_url

    @search_product_url.setter
    def search_product_url(self, search_product_url):
        """Sets the search_product_url of this AccountingAppUrls.

        A URL that specifies the endpoint where a product search can be performed.  # noqa: E501

        :param search_product_url: The search_product_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """

        self._search_product_url = search_product_url

    @property
    def get_terms_url(self):
        """Gets the get_terms_url of this AccountingAppUrls.  # noqa: E501

        A URL that specifies the endpoint where payment terms can be retrieved.  # noqa: E501

        :return: The get_terms_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._get_terms_url

    @get_terms_url.setter
    def get_terms_url(self, get_terms_url):
        """Sets the get_terms_url of this AccountingAppUrls.

        A URL that specifies the endpoint where payment terms can be retrieved.  # noqa: E501

        :param get_terms_url: The get_terms_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """

        self._get_terms_url = get_terms_url

    @property
    def create_customer_url(self):
        """Gets the create_customer_url of this AccountingAppUrls.  # noqa: E501

        A URL that specifies the endpoint where a new customer can be created.  # noqa: E501

        :return: The create_customer_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._create_customer_url

    @create_customer_url.setter
    def create_customer_url(self, create_customer_url):
        """Sets the create_customer_url of this AccountingAppUrls.

        A URL that specifies the endpoint where a new customer can be created.  # noqa: E501

        :param create_customer_url: The create_customer_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """

        self._create_customer_url = create_customer_url

    @property
    def search_tax_url(self):
        """Gets the search_tax_url of this AccountingAppUrls.  # noqa: E501

        A URL that specifies the endpoint where a tax search can be performed.  # noqa: E501

        :return: The search_tax_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._search_tax_url

    @search_tax_url.setter
    def search_tax_url(self, search_tax_url):
        """Sets the search_tax_url of this AccountingAppUrls.

        A URL that specifies the endpoint where a tax search can be performed.  # noqa: E501

        :param search_tax_url: The search_tax_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """

        self._search_tax_url = search_tax_url

    @property
    def exchange_rate_url(self):
        """Gets the exchange_rate_url of this AccountingAppUrls.  # noqa: E501

        A URL that specifies the endpoint where exchange rates can be queried.  # noqa: E501

        :return: The exchange_rate_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._exchange_rate_url

    @exchange_rate_url.setter
    def exchange_rate_url(self, exchange_rate_url):
        """Sets the exchange_rate_url of this AccountingAppUrls.

        A URL that specifies the endpoint where exchange rates can be queried.  # noqa: E501

        :param exchange_rate_url: The exchange_rate_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """

        self._exchange_rate_url = exchange_rate_url

    @property
    def search_url(self):
        """Gets the search_url of this AccountingAppUrls.  # noqa: E501


        :return: The search_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._search_url

    @search_url.setter
    def search_url(self, search_url):
        """Sets the search_url of this AccountingAppUrls.


        :param search_url: The search_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """

        self._search_url = search_url

    @property
    def search_count_url(self):
        """Gets the search_count_url of this AccountingAppUrls.  # noqa: E501


        :return: The search_count_url of this AccountingAppUrls.  # noqa: E501
        :rtype: str
        """
        return self._search_count_url

    @search_count_url.setter
    def search_count_url(self, search_count_url):
        """Sets the search_count_url of this AccountingAppUrls.


        :param search_count_url: The search_count_url of this AccountingAppUrls.  # noqa: E501
        :type: str
        """

        self._search_count_url = search_count_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountingAppUrls):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AccountingAppUrls):
            return True

        return self.to_dict() != other.to_dict()
