# coding: utf-8

"""
    Accounting Extension

    These APIs allow you to interact with HubSpot's Accounting Extension. It allows you to: * Specify the URLs that HubSpot will use when making webhook requests to your external accounting system. * Respond to webhook calls made to your external accounting system by HubSpot   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.crm.extensions.accounting.api_client import ApiClient
from hubspot.crm.extensions.accounting.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CallbacksApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_customer(self, request_id, result_id_accounting_response, **kwargs):  # noqa: E501
        """Endpoint for customer creation response  # noqa: E501

        Call this endpoint with the response to a customer creation request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer(request_id, result_id_accounting_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param ResultIdAccountingResponse result_id_accounting_response: The ID of the created customer. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_customer_with_http_info(request_id, result_id_accounting_response, **kwargs)  # noqa: E501

    def create_customer_with_http_info(self, request_id, result_id_accounting_response, **kwargs):  # noqa: E501
        """Endpoint for customer creation response  # noqa: E501

        Call this endpoint with the response to a customer creation request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_with_http_info(request_id, result_id_accounting_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param ResultIdAccountingResponse result_id_accounting_response: The ID of the created customer. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'result_id_accounting_response'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `create_customer`")  # noqa: E501
        # verify the required parameter 'result_id_accounting_response' is set
        if self.api_client.client_side_validation and ('result_id_accounting_response' not in local_var_params or  # noqa: E501
                                                        local_var_params['result_id_accounting_response'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `result_id_accounting_response` when calling `create_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['requestId'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'result_id_accounting_response' in local_var_params:
            body_params = local_var_params['result_id_accounting_response']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/crm/v3/extensions/accounting/callback/customer-create/{requestId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_exchange_rate(self, request_id, exchange_rate_response, **kwargs):  # noqa: E501
        """Endpoint for exchange rate response  # noqa: E501

        Call this endpoint with the response to an exchange rate request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_exchange_rate(request_id, exchange_rate_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param ExchangeRateResponse exchange_rate_response: The result of the exchange rate request. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_exchange_rate_with_http_info(request_id, exchange_rate_response, **kwargs)  # noqa: E501

    def create_exchange_rate_with_http_info(self, request_id, exchange_rate_response, **kwargs):  # noqa: E501
        """Endpoint for exchange rate response  # noqa: E501

        Call this endpoint with the response to an exchange rate request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_exchange_rate_with_http_info(request_id, exchange_rate_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param ExchangeRateResponse exchange_rate_response: The result of the exchange rate request. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'exchange_rate_response'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_exchange_rate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `create_exchange_rate`")  # noqa: E501
        # verify the required parameter 'exchange_rate_response' is set
        if self.api_client.client_side_validation and ('exchange_rate_response' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange_rate_response'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_rate_response` when calling `create_exchange_rate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['requestId'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'exchange_rate_response' in local_var_params:
            body_params = local_var_params['exchange_rate_response']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/crm/v3/extensions/accounting/callback/exchange-rate/{requestId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_invoice(self, request_id, result_id_accounting_response, **kwargs):  # noqa: E501
        """Endpoint for invoice creation response  # noqa: E501

        Call this endpoint with the response to a invoice creation request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_invoice(request_id, result_id_accounting_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param ResultIdAccountingResponse result_id_accounting_response: The ID of the created invoice. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_invoice_with_http_info(request_id, result_id_accounting_response, **kwargs)  # noqa: E501

    def create_invoice_with_http_info(self, request_id, result_id_accounting_response, **kwargs):  # noqa: E501
        """Endpoint for invoice creation response  # noqa: E501

        Call this endpoint with the response to a invoice creation request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_invoice_with_http_info(request_id, result_id_accounting_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param ResultIdAccountingResponse result_id_accounting_response: The ID of the created invoice. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'result_id_accounting_response'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `create_invoice`")  # noqa: E501
        # verify the required parameter 'result_id_accounting_response' is set
        if self.api_client.client_side_validation and ('result_id_accounting_response' not in local_var_params or  # noqa: E501
                                                        local_var_params['result_id_accounting_response'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `result_id_accounting_response` when calling `create_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['requestId'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'result_id_accounting_response' in local_var_params:
            body_params = local_var_params['result_id_accounting_response']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/crm/v3/extensions/accounting/callback/invoice-create/{requestId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_term(self, request_id, terms_response, **kwargs):  # noqa: E501
        """Endpoint for terms search response  # noqa: E501

        Call this endpoint with the response to a terms search request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_term(request_id, terms_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param TermsResponse terms_response: The result of the terms search (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_term_with_http_info(request_id, terms_response, **kwargs)  # noqa: E501

    def create_term_with_http_info(self, request_id, terms_response, **kwargs):  # noqa: E501
        """Endpoint for terms search response  # noqa: E501

        Call this endpoint with the response to a terms search request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_term_with_http_info(request_id, terms_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param TermsResponse terms_response: The result of the terms search (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'terms_response'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_term" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `create_term`")  # noqa: E501
        # verify the required parameter 'terms_response' is set
        if self.api_client.client_side_validation and ('terms_response' not in local_var_params or  # noqa: E501
                                                        local_var_params['terms_response'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `terms_response` when calling `create_term`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['requestId'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'terms_response' in local_var_params:
            body_params = local_var_params['terms_response']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/crm/v3/extensions/accounting/callback/terms/{requestId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def do_customer_search(self, request_id, customer_search_response_external, **kwargs):  # noqa: E501
        """Endpoint for customer search response  # noqa: E501

        Call this endpoint with the response to a customer search request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_customer_search(request_id, customer_search_response_external, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param CustomerSearchResponseExternal customer_search_response_external: The result of the customer search request. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.do_customer_search_with_http_info(request_id, customer_search_response_external, **kwargs)  # noqa: E501

    def do_customer_search_with_http_info(self, request_id, customer_search_response_external, **kwargs):  # noqa: E501
        """Endpoint for customer search response  # noqa: E501

        Call this endpoint with the response to a customer search request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_customer_search_with_http_info(request_id, customer_search_response_external, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param CustomerSearchResponseExternal customer_search_response_external: The result of the customer search request. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'customer_search_response_external'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method do_customer_search" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `do_customer_search`")  # noqa: E501
        # verify the required parameter 'customer_search_response_external' is set
        if self.api_client.client_side_validation and ('customer_search_response_external' not in local_var_params or  # noqa: E501
                                                        local_var_params['customer_search_response_external'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `customer_search_response_external` when calling `do_customer_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['requestId'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'customer_search_response_external' in local_var_params:
            body_params = local_var_params['customer_search_response_external']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/crm/v3/extensions/accounting/callback/customer-search/{requestId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def do_invoice_search(self, request_id, invoice_search_response, **kwargs):  # noqa: E501
        """Endpoint for invoice search response  # noqa: E501

        Call this endpoint with the response to a invoice search request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_invoice_search(request_id, invoice_search_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param InvoiceSearchResponse invoice_search_response: The result of the invoice search request. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.do_invoice_search_with_http_info(request_id, invoice_search_response, **kwargs)  # noqa: E501

    def do_invoice_search_with_http_info(self, request_id, invoice_search_response, **kwargs):  # noqa: E501
        """Endpoint for invoice search response  # noqa: E501

        Call this endpoint with the response to a invoice search request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_invoice_search_with_http_info(request_id, invoice_search_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param InvoiceSearchResponse invoice_search_response: The result of the invoice search request. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'invoice_search_response'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method do_invoice_search" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `do_invoice_search`")  # noqa: E501
        # verify the required parameter 'invoice_search_response' is set
        if self.api_client.client_side_validation and ('invoice_search_response' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice_search_response'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice_search_response` when calling `do_invoice_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['requestId'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invoice_search_response' in local_var_params:
            body_params = local_var_params['invoice_search_response']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/crm/v3/extensions/accounting/callback/invoice-search/{requestId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def do_product_search(self, request_id, product_search_response, **kwargs):  # noqa: E501
        """Endpoint for product search response  # noqa: E501

        Call this endpoint with the response to a product search request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_product_search(request_id, product_search_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param ProductSearchResponse product_search_response: The result of the product search request. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.do_product_search_with_http_info(request_id, product_search_response, **kwargs)  # noqa: E501

    def do_product_search_with_http_info(self, request_id, product_search_response, **kwargs):  # noqa: E501
        """Endpoint for product search response  # noqa: E501

        Call this endpoint with the response to a product search request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_product_search_with_http_info(request_id, product_search_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param ProductSearchResponse product_search_response: The result of the product search request. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'product_search_response'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method do_product_search" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `do_product_search`")  # noqa: E501
        # verify the required parameter 'product_search_response' is set
        if self.api_client.client_side_validation and ('product_search_response' not in local_var_params or  # noqa: E501
                                                        local_var_params['product_search_response'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `product_search_response` when calling `do_product_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['requestId'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'product_search_response' in local_var_params:
            body_params = local_var_params['product_search_response']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/crm/v3/extensions/accounting/callback/product-search/{requestId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def do_tax_search(self, request_id, tax_search_response, **kwargs):  # noqa: E501
        """Endpoint for taxes search response  # noqa: E501

        Call this endpoint with the response to a taxes search request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_tax_search(request_id, tax_search_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param TaxSearchResponse tax_search_response: The result of the taxes search request. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.do_tax_search_with_http_info(request_id, tax_search_response, **kwargs)  # noqa: E501

    def do_tax_search_with_http_info(self, request_id, tax_search_response, **kwargs):  # noqa: E501
        """Endpoint for taxes search response  # noqa: E501

        Call this endpoint with the response to a taxes search request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_tax_search_with_http_info(request_id, tax_search_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param TaxSearchResponse tax_search_response: The result of the taxes search request. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'tax_search_response'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method do_tax_search" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `do_tax_search`")  # noqa: E501
        # verify the required parameter 'tax_search_response' is set
        if self.api_client.client_side_validation and ('tax_search_response' not in local_var_params or  # noqa: E501
                                                        local_var_params['tax_search_response'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tax_search_response` when calling `do_tax_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['requestId'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_search_response' in local_var_params:
            body_params = local_var_params['tax_search_response']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/crm/v3/extensions/accounting/callback/tax-search/{requestId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_by_id(self, request_id, invoices_response_external, **kwargs):  # noqa: E501
        """Endpoint for invoice get-by-id response  # noqa: E501

        Call this endpoint with the response to a invoice get-by-id request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id(request_id, invoices_response_external, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param InvoicesResponseExternal invoices_response_external: The result of the invoice request. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_by_id_with_http_info(request_id, invoices_response_external, **kwargs)  # noqa: E501

    def get_by_id_with_http_info(self, request_id, invoices_response_external, **kwargs):  # noqa: E501
        """Endpoint for invoice get-by-id response  # noqa: E501

        Call this endpoint with the response to a invoice get-by-id request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id_with_http_info(request_id, invoices_response_external, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param InvoicesResponseExternal invoices_response_external: The result of the invoice request. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'invoices_response_external'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `get_by_id`")  # noqa: E501
        # verify the required parameter 'invoices_response_external' is set
        if self.api_client.client_side_validation and ('invoices_response_external' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoices_response_external'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoices_response_external` when calling `get_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['requestId'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invoices_response_external' in local_var_params:
            body_params = local_var_params['invoices_response_external']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/crm/v3/extensions/accounting/callback/invoices/{requestId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def invoice_pdf(self, request_id, invoice_pdf_response, **kwargs):  # noqa: E501
        """Endpoint for PDF content of invoice  # noqa: E501

        Call this endpoint with the PDF content of a requested invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoice_pdf(request_id, invoice_pdf_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param InvoicePdfResponse invoice_pdf_response: The bytes of the invoice PDF. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.invoice_pdf_with_http_info(request_id, invoice_pdf_response, **kwargs)  # noqa: E501

    def invoice_pdf_with_http_info(self, request_id, invoice_pdf_response, **kwargs):  # noqa: E501
        """Endpoint for PDF content of invoice  # noqa: E501

        Call this endpoint with the PDF content of a requested invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoice_pdf_with_http_info(request_id, invoice_pdf_response, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str request_id: The ID of the request that this response is for (required)
        :param InvoicePdfResponse invoice_pdf_response: The bytes of the invoice PDF. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'request_id',
            'invoice_pdf_response'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invoice_pdf" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_id` when calling `invoice_pdf`")  # noqa: E501
        # verify the required parameter 'invoice_pdf_response' is set
        if self.api_client.client_side_validation and ('invoice_pdf_response' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice_pdf_response'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice_pdf_response` when calling `invoice_pdf`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in local_var_params:
            path_params['requestId'] = local_var_params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invoice_pdf_response' in local_var_params:
            body_params = local_var_params['invoice_pdf_response']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/crm/v3/extensions/accounting/callback/invoice-pdf/{requestId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
