# coding: utf-8

"""
    Subscriptions

    Subscriptions allow contacts to control what forms of communications they receive. Contacts can decide whether they want to receive communication pertaining to a specific topic, brand, or an entire HubSpot account.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.communication_preferences.configuration import Configuration


class PublicSubscriptionStatusesResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'recipient': 'str',
        'subscription_statuses': 'list[PublicSubscriptionStatus]'
    }

    attribute_map = {
        'recipient': 'recipient',
        'subscription_statuses': 'subscriptionStatuses'
    }

    def __init__(self, recipient=None, subscription_statuses=None, local_vars_configuration=None):  # noqa: E501
        """PublicSubscriptionStatusesResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._recipient = None
        self._subscription_statuses = None
        self.discriminator = None

        self.recipient = recipient
        self.subscription_statuses = subscription_statuses

    @property
    def recipient(self):
        """Gets the recipient of this PublicSubscriptionStatusesResponse.  # noqa: E501

        Email address of the contact.  # noqa: E501

        :return: The recipient of this PublicSubscriptionStatusesResponse.  # noqa: E501
        :rtype: str
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient):
        """Sets the recipient of this PublicSubscriptionStatusesResponse.

        Email address of the contact.  # noqa: E501

        :param recipient: The recipient of this PublicSubscriptionStatusesResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and recipient is None:  # noqa: E501
            raise ValueError("Invalid value for `recipient`, must not be `None`")  # noqa: E501

        self._recipient = recipient

    @property
    def subscription_statuses(self):
        """Gets the subscription_statuses of this PublicSubscriptionStatusesResponse.  # noqa: E501

        A list of all of the contact's subscriptions statuses.  # noqa: E501

        :return: The subscription_statuses of this PublicSubscriptionStatusesResponse.  # noqa: E501
        :rtype: list[PublicSubscriptionStatus]
        """
        return self._subscription_statuses

    @subscription_statuses.setter
    def subscription_statuses(self, subscription_statuses):
        """Sets the subscription_statuses of this PublicSubscriptionStatusesResponse.

        A list of all of the contact's subscriptions statuses.  # noqa: E501

        :param subscription_statuses: The subscription_statuses of this PublicSubscriptionStatusesResponse.  # noqa: E501
        :type: list[PublicSubscriptionStatus]
        """
        if self.local_vars_configuration.client_side_validation and subscription_statuses is None:  # noqa: E501
            raise ValueError("Invalid value for `subscription_statuses`, must not be `None`")  # noqa: E501

        self._subscription_statuses = subscription_statuses

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PublicSubscriptionStatusesResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PublicSubscriptionStatusesResponse):
            return True

        return self.to_dict() != other.to_dict()
