# coding: utf-8

"""
    HubDB endpoints

    HubDB is a relational data store that presents data as rows, columns, and cells in a table, much like a spreadsheet. HubDB tables can be added or modified [in the HubSpot CMS](https://knowledge.hubspot.com/cos-general/how-to-edit-hubdb-tables), but you can also use the API endpoints documented here. For more information on HubDB tables and using their data on a HubSpot site, see the [CMS developers site](https://designers.hubspot.com/docs/tools/hubdb). You can also see the [documentation for dynamic pages](https://designers.hubspot.com/docs/tutorials/how-to-build-dynamic-pages-with-hubdb) for more details about the `useForPages` field.  HubDB tables support `draft` and `live` versions and you can publish and unpublish the live version. This allows you to update data in the table, either for testing or to allow for a manual approval process, without affecting any live pages using the existing data. Draft data can be reviewed, pushed to live version, and published by a user working in HubSpot or published via the API. Draft data can also be discarded, allowing users to go back to the live version of the data without disrupting it. If a table is set to be `allowed for public access`, you can access the published version of the table and rows without any authentication by specifying the portal id via the query parameter `portalId`.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.cms.hubdb.api_client import ApiClient
from hubspot.cms.hubdb.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RowsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def clone_draft_table_row(self, row_id, table_id_or_name, **kwargs):  # noqa: E501
        """Clone a row  # noqa: E501

        Clones a single row in the `draft` version of the table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_draft_table_row(row_id, table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clone_draft_table_row_with_http_info(row_id, table_id_or_name, **kwargs)  # noqa: E501

    def clone_draft_table_row_with_http_info(self, row_id, table_id_or_name, **kwargs):  # noqa: E501
        """Clone a row  # noqa: E501

        Clones a single row in the `draft` version of the table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_draft_table_row_with_http_info(row_id, table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'row_id',
            'table_id_or_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_draft_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and ('row_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['row_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `row_id` when calling `clone_draft_table_row`")  # noqa: E501
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ('table_id_or_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_id_or_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `clone_draft_table_row`")  # noqa: E501

        if self.api_client.client_side_validation and 'row_id' in local_var_params and not re.search(r'\d+', local_var_params['row_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `row_id` when calling `clone_draft_table_row`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'row_id' in local_var_params:
            path_params['rowId'] = local_var_params['row_id']  # noqa: E501
        if 'table_id_or_name' in local_var_params:
            path_params['tableIdOrName'] = local_var_params['table_id_or_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}/draft/clone', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HubDbTableRowV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_table_row(self, table_id_or_name, hub_db_table_row_v3_input, **kwargs):  # noqa: E501
        """Add a new row to a table  # noqa: E501

        Add a new row to a HubDB table. New rows will be added to the `draft` version of the table. Use `push-live` endpoint to push these changes to live version and publish them.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_table_row(table_id_or_name, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the target table. (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The row definition JSON, formatted as described above. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_table_row_with_http_info(table_id_or_name, hub_db_table_row_v3_input, **kwargs)  # noqa: E501

    def create_table_row_with_http_info(self, table_id_or_name, hub_db_table_row_v3_input, **kwargs):  # noqa: E501
        """Add a new row to a table  # noqa: E501

        Add a new row to a HubDB table. New rows will be added to the `draft` version of the table. Use `push-live` endpoint to push these changes to live version and publish them.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_table_row_with_http_info(table_id_or_name, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the target table. (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The row definition JSON, formatted as described above. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'table_id_or_name',
            'hub_db_table_row_v3_input'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ('table_id_or_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_id_or_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `create_table_row`")  # noqa: E501
        # verify the required parameter 'hub_db_table_row_v3_input' is set
        if self.api_client.client_side_validation and ('hub_db_table_row_v3_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['hub_db_table_row_v3_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `hub_db_table_row_v3_input` when calling `create_table_row`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'table_id_or_name' in local_var_params:
            path_params['tableIdOrName'] = local_var_params['table_id_or_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hub_db_table_row_v3_input' in local_var_params:
            body_params = local_var_params['hub_db_table_row_v3_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/cms/v3/hubdb/tables/{tableIdOrName}/rows', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HubDbTableRowV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_draft_table_row_by_id(self, row_id, table_id_or_name, **kwargs):  # noqa: E501
        """Get a row from the draft table  # noqa: E501

        Get a single row by ID from a table's `draft` version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_table_row_by_id(row_id, table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_draft_table_row_by_id_with_http_info(row_id, table_id_or_name, **kwargs)  # noqa: E501

    def get_draft_table_row_by_id_with_http_info(self, row_id, table_id_or_name, **kwargs):  # noqa: E501
        """Get a row from the draft table  # noqa: E501

        Get a single row by ID from a table's `draft` version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_table_row_by_id_with_http_info(row_id, table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'row_id',
            'table_id_or_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_draft_table_row_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and ('row_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['row_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `row_id` when calling `get_draft_table_row_by_id`")  # noqa: E501
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ('table_id_or_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_id_or_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `get_draft_table_row_by_id`")  # noqa: E501

        if self.api_client.client_side_validation and 'row_id' in local_var_params and not re.search(r'\d+', local_var_params['row_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `row_id` when calling `get_draft_table_row_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'row_id' in local_var_params:
            path_params['rowId'] = local_var_params['row_id']  # noqa: E501
        if 'table_id_or_name' in local_var_params:
            path_params['tableIdOrName'] = local_var_params['table_id_or_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}/draft', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HubDbTableRowV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_table_row(self, row_id, table_id_or_name, **kwargs):  # noqa: E501
        """Get a table row  # noqa: E501

        Get a single row by ID from a table's `live` version. **Note:** This endpoint can be accessed without any authentication, if the table is set to be allowed for public access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_table_row(row_id, table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_table_row_with_http_info(row_id, table_id_or_name, **kwargs)  # noqa: E501

    def get_table_row_with_http_info(self, row_id, table_id_or_name, **kwargs):  # noqa: E501
        """Get a table row  # noqa: E501

        Get a single row by ID from a table's `live` version. **Note:** This endpoint can be accessed without any authentication, if the table is set to be allowed for public access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_table_row_with_http_info(row_id, table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'row_id',
            'table_id_or_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and ('row_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['row_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `row_id` when calling `get_table_row`")  # noqa: E501
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ('table_id_or_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_id_or_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `get_table_row`")  # noqa: E501

        if self.api_client.client_side_validation and 'row_id' in local_var_params and not re.search(r'\d+', local_var_params['row_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `row_id` when calling `get_table_row`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'row_id' in local_var_params:
            path_params['rowId'] = local_var_params['row_id']  # noqa: E501
        if 'table_id_or_name' in local_var_params:
            path_params['tableIdOrName'] = local_var_params['table_id_or_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HubDbTableRowV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_table_rows(self, table_id_or_name, **kwargs):  # noqa: E501
        """Get rows for a table  # noqa: E501

        Returns a set of rows in the `live` version of the specified table. Row results can be filtered and sorted. Refer to the overview section for detailed filtering and sorting options. **Note:** This endpoint can be accessed without any authentication, if the table is set to be allowed for public access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_table_rows(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to query. (required)
        :param list[str] properties: Specify the column names to get results containing only the required columns instead of all column details.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param int limit: The maximum number of results to return. Default is `1000`.
        :param list[str] sort: Specifies the column names to sort the results by. See the above description for more details.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseWithTotalHubDbTableRowV3ForwardPaging
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_table_rows_with_http_info(table_id_or_name, **kwargs)  # noqa: E501

    def get_table_rows_with_http_info(self, table_id_or_name, **kwargs):  # noqa: E501
        """Get rows for a table  # noqa: E501

        Returns a set of rows in the `live` version of the specified table. Row results can be filtered and sorted. Refer to the overview section for detailed filtering and sorting options. **Note:** This endpoint can be accessed without any authentication, if the table is set to be allowed for public access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_table_rows_with_http_info(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to query. (required)
        :param list[str] properties: Specify the column names to get results containing only the required columns instead of all column details.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param int limit: The maximum number of results to return. Default is `1000`.
        :param list[str] sort: Specifies the column names to sort the results by. See the above description for more details.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseWithTotalHubDbTableRowV3ForwardPaging, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'table_id_or_name',
            'properties',
            'after',
            'limit',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table_rows" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ('table_id_or_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_id_or_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `get_table_rows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'table_id_or_name' in local_var_params:
            path_params['tableIdOrName'] = local_var_params['table_id_or_name']  # noqa: E501

        query_params = []
        if 'properties' in local_var_params and local_var_params['properties'] is not None:  # noqa: E501
            query_params.append(('properties', local_var_params['properties']))  # noqa: E501
            collection_formats['properties'] = 'multi'  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/cms/v3/hubdb/tables/{tableIdOrName}/rows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionResponseWithTotalHubDbTableRowV3ForwardPaging',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def purge_draft_table_row(self, row_id, table_id_or_name, **kwargs):  # noqa: E501
        """Permanently deletes a row  # noqa: E501

        Permanently deletes a row from a table's `draft` version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.purge_draft_table_row(row_id, table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.purge_draft_table_row_with_http_info(row_id, table_id_or_name, **kwargs)  # noqa: E501

    def purge_draft_table_row_with_http_info(self, row_id, table_id_or_name, **kwargs):  # noqa: E501
        """Permanently deletes a row  # noqa: E501

        Permanently deletes a row from a table's `draft` version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.purge_draft_table_row_with_http_info(row_id, table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'row_id',
            'table_id_or_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method purge_draft_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and ('row_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['row_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `row_id` when calling `purge_draft_table_row`")  # noqa: E501
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ('table_id_or_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_id_or_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `purge_draft_table_row`")  # noqa: E501

        if self.api_client.client_side_validation and 'row_id' in local_var_params and not re.search(r'\d+', local_var_params['row_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `row_id` when calling `purge_draft_table_row`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'row_id' in local_var_params:
            path_params['rowId'] = local_var_params['row_id']  # noqa: E501
        if 'table_id_or_name' in local_var_params:
            path_params['tableIdOrName'] = local_var_params['table_id_or_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}/draft', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read_draft_table_rows(self, table_id_or_name, **kwargs):  # noqa: E501
        """Get rows from draft table  # noqa: E501

        Returns rows in the `draft` version of the specified table. Row results can be filtered and sorted using the options mentioned in the overview section.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_draft_table_rows(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to query. (required)
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param list[str] properties: Specify the column names to get results containing only the required columns instead of all column details. If you want to include multiple columns in the result, use this query param as many times. 
        :param int limit: The maximum number of results to return. Default is `1000`.
        :param list[str] sort: Specifies the column names to sort the results by.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseWithTotalHubDbTableRowV3ForwardPaging
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.read_draft_table_rows_with_http_info(table_id_or_name, **kwargs)  # noqa: E501

    def read_draft_table_rows_with_http_info(self, table_id_or_name, **kwargs):  # noqa: E501
        """Get rows from draft table  # noqa: E501

        Returns rows in the `draft` version of the specified table. Row results can be filtered and sorted using the options mentioned in the overview section.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_draft_table_rows_with_http_info(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to query. (required)
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param list[str] properties: Specify the column names to get results containing only the required columns instead of all column details. If you want to include multiple columns in the result, use this query param as many times. 
        :param int limit: The maximum number of results to return. Default is `1000`.
        :param list[str] sort: Specifies the column names to sort the results by.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseWithTotalHubDbTableRowV3ForwardPaging, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'table_id_or_name',
            'after',
            'properties',
            'limit',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_draft_table_rows" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ('table_id_or_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_id_or_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `read_draft_table_rows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'table_id_or_name' in local_var_params:
            path_params['tableIdOrName'] = local_var_params['table_id_or_name']  # noqa: E501

        query_params = []
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'properties' in local_var_params and local_var_params['properties'] is not None:  # noqa: E501
            query_params.append(('properties', local_var_params['properties']))  # noqa: E501
            collection_formats['properties'] = 'multi'  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionResponseWithTotalHubDbTableRowV3ForwardPaging',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_draft_table_row(self, row_id, table_id_or_name, hub_db_table_row_v3_input, **kwargs):  # noqa: E501
        """Replaces an existing row  # noqa: E501

        Replace a single row in the table's `draft` version. All the column values must be specified. If a column has a value in the target table and this request doesn't define that value, it will be deleted. See the `Create a row` endpoint for instructions on how to format the JSON row definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_draft_table_row(row_id, table_id_or_name, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The JSON object of the row (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.replace_draft_table_row_with_http_info(row_id, table_id_or_name, hub_db_table_row_v3_input, **kwargs)  # noqa: E501

    def replace_draft_table_row_with_http_info(self, row_id, table_id_or_name, hub_db_table_row_v3_input, **kwargs):  # noqa: E501
        """Replaces an existing row  # noqa: E501

        Replace a single row in the table's `draft` version. All the column values must be specified. If a column has a value in the target table and this request doesn't define that value, it will be deleted. See the `Create a row` endpoint for instructions on how to format the JSON row definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_draft_table_row_with_http_info(row_id, table_id_or_name, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The JSON object of the row (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'row_id',
            'table_id_or_name',
            'hub_db_table_row_v3_input'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_draft_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and ('row_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['row_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `row_id` when calling `replace_draft_table_row`")  # noqa: E501
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ('table_id_or_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_id_or_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `replace_draft_table_row`")  # noqa: E501
        # verify the required parameter 'hub_db_table_row_v3_input' is set
        if self.api_client.client_side_validation and ('hub_db_table_row_v3_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['hub_db_table_row_v3_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `hub_db_table_row_v3_input` when calling `replace_draft_table_row`")  # noqa: E501

        if self.api_client.client_side_validation and 'row_id' in local_var_params and not re.search(r'\d+', local_var_params['row_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `row_id` when calling `replace_draft_table_row`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'row_id' in local_var_params:
            path_params['rowId'] = local_var_params['row_id']  # noqa: E501
        if 'table_id_or_name' in local_var_params:
            path_params['tableIdOrName'] = local_var_params['table_id_or_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hub_db_table_row_v3_input' in local_var_params:
            body_params = local_var_params['hub_db_table_row_v3_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}/draft', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HubDbTableRowV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_draft_table_row(self, row_id, table_id_or_name, hub_db_table_row_v3_input, **kwargs):  # noqa: E501
        """Updates an existing row  # noqa: E501

        Sparse updates a single row in the table's `draft` version. All the column values need not be specified. Only the columns or fields that needs to be modified can be specified. See the `Create a row` endpoint for instructions on how to format the JSON row definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_draft_table_row(row_id, table_id_or_name, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The JSON object of the row with necessary fields that needs to be updated. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_draft_table_row_with_http_info(row_id, table_id_or_name, hub_db_table_row_v3_input, **kwargs)  # noqa: E501

    def update_draft_table_row_with_http_info(self, row_id, table_id_or_name, hub_db_table_row_v3_input, **kwargs):  # noqa: E501
        """Updates an existing row  # noqa: E501

        Sparse updates a single row in the table's `draft` version. All the column values need not be specified. Only the columns or fields that needs to be modified can be specified. See the `Create a row` endpoint for instructions on how to format the JSON row definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_draft_table_row_with_http_info(row_id, table_id_or_name, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id_or_name: The ID or name of the table (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The JSON object of the row with necessary fields that needs to be updated. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'row_id',
            'table_id_or_name',
            'hub_db_table_row_v3_input'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_draft_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and ('row_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['row_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `row_id` when calling `update_draft_table_row`")  # noqa: E501
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ('table_id_or_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['table_id_or_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `update_draft_table_row`")  # noqa: E501
        # verify the required parameter 'hub_db_table_row_v3_input' is set
        if self.api_client.client_side_validation and ('hub_db_table_row_v3_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['hub_db_table_row_v3_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `hub_db_table_row_v3_input` when calling `update_draft_table_row`")  # noqa: E501

        if self.api_client.client_side_validation and 'row_id' in local_var_params and not re.search(r'\d+', local_var_params['row_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `row_id` when calling `update_draft_table_row`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'row_id' in local_var_params:
            path_params['rowId'] = local_var_params['row_id']  # noqa: E501
        if 'table_id_or_name' in local_var_params:
            path_params['tableIdOrName'] = local_var_params['table_id_or_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hub_db_table_row_v3_input' in local_var_params:
            body_params = local_var_params['hub_db_table_row_v3_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['hapikey', 'oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}/draft', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HubDbTableRowV3',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
