# coding: utf-8

"""
    Custom Workflow Actions

    Create custom workflow actions  # noqa: E501

    The version of the OpenAPI document: v4
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.automation.actions.configuration import Configuration


class FieldTypeDefinition(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'type': 'str',
        'field_type': 'str',
        'options': 'list[Option]',
        'options_url': 'str',
        'referenced_object_type': 'str'
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'field_type': 'fieldType',
        'options': 'options',
        'options_url': 'optionsUrl',
        'referenced_object_type': 'referencedObjectType'
    }

    def __init__(self, name=None, type=None, field_type=None, options=None, options_url=None, referenced_object_type=None, local_vars_configuration=None):  # noqa: E501
        """FieldTypeDefinition - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._type = None
        self._field_type = None
        self._options = None
        self._options_url = None
        self._referenced_object_type = None
        self.discriminator = None

        self.name = name
        self.type = type
        if field_type is not None:
            self.field_type = field_type
        self.options = options
        if options_url is not None:
            self.options_url = options_url
        if referenced_object_type is not None:
            self.referenced_object_type = referenced_object_type

    @property
    def name(self):
        """Gets the name of this FieldTypeDefinition.  # noqa: E501

        The input field name.  # noqa: E501

        :return: The name of this FieldTypeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this FieldTypeDefinition.

        The input field name.  # noqa: E501

        :param name: The name of this FieldTypeDefinition.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def type(self):
        """Gets the type of this FieldTypeDefinition.  # noqa: E501

        The data type of the field.  # noqa: E501

        :return: The type of this FieldTypeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this FieldTypeDefinition.

        The data type of the field.  # noqa: E501

        :param type: The type of this FieldTypeDefinition.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["string", "number", "bool", "datetime", "enumeration", "date", "phone_number", "currency_number", "json", "object_coordinates"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def field_type(self):
        """Gets the field_type of this FieldTypeDefinition.  # noqa: E501

        Controls how the field appears in HubSpot.  # noqa: E501

        :return: The field_type of this FieldTypeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._field_type

    @field_type.setter
    def field_type(self, field_type):
        """Sets the field_type of this FieldTypeDefinition.

        Controls how the field appears in HubSpot.  # noqa: E501

        :param field_type: The field_type of this FieldTypeDefinition.  # noqa: E501
        :type: str
        """
        allowed_values = ["booleancheckbox", "checkbox", "date", "file", "number", "phonenumber", "radio", "select", "text", "textarea", "calculation_equation", "calculation_rollup", "calculation_score", "calculation_read_time", "unknown"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and field_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `field_type` ({0}), must be one of {1}"  # noqa: E501
                .format(field_type, allowed_values)
            )

        self._field_type = field_type

    @property
    def options(self):
        """Gets the options of this FieldTypeDefinition.  # noqa: E501

        A list of valid options for the field value.  # noqa: E501

        :return: The options of this FieldTypeDefinition.  # noqa: E501
        :rtype: list[Option]
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this FieldTypeDefinition.

        A list of valid options for the field value.  # noqa: E501

        :param options: The options of this FieldTypeDefinition.  # noqa: E501
        :type: list[Option]
        """
        if self.local_vars_configuration.client_side_validation and options is None:  # noqa: E501
            raise ValueError("Invalid value for `options`, must not be `None`")  # noqa: E501

        self._options = options

    @property
    def options_url(self):
        """Gets the options_url of this FieldTypeDefinition.  # noqa: E501

        A URL that will accept HTTPS requests when the valid options for the field are fetched.  # noqa: E501

        :return: The options_url of this FieldTypeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._options_url

    @options_url.setter
    def options_url(self, options_url):
        """Sets the options_url of this FieldTypeDefinition.

        A URL that will accept HTTPS requests when the valid options for the field are fetched.  # noqa: E501

        :param options_url: The options_url of this FieldTypeDefinition.  # noqa: E501
        :type: str
        """

        self._options_url = options_url

    @property
    def referenced_object_type(self):
        """Gets the referenced_object_type of this FieldTypeDefinition.  # noqa: E501

        This can be set to `OWNER` if the field should contain a HubSpot owner value.  # noqa: E501

        :return: The referenced_object_type of this FieldTypeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._referenced_object_type

    @referenced_object_type.setter
    def referenced_object_type(self, referenced_object_type):
        """Sets the referenced_object_type of this FieldTypeDefinition.

        This can be set to `OWNER` if the field should contain a HubSpot owner value.  # noqa: E501

        :param referenced_object_type: The referenced_object_type of this FieldTypeDefinition.  # noqa: E501
        :type: str
        """
        allowed_values = ["CONTACT", "COMPANY", "DEAL", "ENGAGEMENT", "TICKET", "OWNER", "PRODUCT", "LINE_ITEM", "BET_DELIVERABLE_SERVICE", "CONTENT", "CONVERSATION", "BET_ALERT", "PORTAL", "QUOTE", "FORM_SUBMISSION_INBOUNDDB", "QUOTA", "UNSUBSCRIBE", "COMMUNICATION", "FEEDBACK_SUBMISSION", "ATTRIBUTION", "SALESFORCE_SYNC_ERROR", "RESTORABLE_CRM_OBJECT", "HUB", "LANDING_PAGE", "PRODUCT_OR_FOLDER", "TASK", "FORM", "MARKETING_EMAIL", "AD_ACCOUNT", "AD_CAMPAIGN", "AD_GROUP", "AD", "KEYWORD", "CAMPAIGN", "SOCIAL_CHANNEL", "SOCIAL_POST", "SITE_PAGE", "BLOG_POST", "IMPORT", "EXPORT", "CTA", "TASK_TEMPLATE", "AUTOMATION_PLATFORM_FLOW", "OBJECT_LIST", "NOTE", "MEETING_EVENT", "CALL", "EMAIL", "PUBLISHING_TASK", "CONVERSATION_SESSION", "CONTACT_CREATE_ATTRIBUTION", "INVOICE", "MARKETING_EVENT", "CONVERSATION_INBOX", "CHATFLOW", "MEDIA_BRIDGE", "SEQUENCE", "SEQUENCE_STEP", "FORECAST", "SNIPPET", "TEMPLATE", "UNKNOWN"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and referenced_object_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `referenced_object_type` ({0}), must be one of {1}"  # noqa: E501
                .format(referenced_object_type, allowed_values)
            )

        self._referenced_object_type = referenced_object_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FieldTypeDefinition):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FieldTypeDefinition):
            return True

        return self.to_dict() != other.to_dict()
