#!/bin/bash
#
# This shell script prepares the data, s.t. Proper can handle it better
#
# use -help to see options
#
# FracPete

# the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -i <input-dir> -o <output-dir> [-h]"
   echo 
   echo "removes entries with 'unknown' as ID and changes the 'thrombosis'"
   echo "value from 0-3 to A-D"
   echo
   echo " -h   this help"
   echo " -i   <input-dir>"
   echo "      the directory where the data is located"
   echo "      default: $SRC"
   echo " -o   <output-dir>"
   echo "      where to put the processed files"
   echo "      default: $DEST"
   echo
}

# cleans up temporary files
function clean_up
{
   rm -f _*
}


# variables
ROOT=`expr "$0" : '\(.*\)/'`
SRC="$ROOT/original"
DEST="$ROOT"

# interprete parameters
while getopts ":hi:o:" flag
do
   case $flag in
      i) SRC=$OPTARG
         ;;
      o) DEST=$OPTARG
         ;;
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# remove lines with 'unknown'
echo "fixing data..."
for i in $SRC/*.txt
do
   FILE=${i##*/}
   echo "- $FILE"
   if [ "$FILE" = "spc_exam.txt" ]
   then
      cat $i | grep -iv "unknown" | sed s/"0"$/A/g | sed s/"1"$/B/g | sed s/"2"$/C/g | sed s/"3"$/D/g > $DEST/$FILE
   else
      cat $i | grep -iv "unknown" > $DEST/$FILE
   fi
done
