#!/bin/bash

# this scripts installs Proper
#
# $Revision: 1.7 $
# FracPete

# the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -d <dest-dir> -H <db-host> -P <db-port> -u <db-user>"
   echo "       -p <db-password> -a -t <type> [-h]"
   echo 
   echo "performs the installation of Proper $VERSION"
   echo
   echo " -h   this help"
   echo " -d   <dest-dir>"
   echo "      where to install Proper to"
   echo "      default: $DEST"
   echo " -H   <db-host>"
   echo "      the Datbase host"
   echo "      default: $DBHOST"
   echo " -P   <db-port>"
   echo "      the port the DB-Server listens on"
   echo "      default: $DBPORT"
   echo " -u   <db-user>"
   echo "      the user for accessing the DB"
   echo "      default: $DBUSER"
   echo " -p   <db-password>"
   echo "      the password of the user"
   echo "      default: $DBPASSWORD"
   echo " -a   performs automatic install without any interaction"
   echo " -t   <type>"
   echo "      the database type, can be either 'mysql' or 'postgresql'"
   echo "      default: $DBTYPE"
   echo " -b   <dbname>"
   echo "      the name of the database"
   echo "      default: $DBNAME"
   echo
}

# performs some checks
function check()
{
   if [ "$ANT_HOME" = "" ] || [ ! -d $ANT_HOME ]
   then
      echo "Environment-variable ANT_HOME is not set or not valid!";
      exit 2
   fi

   if [ "$JAVA_HOME" = "" ] || [ ! -d $JAVA_HOME ]
   then
      echo "Environment-variable JAVA_HOME is not set or not valid!";
      exit 3
   fi

   if [ ! "$DBTYPE" = "mysql" ] && [ ! "$DBTYPE" = "postgresql" ]
   then
      echo "Database type not set correctly!";
      exit 4
   fi
}

# prints the text in "TMP" and returns the entered value in "TMP", if that is 
# empty it returns the value in "DEFAULT"
function getValue()
{
   echo -en "\n$TMP"
   read TMP
   if [ "$TMP" = "" ]
   then
      TMP="$DEFAULT"
   fi
}

# changes the property "TMP" in the XML file "FILE" and sets the value to 
# "VALUE"
function changeValue()
{
   cat $FILE | sed s/"property name=\"$TMP\".*value=\".*\""/"property name=\"$TMP\" value=\"$VALUE\""/g > _$FILE
   rm $FILE
   mv _$FILE $FILE
}

# copies the file FROM to TO
function copyFile()
{
   if [ "$FROM" != "$TO" ] #&& [ ! "$FROM" -ef "$TO" ]
   then
	  echo "Copying file from $FROM to $TO ...";
      cp "$FROM" "$TO"
   fi
}

# some variables
ROOT="`pwd`"
ANT=$ANT_HOME/bin/ant
DEST="$HOME/proper"
DBTYPE="postgresql"
DBHOST="localhost"
DBPORT="3306"
DBUSER="$USER"
DBNAME="wekaproperdb"
DBPASSWORD=""
INTERACTIVE="yes"
DBPORT_SET="no"
if [ -f "$ROOT/VERSION" ]
then
   VERSION=`cat "$ROOT/VERSION" | tr -d '[[:space:]]'`
fi

# interprete parameters
while getopts ":hd:H:P:u:p:t:a:b" flag
do
   case $flag in
      d) DEST="$OPTARG"
         ;;
      H) DBHOST="$OPTARG"
         ;;
      P) DBPORT=$OPTARG
         DBPORT_SET="yes"
         ;;
      u) DBUSER="$OPTARG"
         ;;
      p) DBPASSWORD=$OPTARG
         ;;
      t) DBTYPE="$OPTARG"
         ;;
      a) INTERACTIVE="no"
         ;;
      b) DBNAME="$OPTARG"
	  ;;
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# some tests
check

# start
echo 
echo "Installation of WEKA Proper $VERSION"
echo "-- the Propositionalization Toolbox for Weka (by FracPete)"
echo
echo
echo "Thanks to Mark-A. Krogel for RELAGGS (krogel@iws.cs.uni-magdeburg.de)"
echo
echo
if [ "$INTERACTIVE" = "yes" ]
then
   echo "You can exit this installation with Ctrl+C..."
else
   echo "Starting automatic installation..."
fi
echo

if [ "$INTERACTIVE" = "yes" ]
then
   # get the directory where to install to
   DEFAULT="$DEST"
   TMP="Where do you want to install Proper to [$DEFAULT]? "
   getValue;DEST="$TMP"

   # get the DB type
   DEFAULT="$DBTYPE"
   TMP="What type of database Server (mysql/postgresql) [$DEFAULT]? "
   getValue;DBTYPE="$TMP"

   # change port to fit DB
   if [ "$DBPORT_SET" = "no" ]
   then
      if [ "$DBTYPE" = "mysql" ]
      then
         DBPORT="3306"
      else
         DBPORT="5432"
      fi
   fi

   # get the DB-host
   DEFAULT="$DBHOST"
   TMP="What is the hostname of the $DBTYPE Server [$DEFAULT]? "
   getValue;DBHOST="$TMP"

   # get the DB-Port
   DEFAULT=$DBPORT
   TMP="What is the port of the $DBTYPE Server [$DEFAULT]? "
   getValue;DBPORT=$TMP

   # get the user
   DEFAULT="$DBUSER"
   TMP="Which user is allowed to connect to the $DBTYPE Server [$DEFAULT]? "
   getValue;DBUSER="$TMP"

   # get the password
   DEFAULT=$DBPASSWORD
   TMP="What is the password of the user [$DEFAULT]? "
   getValue;DBPASSWORD=$TMP

   # get the dbname
   DEFAULT="$DBNAME"
   TMP="What is the name of the database [$DEFAULT]? (must be already created) "
   getValue;DBNAME="$TMP"

   # shall we start?
   DEFAULT="y"
   TMP="Shall we start the installation [$DEFAULT]? "
   getValue
   if [ ! "$TMP" = "y" ]
   then
      echo -e "\nInstallation aborted!\n"
      exit 1
   fi
fi

# copy/unpack files
echo -e "\nUnpacking files..."
mkdir -p "$DEST/backup"

FROM="$ROOT/datasets-$VERSION.tar.gz";TO="$DEST/backup";copyFile
FROM="$ROOT/lib.tar.gz";TO="$DEST/backup";copyFile
FROM="$ROOT/src.tar.gz";TO="$DEST/backup";copyFile
FROM="$ROOT/docs.tar.gz";TO="$DEST/backup";copyFile

cd "$DEST"
tar -xzf backup/src.tar.gz
tar -xzf backup/datasets-$VERSION.tar.gz
tar -xzf backup/lib.tar.gz
tar -xzf backup/docs.tar.gz

# write XML files
echo -e "\nSetting up configuration..."
cd "$DEST"
if [ "$DBTYPE" = "mysql" ]
then
   ./scripts/mysql.sh -H "$DBHOST" -P "$DBPORT" -u "$DBUSER" -p "$DBPASSWORD" -d "$DBNAME"
else
   ./scripts/postgresql.sh -H "$DBHOST" -P "$DBPORT" -u "$DBUSER" -p "$DBPASSWORD" -d "$DBNAME"
fi

# compiling
echo -e "\nCompiling..."
cd "$DEST"
"$ANT" dist

# documentation
echo -e "\nCreating documentation..."
cd "$DEST"
./scripts/documentation.sh

# info
"$ANT" info

# finished
echo -e "\nFinished!\n"
echo "You can now go to '$DEST' and start Proper."
