#!/bin/bash

# this scripts changes a specific property of an ANT file.
#
# $Revision: 1.2 $
# FracPete

# prints the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -p <property> -v <newvalue> [-f <filename>] [-d <dir>]"
   echo "       [-b] [-h]"
   echo 
   echo "changes a specific property of all ANT files, if '-f <name>' is given"
   echo "only the property in this file"
   echo 
   echo " -h   this help"
   echo " -p   <property>"
   echo "      the name of the property to change the value for"
   echo " -v   <newvalue>"
   echo "      the new value of the property"
   echo " -f   <filename>"
   echo "      if specified only this file is modified and not all "
   echo " -d   <dir>"
   echo "      the directory to look in for ANT files"
   echo "      default: $XMLDIR"
   echo " -b   performs a backup of the original file, i.e. creating a copy"
   echo "      the extension '.original'"
   echo 
}

# changes the property "PROPERTY" in the XML file "FILE" and sets the value to 
# "VALUE"
function changeValue()
{
   cat "$FILE" | sed s/"<property name=\"$PROPERTY\".*value=\".*\""/"<property name=\"$PROPERTY\" value=\"$VALUE\""/g > "$FILE"_
   rm "$FILE"
   mv "$FILE"_ "$FILE"
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
PROPERTY=""
VALUE=""
FILENAME=""
XMLDIR="$ROOT/../xml"
XMLDIR2="$ROOT/../src/proper/gui/experiment"
BACKUP="no"

# interprete parameters
while getopts ":hbp:v:f:d:" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      p) PROPERTY="$OPTARG"
         ;;
      v) VALUE="$OPTARG"
         ;;
      f) FILENAME="$OPTARG"
         ;;
      d) XMLDIR="$OPTARG"
         ;;
      b) BACKUP="yes"
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# everything set?
if [ "$PROPERTY" = "" ]
then
   usage
   exit 1
fi

# change the file(s)
echo "Property '$PROPERTY' = '$VALUE'..."
if [ "$FILENAME" = "" ]
then
   for i in "$XMLDIR"/*.xml
   do
      FILE="$i"

      # info
      INFO=`echo ${FILE##*/} | cut -f1 -d"."`
#      echo " - $INFO"
      
      # save original
      if [ "$BACKUP" = "yes" ]
      then
         cp "$i" "$i.original"
      fi

      # change value
      changeValue
   done
else
   # change value
   changeValue
fi

