/*
 * Decompiled with CFR 0.152.
 */
package model.distribution;

import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import model.distribution.Distribution;
import org.jdom2.Content;
import org.jdom2.Element;
import util.GlobalRandom;

public class ClassDistribution
extends Distribution {
    private HashMap<Value, Double> counts;
    private ArrayList<Value> majority;

    public ClassDistribution() {
    }

    public ClassDistribution(Element distrEl) {
        this.counts = new HashMap();
        this.majority = new ArrayList();
        double maxCount = -1.0;
        for (Element valEl : distrEl.getChildren("value")) {
            Value clVal = new Value(valEl.getAttributeValue("val"));
            Double cnt = new Double(valEl.getAttributeValue("count"));
            this.counts.put(clVal, cnt);
            if (!(cnt >= maxCount)) continue;
            if (cnt > maxCount) {
                this.majority.clear();
                maxCount = cnt;
            }
            this.majority.add(clVal);
        }
    }

    @Override
    public void init(Instances distr) {
        this.originalDistribution.addAll(distr);
        this.counts = new HashMap();
        for (Instance inst : distr) {
            Value val = inst.getLabel();
            if (!this.counts.containsKey(val)) {
                this.counts.put(val, 0.0);
            }
            this.counts.put(val, this.counts.get(val) + inst.getWeight());
        }
        this.majority = new ArrayList();
        double maxCount = -1.0;
        for (Map.Entry<Value, Double> ent : this.counts.entrySet()) {
            if (!(ent.getValue() >= maxCount)) continue;
            if (ent.getValue() > maxCount) {
                maxCount = ent.getValue();
                this.majority.clear();
            }
            this.majority.add(ent.getKey());
        }
    }

    @Override
    public Value predict() {
        if (!this.canPredict()) {
            return null;
        }
        if (this.majority.size() == 1) {
            return this.majority.get(0);
        }
        return this.majority.get(GlobalRandom.instance().nextInt(this.majority.size()));
    }

    @Override
    public boolean canPredict() {
        return !this.majority.isEmpty();
    }

    @Override
    public Distribution clone() {
        ClassDistribution res = new ClassDistribution();
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (Map.Entry<Value, Double> cnt : this.counts.entrySet()) {
            sb.append(String.valueOf(cnt.getKey().toString()) + ":" + cnt.getValue() + " ");
        }
        sb.append("]");
        return new String(sb);
    }

    @Override
    public HashSet<Value> predictMajority() {
        return new HashSet<Value>(this.majority);
    }

    @Override
    public HashMap<Value, Double> probabilities(HashSet<Value> classes) {
        HashMap<Value, Double> res = new HashMap<Value, Double>();
        double sw = classes.size();
        for (Double s : this.counts.values()) {
            sw += s.doubleValue();
        }
        Iterator<Comparable<Double>> iterator = classes.iterator();
        while (iterator.hasNext()) {
            Value cl;
            res.put(cl, (1.0 + (this.counts.containsKey(cl = (Value)iterator.next()) ? this.counts.get(cl) : 0.0)) / sw);
        }
        return res;
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("distribution");
        el.setAttribute("type", "classification");
        for (Map.Entry<Value, Double> ent : this.counts.entrySet()) {
            Element ch = new Element("value");
            ch.setAttribute("val", ent.getKey().getStringValue());
            ch.setAttribute("count", ent.getValue().toString());
            el.addContent((Content)ch);
        }
        return el;
    }
}

