/*
 * Decompiled with CFR 0.152.
 */
package data.feature;

import data.Type;
import data.catalog.Catalog;
import data.feature.AggregateFeature;
import data.feature.SimpleFeature;
import data.feature.SingleValueFeature;
import data.parameter.NumericShiftFunction;
import org.jdom2.Element;

public abstract class Feature
implements Cloneable {
    protected Type typeIn;

    public Type getTypeIn() {
        return this.typeIn;
    }

    public boolean isLink() {
        return false;
    }

    public abstract String toString();

    public boolean equals(Object obj) {
        if (obj instanceof Feature) {
            return this.equals((Feature)obj);
        }
        return this == obj;
    }

    public boolean equals(Feature f) {
        return this == f;
    }

    public static SingleValueFeature fromXML(Element featEl, Catalog cat) {
        if (featEl != null) {
            Element featElem = (Element)featEl.getChildren().get(0);
            if (featElem.getName().equals("aggregate")) {
                return new AggregateFeature(featElem, cat);
            }
            if (featElem.getName().equals("attribute")) {
                SimpleFeature sf = (SimpleFeature)cat.getFeatureByName(featElem.getAttributeValue("name"));
                if (sf.getTypeOut().getKind() == 1) {
                    sf.setShift(NumericShiftFunction.fromXML(featElem.getChild("shift")));
                }
                return sf;
            }
        }
        return null;
    }
}

