/*
 * Decompiled with CFR 0.152.
 */
package data.catalog;

import data.feature.SimpleFeature;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import util.GlobalRandom;

public class CatalogAttributes {
    private SimpleFeature feature;
    private double min;
    private double max;
    private HashMap<Value, Value> catalogById;
    private HashMap<Value, Value> permutation;

    public CatalogAttributes(SimpleFeature bf) {
        this.feature = bf;
        this.catalogById = new HashMap();
        this.permutation = new HashMap();
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
    }

    public CatalogAttributes clone() {
        CatalogAttributes res = new CatalogAttributes(this.feature);
        for (Map.Entry<Value, Value> ent : this.catalogById.entrySet()) {
            res.insert(ent.getKey(), ent.getValue());
        }
        return res;
    }

    public void insert(Value in, Value out) {
        this.catalogById.put(in, out);
        if (this.feature.getTypeOut().getKind() == 1) {
            double outVal = out.getNumericValue();
            if (outVal < this.min) {
                this.min = outVal;
            }
            if (outVal > this.max) {
                this.max = outVal;
            }
        }
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    public HashMap<Value, Value> getAllEntries() {
        return this.catalogById;
    }

    public Value getValue(Value id) {
        return this.catalogById.get(id);
    }

    public Value getValuePermuted(Value id) {
        Value tid = this.permutation.containsKey(id) ? this.permutation.get(id) : id;
        return this.catalogById.get(tid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Value id : this.catalogById.keySet()) {
            sb.append(String.valueOf(this.feature.toString()) + "(" + id.getStringValue() + "," + this.catalogById.get(id).getStringValue() + ").\n");
        }
        return new String(sb);
    }

    public void permute(ArrayList<Value> idsToPerm) {
        ArrayList<Value> perm = new ArrayList<Value>(idsToPerm);
        Collections.shuffle(perm, GlobalRandom.instance());
        int i = 0;
        while (i < idsToPerm.size()) {
            this.permutation.put(idsToPerm.get(i), perm.get(i));
            ++i;
        }
    }

    public void clearPermutation() {
        this.permutation.clear();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.min;
    }
}

