/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate.selection;

import data.Type;
import data.aggregate.selection.Selector;
import data.catalog.Catalog;
import data.condition.Condition;
import data.condition.Conjunction;
import data.condition.FilterFeature;
import data.condition.FilterInterval;
import data.condition.FilterSet;
import data.feature.LinkFeature;
import data.feature.SimpleFeature;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom2.Content;
import org.jdom2.Element;
import util.GlobalRandom;

public class SelectionWithFilters
implements Selector {
    private LinkFeature selection;
    private Conjunction filters = new Conjunction();

    public SelectionWithFilters() {
    }

    public SelectionWithFilters(Element swfEl, Catalog cat) {
        this();
        this.selection = (LinkFeature)cat.getFeatureByName(swfEl.getChild("link").getAttributeValue("name"));
        this.filters = (Conjunction)Condition.fromXML(swfEl.getChild("condition"), cat);
    }

    @Override
    public double complexity() {
        return this.filters.complexity();
    }

    @Override
    public Stream<Value> select(Value val, Catalog cat) {
        return this.selection.getLinkedElements(val, cat).stream().filter(this.filters.filter(cat));
    }

    public Stream<Value> selectAll(Value val, Catalog cat) {
        return this.selection.getLinkedElements(val, cat).stream();
    }

    public SelectionWithFilters clone() {
        SelectionWithFilters swf = new SelectionWithFilters();
        swf.setSelection(this.selection);
        swf.setFilters(this.filters.cloneCondition());
        return swf;
    }

    public LinkFeature getSelection() {
        return this.selection;
    }

    public void setSelection(LinkFeature selection) {
        this.selection = selection;
    }

    public Conjunction getFilters() {
        return this.filters;
    }

    public void setFilters(Conjunction filters) {
        this.filters = filters;
    }

    public void addFilter(FilterFeature f) {
        this.filters.add(f);
    }

    public void removeLastFilter() {
        this.filters.remove(this.filters.size() - 1);
    }

    public Type getTypeIn() {
        return this.selection.getTypeIn();
    }

    public Type getTypeOut() {
        return this.selection.getTypeOut();
    }

    public Condition getLastFilter() {
        return (Condition)this.filters.get(this.filters.size() - 1);
    }

    public HashMap<NumericShiftFunction, double[]> getShifts(ArrayList<Value> vals, Catalog cat) {
        HashMap<NumericShiftFunction, double[]> res = new HashMap<NumericShiftFunction, double[]>();
        for (Condition f : this.filters) {
            res.putAll(f.getShifts(vals, cat));
        }
        return res;
    }

    public void initializeFilters(ArrayList<Value> mainIds, Catalog cat) {
        ArrayList<SimpleFeature> sfs = cat.getSimpleFeatures(this.selection.getTypeOut());
        double threshold = 1.0 / (double)(sfs.size() + 1);
        for (SimpleFeature sf : sfs) {
            FilterInterval fi;
            boolean add;
            double chosen = GlobalRandom.instance().nextDouble();
            if (!(chosen < threshold)) continue;
            if (sf.getTypeOut().getKind() == 0) {
                FilterSet fs = new FilterSet(sf, new HashSet<Value>());
                add = fs.initialize(new ArrayList<Value>(mainIds.stream().flatMap(v -> this.select((Value)v, cat)).map(v -> sf.result((Value)v, cat)).collect(Collectors.toSet())));
                if (!add) continue;
                this.filters.add(fs);
                continue;
            }
            if (sf.getTypeOut().getKind() != 1 || !(add = (fi = new FilterInterval(sf, new Value(Double.NEGATIVE_INFINITY), new Value(Double.POSITIVE_INFINITY))).initialize(new ArrayList<Value>(mainIds.stream().flatMap(v -> this.select((Value)v, cat)).map(v -> sf.result((Value)v, cat)).collect(Collectors.toSet()))))) continue;
            this.filters.add(fi);
        }
    }

    public void addCondition(SimpleFeature sf, ArrayList<Value> values, Random rt) {
        if (sf.getTypeOut().getKind() == 0) {
            FilterSet fs = new FilterSet(sf, new HashSet<Value>());
            fs.initialize(values, rt);
            this.filters.add(fs);
        } else if (sf.getTypeOut().getKind() == 1) {
            FilterInterval fi = new FilterInterval(sf, new Value(Double.NEGATIVE_INFINITY), new Value(Double.POSITIVE_INFINITY));
            fi.initialize(values, rt);
            this.filters.add(fi);
        }
    }

    public void removeCondition(SimpleFeature sf) {
        FilterFeature toRemove = null;
        for (FilterFeature ff : this.filters) {
            if (!ff.getFeature().equals(sf)) continue;
            toRemove = ff;
            break;
        }
        this.filters.remove(toRemove);
    }

    public void applyMove(Catalog cat, ArrayList<Value> ids, SimpleFeature sf, Value val) {
        SelectionWithFilters swfClone = this.clone();
        FilterFeature toRemove = null;
        for (FilterFeature ff : swfClone.getFilters()) {
            if (!ff.getFeature().equals(sf)) continue;
            toRemove = ff;
            break;
        }
        if (toRemove != null) {
            swfClone.getFilters().remove(toRemove);
        }
        ArrayList<Value> secIds = new ArrayList<Value>(ids.stream().flatMap(v -> swfClone.select((Value)v, cat)).collect(Collectors.toList()));
        for (FilterFeature ff : this.filters) {
            if (!ff.getFeature().equals(sf)) continue;
            ((FilterSet)ff).applyMove(cat, secIds, val);
        }
    }

    public void initializeFilters(ArrayList<Value> mainIds, Catalog cat, ArrayList<SimpleFeature> sfs, Random rt) {
        double threshold = 1.0 / (double)(sfs.size() + 1);
        for (SimpleFeature sf : sfs) {
            FilterInterval fi;
            boolean add;
            double chosen = rt.nextDouble();
            if (!(chosen < threshold)) continue;
            if (sf.getTypeOut().getKind() == 0) {
                FilterSet fs = new FilterSet(sf, new HashSet<Value>());
                add = fs.initialize(new ArrayList<Value>(mainIds.stream().flatMap(v -> this.select((Value)v, cat)).map(v -> sf.result((Value)v, cat)).collect(Collectors.toSet())), rt);
                if (!add) continue;
                this.filters.add(fs);
                continue;
            }
            if (sf.getTypeOut().getKind() != 1 || !(add = (fi = new FilterInterval(sf, new Value(Double.NEGATIVE_INFINITY), new Value(Double.POSITIVE_INFINITY))).initialize(new ArrayList<Value>(mainIds.stream().flatMap(v -> this.select((Value)v, cat)).map(v -> sf.result((Value)v, cat)).collect(Collectors.toSet())), rt))) continue;
            this.filters.add(fi);
        }
    }

    public ArrayList<SelectionWithFilters> neighbors(TreeSet<Value> possibleValues, SimpleFeature sf, int absDepth) {
        ArrayList<SelectionWithFilters> res = new ArrayList<SelectionWithFilters>(5);
        FilterFeature toModify = null;
        for (FilterFeature ff : this.filters) {
            if (!ff.getFeature().equals(sf)) continue;
            toModify = ff;
        }
        SelectionWithFilters swfBase = this.clone();
        swfBase.removeCondition(sf);
        SelectionWithFilters toAdd1 = swfBase.clone();
        res.add(toAdd1);
        ArrayList<FilterInterval> fiNeighbors = ((FilterInterval)toModify).localMoves(possibleValues, absDepth);
        for (FilterInterval fi : fiNeighbors) {
            SelectionWithFilters toAdd = swfBase.clone();
            toAdd.addFilter(fi);
            res.add(toAdd);
        }
        return res;
    }

    public SelectionWithFilters randomNeighbor(TreeSet<Value> possibleValues, SimpleFeature sf, Random rt) {
        FilterFeature toModify = null;
        for (FilterFeature ff : this.filters) {
            if (!ff.getFeature().equals(sf)) continue;
            toModify = ff;
        }
        SelectionWithFilters res = this.clone();
        res.removeCondition(sf);
        int move = 1 + rt.nextInt(4);
        FilterInterval fi = ((FilterInterval)toModify).cloneCondition();
        fi.applyRandomMove(possibleValues, move, rt);
        res.addFilter(fi);
        return res;
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("selector");
        el.addContent((Content)this.selection.toXMLElement());
        el.addContent((Content)this.filters.toXMLElement());
        return el;
    }

    public HashSet<NumericShiftFunction> getShifts() {
        return this.filters.getShifts();
    }

    public void initShifts(ArrayList<Value> vals, Catalog cat) {
        this.filters.initShifts(vals, cat);
    }

    public void deployShifts(ArrayList<Value> vals, Catalog cat) {
        this.filters.deployShifts(vals, cat);
    }
}

