/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import ida.utils.Sugar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MultiMap<R, S> {
    private final HashSet<S> emptySet = new HashSet();
    private ConcurrentHashMap<R, Set<S>> map = new ConcurrentHashMap();

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public Set<S> get(Object key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return this.emptySet;
    }

    public Set<S> getAll(Set keys) {
        HashSet<S> retVal = new HashSet<S>();
        for (Object key : keys) {
            retVal.addAll(this.get(key));
        }
        return retVal;
    }

    public void put(R key, S value) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, Collections.synchronizedSet(new LinkedHashSet()));
        }
        this.map.get(key).add(value);
    }

    public void putAll(R key, Collection<S> values) {
        for (S s : values) {
            this.put(key, s);
        }
    }

    public void putAll(MultiMap<R, S> multiMap) {
        for (Map.Entry<R, Set<S>> entry : multiMap.entrySet()) {
            this.putAll(entry.getKey(), (Collection)entry.getValue());
        }
    }

    public void set(R key, Set<S> value) {
        this.map.remove(key);
        this.map.put(key, value);
    }

    public void set(R key, Collection<S> value) {
        this.map.remove(key);
        this.map.put(key, Collections.synchronizedSet(Sugar.setFromCollections(value)));
    }

    public void remove(Object key, Object value) {
        this.map.get(key).remove(value);
    }

    public Set<S> remove(Object key) {
        return this.map.remove(key);
    }

    public void removeAll(Collection keys) {
        for (Object o : keys) {
            this.remove(o);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<R> keySet() {
        return this.map.keySet();
    }

    public Collection<Set<S>> values() {
        return this.map.values();
    }

    public Set<Map.Entry<R, Set<S>>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    public String sizesToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MultiMap[");
        int index = 0;
        for (Map.Entry<R, Set<S>> entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(" ~ ").append(entry.getValue().size());
            if (index++ >= this.map.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int[] sizes() {
        int[] sizes = new int[this.map.size()];
        int i = 0;
        for (Map.Entry<R, Set<S>> entry : this.map.entrySet()) {
            sizes[i] = entry.getValue().size();
            ++i;
        }
        return sizes;
    }

    public MultiMap<R, S> copy() {
        MultiMap<R, S> retVal = new MultiMap<R, S>();
        super.putAll_forCopy(this);
        return retVal;
    }

    private void putAll_forCopy(MultiMap<R, S> bag) {
        for (Map.Entry<R, Set<S>> entry : bag.entrySet()) {
            this.putAll(entry.getKey(), Sugar.setFromCollections(entry.getValue()));
        }
    }
}

