/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker;

import ida.ilp.basic.Clause;
import ida.ilp.basic.Literal;
import ida.ilp.treeLiker.PredicateDefinition;
import ida.utils.collections.MultiMap;
import ida.utils.tuples.Pair;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class Preprocessor {
    public static Clause reachableLiterals(Set<PredicateDefinition> template, List<PredicateDefinition> globalConstants, Clause clause) {
        MultiMap<PredicateDefinition, Literal> closed = new MultiMap<PredicateDefinition, Literal>();
        Stack<Pair<PredicateDefinition, Literal>> open = new Stack<Pair<PredicateDefinition, Literal>>();
        LinkedHashSet<Literal> literals = new LinkedHashSet<Literal>();
        for (PredicateDefinition def : Preprocessor.roots(template)) {
            for (Literal l : clause.getLiteralsByPredicate(def.stringPredicate())) {
                if (l.arity() != def.arity()) continue;
                open.push(new Pair<PredicateDefinition, Literal>(def, l));
                closed.put(def, l);
            }
        }
        MultiMap<Integer, PredicateDefinition> defBag = Preprocessor.buildDefBag(template);
        while (!open.isEmpty()) {
            Pair pair = (Pair)open.pop();
            Literal l = (Literal)pair.s;
            PredicateDefinition def = (PredicateDefinition)pair.r;
            literals.add(l);
            int[] originalModes = def.originalModes();
            int[] types = def.types();
            for (int i = 0; i < originalModes.length; ++i) {
                if (originalModes[i] != 2) continue;
                for (Literal neighbour : clause.getLiteralsByTerm(l.get(i))) {
                    for (int j = 0; j < neighbour.arity(); ++j) {
                        if (!neighbour.get(j).equals(l.get(i))) continue;
                        for (PredicateDefinition candDef : defBag.get(types[i])) {
                            if (candDef.arity() != neighbour.arity() || !candDef.stringPredicate().equals(neighbour.predicate()) || candDef.input() != j || candDef.types()[j] != types[i] || closed.get(candDef).contains(neighbour)) continue;
                            open.add(new Pair<PredicateDefinition, Literal>(candDef, neighbour));
                            closed.put(candDef, neighbour);
                        }
                    }
                }
            }
        }
        for (PredicateDefinition gc : globalConstants) {
            literals.addAll(clause.getLiteralsByPredicate(gc.stringPredicate()));
        }
        return new Clause(literals);
    }

    private static Set<PredicateDefinition> roots(Set<PredicateDefinition> defs) {
        HashSet<PredicateDefinition> retVal = new HashSet<PredicateDefinition>();
        for (PredicateDefinition def : defs) {
            if (!def.isOutputOnly()) continue;
            retVal.add(def);
        }
        return retVal;
    }

    private static MultiMap<Integer, PredicateDefinition> buildDefBag(Set<PredicateDefinition> defs) {
        MultiMap<Integer, PredicateDefinition> defBag = new MultiMap<Integer, PredicateDefinition>();
        for (PredicateDefinition def : defs) {
            for (int i = 0; i < def.modes().length; ++i) {
                if (def.modes()[i] != 1) continue;
                defBag.put(def.types()[i], def);
            }
        }
        return defBag;
    }
}

