/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker;

import ida.ilp.basic.Constant;
import ida.ilp.basic.LogicUtils;
import ida.ilp.treeLiker.Dataset;
import ida.ilp.treeLiker.Example;
import ida.ilp.treeLiker.PredicateDefinition;
import ida.utils.Combinatorics;
import ida.utils.StringUtils;
import ida.utils.Sugar;
import ida.utils.collections.Counters;
import ida.utils.collections.MultiList;
import ida.utils.collections.MultiMap;
import ida.utils.collections.NaturalNumbersList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MemoryBasedDataset
implements Dataset {
    private int index;
    private List<Example> examples = new ArrayList<Example>();
    private List<String> classifications = new ArrayList<String>();
    private Set<String> classes = new LinkedHashSet<String>();
    private Counters<String> classCounts = new Counters();

    public void addExample(Example example, String classification) {
        this.examples.add(example);
        this.classifications.add(classification);
        this.classes.add(classification);
        this.classCounts.increment(classification);
    }

    @Override
    public boolean hasNextExample() {
        return this.index < this.examples.size();
    }

    @Override
    public Example nextExample() {
        return this.examples.get(this.index++);
    }

    public Example getExample(int index) {
        return this.examples.get(index);
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public int currentIndex() {
        return this.index - 1;
    }

    @Override
    public String classificationOfCurrentExample() {
        return this.classifications.get(this.index - 1);
    }

    @Override
    public int countExamples() {
        return this.examples.size();
    }

    @Override
    public Dataset shallowCopy() {
        MemoryBasedDataset mbe = new MemoryBasedDataset();
        mbe.classifications = this.classifications;
        mbe.examples = this.examples;
        mbe.index = 0;
        return mbe;
    }

    @Override
    public List<Dataset> stratifiedCrossValidation(int foldsCount, int seed) {
        MultiList<String, Integer> classes = new MultiList<String, Integer>();
        for (int i = 0; i < this.examples.size(); ++i) {
            String classification = this.classifications.get(i);
            classes.put(classification, i);
        }
        Random random = new Random(seed);
        for (List list : classes.values()) {
            Collections.shuffle(list, random);
        }
        ArrayList<Dataset> folds = new ArrayList<Dataset>();
        for (int i = 0; i < foldsCount; ++i) {
            MemoryBasedDataset fold = new MemoryBasedDataset();
            for (Map.Entry entry : classes.entrySet()) {
                int j;
                List c = entry.getValue();
                if (i < foldsCount - 1) {
                    for (j = i * c.size() / foldsCount; j < (i + 1) * c.size() / foldsCount; ++j) {
                        fold.addExample(this.examples.get((Integer)c.get(j)), (String)entry.getKey());
                    }
                    continue;
                }
                for (j = i * c.size() / foldsCount; j < c.size(); ++j) {
                    fold.addExample(this.examples.get((Integer)c.get(j)), (String)entry.getKey());
                }
            }
            folds.add(fold);
        }
        return folds;
    }

    @Override
    public synchronized Dataset[] split(int splitCount) {
        int i;
        Dataset[] exs = new MirroredExamples[splitCount];
        for (i = 0; i < splitCount; ++i) {
            exs[i] = new MirroredExamples();
        }
        for (i = 0; i < this.countExamples(); ++i) {
            ((MirroredExamples)exs[i % splitCount]).addExample(this.examples.get(i), this.classifications.get(i), i);
        }
        return exs;
    }

    @Override
    public int countExamples(String cl) {
        return Sugar.countOccurences((Object)cl, this.classifications);
    }

    @Override
    public Collection<String> classes() {
        return this.classes;
    }

    @Override
    public Dataset get(int[] indices) {
        MemoryBasedDataset mbe = new MemoryBasedDataset();
        for (int i : indices) {
            mbe.addExample(this.examples.get(i), this.classifications.get(i));
        }
        return mbe;
    }

    @Override
    public void sortDesc(String targetVariable) {
        this.sortAsc(targetVariable);
        Collections.reverse(this.examples);
        Collections.reverse(this.classifications);
    }

    @Override
    public void sortAsc(String targetVariable) {
        HashMap<Integer, Object> scores = new HashMap<Integer, Object>();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < this.examples.size(); ++i) {
            Example e = this.examples.get(i);
            Constant value = Constant.construct(Example.termToString(e.getTerm(e.getLiteralDomain(PredicateDefinition.predicateToInteger(targetVariable, 1)).values()[0], 0)));
            String strVal = LogicUtils.unquote(value).name();
            if (StringUtils.isNumeric(strVal)) {
                scores.put(i, Double.parseDouble(strVal));
            } else {
                scores.put(i, strVal);
            }
            indices.add(i);
        }
        List sorted = Sugar.sortAsc(indices, scores);
        ArrayList<String> newClassifications = new ArrayList<String>();
        ArrayList<Example> newExamples = new ArrayList<Example>();
        for (int i = 0; i < indices.size(); ++i) {
            newClassifications.add(this.classifications.get((Integer)sorted.get(i)));
            newExamples.add(this.examples.get((Integer)sorted.get(i)));
        }
        this.examples = newExamples;
        this.classifications = newClassifications;
    }

    @Override
    public Dataset subsample(int numFromEachClass, int seed) {
        Random random = new Random(seed);
        MemoryBasedDataset mbd = new MemoryBasedDataset();
        MultiMap<String, Integer> selectedIndices = new MultiMap<String, Integer>();
        for (String classLabel : this.classes()) {
            Set<Integer> selectedIndicesForClass = Combinatorics.randomCombination(new NaturalNumbersList(0, this.classCounts.get(classLabel)), Math.min(this.classCounts.get(classLabel), numFromEachClass), random).toSet();
            selectedIndices.putAll(classLabel, selectedIndicesForClass);
        }
        Counters<String> indexes = new Counters<String>();
        for (int i = 0; i < this.examples.size(); ++i) {
            String classLabel = this.classifications.get(i);
            int indexInClass = indexes.incrementPost(classLabel);
            if (!selectedIndices.get(classLabel).contains(indexInClass)) continue;
            mbd.addExample(this.examples.get(i), classLabel);
        }
        return mbd;
    }

    private static class MirroredExamples
    implements Dataset {
        private int currentIndex = 0;
        private List<Example> examples = new ArrayList<Example>();
        private List<Integer> indices = new ArrayList<Integer>();
        private List<String> classifications = new ArrayList<String>();
        private Map<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        private Set<String> classes = new LinkedHashSet<String>();

        public void addExample(Example example, String classification, int index) {
            this.examples.add(example);
            this.classifications.add(classification);
            this.classes.add(classification);
            this.indices.add(index);
            this.indexMap.put(index, this.examples.size() - 1);
        }

        @Override
        public int countExamples() {
            return this.indices.size();
        }

        @Override
        public boolean hasNextExample() {
            return this.currentIndex < this.examples.size();
        }

        @Override
        public Example nextExample() {
            return this.examples.get(this.currentIndex++);
        }

        @Override
        public void reset() {
            this.currentIndex = 0;
        }

        @Override
        public int currentIndex() {
            return this.indices.get(this.currentIndex - 1);
        }

        @Override
        public String classificationOfCurrentExample() {
            return this.classifications.get(this.currentIndex - 1);
        }

        @Override
        public Dataset shallowCopy() {
            MirroredExamples me = new MirroredExamples();
            me.classifications = this.classifications;
            me.examples = this.examples;
            me.indexMap = this.indexMap;
            me.indices = this.indices;
            return me;
        }

        @Override
        public List<Dataset> stratifiedCrossValidation(int folds, int seed) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Dataset[] split(int splitCount) {
            int i;
            Dataset[] exs = new MirroredExamples[splitCount];
            for (i = 0; i < splitCount; ++i) {
                exs[i] = new MirroredExamples();
            }
            for (i = 0; i < this.countExamples(); ++i) {
                ((MirroredExamples)exs[i % splitCount]).addExample(this.examples.get(i), this.classifications.get(i), this.indices.get(i));
            }
            return exs;
        }

        @Override
        public int countExamples(String cl) {
            return Sugar.countOccurences((Object)cl, this.classifications);
        }

        @Override
        public Collection<String> classes() {
            return this.classes;
        }

        @Override
        public Dataset get(int[] indices) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void sortAsc(String targetVariable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void sortDesc(String targetVariable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Dataset subsample(int numFromEachClass, int seed) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

