/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker;

import ida.ilp.treeLiker.Aggregable;
import ida.ilp.treeLiker.Block;
import ida.ilp.treeLiker.Domain;
import ida.ilp.treeLiker.Example;
import ida.ilp.treeLiker.HavingTermDomain;
import ida.utils.collections.IntegerSet;
import java.util.Iterator;
import java.util.LinkedList;

public class Join
implements Iterable<Block>,
HavingTermDomain {
    private int hashCode = -1;
    private int id;
    private static int lastID = 0;
    private int numBlocks = 0;
    private int numLiterals = 0;
    private Join first;
    private Join previous;
    private Block block;
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Join() {
        Object object = lock;
        synchronized (object) {
            this.id = lastID++;
        }
    }

    public Join(Block block) {
        this();
        this.block = block;
        this.previous = null;
        this.first = this;
        this.numBlocks = 1;
        this.numLiterals = block.size();
    }

    public Join addBlock(Block block) {
        Join bc = new Join();
        bc.block = block;
        bc.previous = this;
        bc.first = this.first;
        bc.numBlocks = this.numBlocks + 1;
        bc.numLiterals = this.numLiterals() + block.size();
        return bc;
    }

    public Block first() {
        return this.first.block;
    }

    public Block last() {
        return this.block;
    }

    @Override
    public Domain termDomain(Example e) {
        Domain domain = null;
        if (this.previous == null) {
            domain = this.block.termDomain(e);
        } else {
            Domain previousTermDomain = this.previous.termDomain(e);
            if (previousTermDomain.isEmpty()) {
                return Domain.emptyDomain;
            }
            domain = Domain.cross(previousTermDomain, this.block.termDomain(e));
        }
        return domain;
    }

    public Aggregable termAggregable(int term, Example e) {
        if (this.previous == null) {
            return this.block.termAggregable(term, e);
        }
        return this.previous.termAggregable(term, e).cross(this.block.termAggregable(term, e));
    }

    public IntegerSet integerSetTermDomain(Example e) {
        IntegerSet domain = null;
        if (this.previous == null) {
            domain = this.block.integerSetTermDomain(e);
        } else {
            IntegerSet previousTermDomain = this.previous.integerSetTermDomain(e);
            if (previousTermDomain.isEmpty()) {
                return IntegerSet.emptySet;
            }
            domain = IntegerSet.intersection(previousTermDomain, this.block.integerSetTermDomain(e));
        }
        return domain;
    }

    public int numBlocks() {
        return this.numBlocks;
    }

    public int numLiterals() {
        return this.numLiterals;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.previous == null ? 67 * this.block.hashCode() % Integer.MAX_VALUE / 256 : 67 * this.block.hashCode() + 37 * this.previous.hashCode() % Integer.MAX_VALUE / 256;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Join other = (Join)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (this.numBlocks != other.numBlocks) {
            return false;
        }
        if (!(this.previous == other.previous || this.previous != null && this.previous.equals(other.previous))) {
            return false;
        }
        return this.block == other.block || this.block != null && this.block.equals(other.block);
    }

    @Override
    public Iterator<Block> iterator() {
        LinkedList<Block> ll = new LinkedList<Block>();
        Join bc = this;
        while (bc != null) {
            ll.addFirst(bc.block);
            bc = bc.previous;
        }
        return ll.iterator();
    }

    @Override
    public int id() {
        return this.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Join[");
        for (Block b : this) {
            sb.append(b);
            if (b == this.block) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int numAggregators() {
        if (this.previous == null) {
            return this.block.numAggregators();
        }
        return this.previous.numAggregators() + this.block.numAggregators();
    }
}

