/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.basic;

import ida.ilp.basic.Term;
import java.util.WeakHashMap;

public class Variable
implements Term {
    private String name;
    private int hashCode = Integer.MIN_VALUE;
    private static WeakHashMap<String, Variable> cache = new WeakHashMap();

    private Variable(String name) {
        this.name = name.trim().intern();
    }

    public static Variable construct(String name) {
        Variable retVal = cache.get(name);
        if (retVal == null) {
            retVal = new Variable(name);
            cache.put(name, retVal);
        }
        return retVal;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof Variable) {
            return o == this || ((Variable)o).name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode != Integer.MIN_VALUE) {
            return this.hashCode;
        }
        this.hashCode = this.name.hashCode();
        return this.hashCode;
    }

    public static void clearCache() {
        cache.clear();
    }
}

