/*
 * Decompiled with CFR 0.152.
 */
package proper.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import proper.util.ProperVector;
import proper.util.TimerInterface;

public class Timer {
    public static final int INTERVAL = 1000;
    private Vector listeners;
    private int interval;
    private boolean repeated;
    protected javax.swing.Timer timer;
    protected ActionListener check;

    public Timer() {
        this(1000);
    }

    public Timer(int interval) {
        this(interval, true);
    }

    public Timer(int interval, boolean repeated) {
        this(interval, repeated, true);
    }

    public Timer(int interval, boolean repeated, boolean start) {
        if (interval <= 0) {
            interval = 1000;
            start = false;
        }
        this.listeners = new ProperVector();
        this.interval = interval;
        this.repeated = repeated;
        this.init(start);
    }

    private void init(boolean start) {
        this.check = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Timer.this.notifyListeners();
            }
        };
        this.timer = new javax.swing.Timer(this.getInterval(), this.check);
        this.stop();
        this.setInterval(this.getInterval());
        if (start) {
            this.start();
        }
    }

    public void clear() {
        this.stop();
        this.listeners.clear();
    }

    public void addListener(TimerInterface o) {
        if (!this.listeners.contains(o)) {
            this.listeners.add(o);
            if (this.isRunning()) {
                this.notifyListener(o);
            }
        }
    }

    public void removeListener(TimerInterface o) {
        if (this.listeners.contains(o)) {
            this.listeners.remove(this.listeners.indexOf(o));
        }
    }

    public Vector getListeners() {
        return this.listeners;
    }

    public void notifyListener(TimerInterface o) {
        o.timerEvent(this);
    }

    public void notifyListeners() {
        int i = 0;
        while (i < this.getListeners().size()) {
            this.notifyListener((TimerInterface)this.getListeners().get(i));
            ++i;
        }
    }

    public void start() {
        this.timer.restart();
    }

    public void stop() {
        this.timer.stop();
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            interval = 1000;
        }
        this.interval = interval;
        boolean running = this.isRunning();
        if (running) {
            this.stop();
        }
        this.timer.setInitialDelay(this.getInterval());
        this.timer.setDelay(this.getInterval());
        if (running) {
            this.start();
        }
    }

    public int getInterval() {
        return this.interval;
    }

    public void setRepeated(boolean repeated) {
        this.repeated = repeated;
        this.timer.setRepeats(repeated);
    }

    public boolean isRepeated() {
        return this.repeated;
    }

    public String toString() {
        return "Interval: " + this.getInterval() + "msec, " + "Repeated: " + this.isRepeated() + ", " + "Running: " + this.isRunning();
    }
}

