/*
 * Decompiled with CFR 0.152.
 */
package proper.tester.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import proper.tester.Tester;
import proper.tester.database.DatabaseConfig;

public class XMLFileGenerator {
    private static XMLFileGenerator instance;

    private XMLFileGenerator() {
    }

    public static XMLFileGenerator getInstance() {
        if (instance == null) {
            instance = new XMLFileGenerator();
        }
        return instance;
    }

    public void exportFile() {
        String filename = String.valueOf(Tester.getProjectPath()) + Tester.getProjectName() + ".xml";
        File f = new File(filename);
        try {
            FileWriter fw = new FileWriter(filename, false);
            BufferedWriter output = new BufferedWriter(fw);
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            output.write("<project name=\"WEKA Proper\" default=\"all\" basedir=\".\">\n");
            output.write("\t<!-- last saved: [" + new Date().toString() + "]  -->\n\n");
            output.write("\t<!-- for accessing the environment variables -->\n");
            output.write("\t<property environment=\"env\"/>\n");
            output.write("\t<!-- Version of Proper WEKA -->\n");
            output.write("\t<property name=\"version\" value=\"Proper_0.2.1\"/>\n");
            output.write("\t<!-- Properties -->\n");
            output.write("\t<property name=\"proper-dir\" value=\"${user.dir}\"/>\n");
            output.write("\t<property name=\"driver\" value=\"" + DatabaseConfig.getDriver(Tester.getServerType()) + "\"/>\n");
            output.write("\t<property name=\"url\" value=\"" + DatabaseConfig.buildURL(Tester.getServerType(), Tester.getServerHost(), DatabaseConfig.getDefaultPort(Tester.getServerType()), "") + "\"/>\n");
            output.write("\t<property name=\"user\" value=\"" + Tester.getUserLogin() + "\"/>\n");
            output.write("\t<property name=\"password\" value=\"" + Tester.getUserPassword() + "\"/>\n");
            output.write("\t<property name=\"sql_limit\" value=\"LIMIT %ROWS%\"/>\n");
            output.write("\t<property name=\"database\" value=\"" + Tester.getDataBaseName() + "\"/>\n");
            output.write("\t<property name=\"output\" value=\"${proper-dir}/tmp/" + Tester.getProjectName() + "\"/>\n");
            output.write("\t<property name=\"datasets\" value=\"${proper-dir}/datasets\"/>\n");
            output.write("\t<property name=\"dist\" value=\"${proper-dir}/dist\"/>\n");
            output.write("\t<property name=\"verbose\" value=\"\"/>\n");
            output.write("\t<property name=\"log\" value=\"\"/>\n");
            output.write("\t<property name=\"append_log\" value=\"no\"/>\n");
            output.write("\t<property name=\"classifier\" value=\"weka.classifiers.trees.J48\"/>\n");
            output.write("\t<property name=\"additional\" value=\"\"/>\n");
            output.write("\t<property name=\"classifier-numerical\" value=\"weka.classifiers.trees.M5P\"/>\n");
            output.write("\t<property name=\"additional-numerical\" value=\"\"/>\n");
            output.write("\t<property name=\"milk-classifier\" value=\"milk.classifiers.MIWrapper\"/>\n");
            output.write("\t<property name=\"milk-additional\" value=\"=W ${classifier}\"/>\n");
            output.write("\t<property name=\"milk-classifier-numerical\" value=\"milk.classifiers.MIWrapper\"/>\n");
            output.write("\t<property name=\"nominal-filter\" value=\"weka.filters.unsupervised.attribute.NominalToBinary\"/>\n");
            output.write("\t<property name=\"nominal-filter-additional\" value=\"=R first,last -V -A\"/>\n");
            output.write("\t<property name=\"join\" value=\"leftouter\"/>\n");
            output.write("\t<property name=\"memory\" value=\"800m\"/>\n");
            output.write("\t<property name=\"project-name\" value=\"" + Tester.getProjectName() + "\"/>\n");
            output.write("\t<property name=\"exclude_tables\" value=\"_flat,_relaggs,_remilk,_cardinalized,_recursed,_joined,_keys,_file*,_identifier_\"/>\n");
            output.write("\t<property name=\"exclude_fields\" value=\"*_id_*,*_id*,id1,idstr*,id\"/>\n");
            output.write("\t<!-- Classpath -->\n");
            output.write("\t<path id=\"project.class.path\">\n");
            output.write("\t\t<pathelement location=\"${env.ANT_HOME}/lib\"/>\n");
            output.write("\t\t<pathelement location=\".\"/>\n");
            output.write("\t\t<fileset dir=\"${dist}\">\n");
            output.write("\t\t\t<include name=\"*.jar\"/>\n");
            output.write("\t\t</fileset>\n");
            output.write("\t</path>\n");
            output.write("\t<!-- default target -->\n");
            output.write("\t<target name=\"all\" depends=\"init, cardinalization\"/>\n");
            output.write("\t<!-- creates the output directory -->\n");
            output.write("\t<target name=\"init\">\n");
            output.write("\t<mkdir dir=\"${output}\"/>\n");
            output.write("\t</target>\n");
            output.write("\t<target name=\"cardinalization\" depends=\"cardinalization/proper, cardinalization/export (class.)\"/>\n");
            output.write("\t<target name=\"cardinalization/export (class.)\">\n");
            output.write("\t\t<java classname=\"proper.app.Export\" fork=\"yes\" maxmemory=\"${memory}\">\n");
            output.write("\t\t\t<classpath refid=\"project.class.path\"/>\n");
            output.write("\t\t\t<arg value=\"-verbose\"/>\n");
            output.write("\t\t\t<arg value=\"${verbose}\"/>\n");
            output.write("\t\t\t<arg value=\"-url\"/>\n");
            output.write("\t\t\t<arg value=\"${url}\"/>\n");
            output.write("\t\t\t<arg value=\"-user\"/>\n");
            output.write("\t\t\t<arg value=\"${user}\"/>\n");
            output.write("\t\t\t<arg value=\"-password\"/>\n");
            output.write("\t\t\t<arg value=\"${password}\"/>\n");
            output.write("\t\t\t<arg value=\"-driver\"/>\n");
            output.write("\t\t\t<arg value=\"${driver}\"/>\n");
            output.write("\t\t\t<arg value=\"-sql_limit\"/>\n");
            output.write("\t\t\t<arg value=\"${sql_limit}\"/>\n");
            output.write("\t\t\t<arg value=\"-verbose\"/>\n");
            output.write("\t\t\t<arg value=\"${verbose}\"/>\n");
            output.write("\t\t\t<arg value=\"-database\"/>\n");
            output.write("\t\t\t<arg value=\"${database}\"/>\n");
            output.write("\t\t\t<arg value=\"-table\"/>\n");
            output.write("\t\t\t<arg value=\"" + Tester.getExportTableName() + "\"/>\n");
            output.write("\t\t\t<arg value=\"-field\"/>\n");
            output.write("\t\t\t<arg value=\"" + Tester.getExportFieldName() + "\"/>\n");
            output.write("\t\t\t<arg value=\"-exclude_fields\"/>\n");
            output.write("\t\t\t<arg value=\"${exclude_fields}\"/>\n");
            output.write("\t\t\t<arg value=\"-order\"/>\n");
            output.write("\t\t\t<arg value=\"yes\"/>\n");
            output.write("\t\t\t<arg value=\"-output\"/>\n");
            output.write("\t\t\t<arg value=\"${output}/${project-name}-" + Tester.getExportOutputFile() + "\"/>\n");
            output.write("\t\t\t<arg value=\"-type\"/>\n");
            output.write("\t\t\t<arg value=\"classified\"/>\n");
            output.write("\t\t</java>\n");
            output.write("\t</target>\n");
            output.write("\t<target name=\"cardinalization/proper\">\n");
            output.write("\t\t<java classname=\"proper.app.CARDINALIZER\" fork=\"yes\" maxmemory=\"${memory}\">\n");
            output.write("\t\t\t<classpath refid=\"project.class.path\"/>\n");
            output.write("\t\t\t<arg value=\"-verbose\"/>\n");
            output.write("\t\t\t<arg value=\"${verbose}\"/>\n");
            output.write("\t\t\t<arg value=\"-url\"/>\n");
            output.write("\t\t\t<arg value=\"${url}\"/>\n");
            output.write("\t\t\t<arg value=\"-user\"/>\n");
            output.write("\t\t\t<arg value=\"${user}\"/>\n");
            output.write("\t\t\t<arg value=\"-password\"/>\n");
            output.write("\t\t\t<arg value=\"${password}\"/>\n");
            output.write("\t\t\t<arg value=\"-driver\"/>\n");
            output.write("\t\t\t<arg value=\"${driver}\"/>\n");
            output.write("\t\t\t<arg value=\"-sql_limit\"/>\n");
            output.write("\t\t\t<arg value=\"${sql_limit}\"/>\n");
            output.write("\t\t\t<arg value=\"-verbose\"/>\n");
            output.write("\t\t\t<arg value=\"${verbose}\"/>\n");
            output.write("\t\t\t<arg value=\"-database\"/>\n");
            output.write("\t\t\t<arg value=\"${database}\"/>\n");
            output.write("\t\t\t<arg value=\"-table\"/>\n");
            output.write("\t\t\t<arg value=\"" + Tester.getProperTableName() + "\"/>\n");
            output.write("\t\t\t<arg value=\"-field\"/>\n");
            output.write("\t\t\t<arg value=\"" + Tester.getProperFieldName() + "\"/>\n");
            output.write("\t\t\t<arg value=\"-result_table\"/>\n");
            output.write("\t\t\t<arg value=\"" + Tester.getProperResultTableName() + "\"/>\n");
            output.write("\t\t\t<arg value=\"-exclude_tables\"/>\n");
            output.write("\t\t\t<arg value=\"${exclude_tables}\"/>\n");
            output.write("\t\t\t<arg value=\"-join\"/>\n");
            output.write("\t\t\t<arg value=\"leftouter\"/>\n");
            output.write("\t\t\t<arg value=\"-max_depth\"/>\n");
            output.write("\t\t\t<arg value=\"=1\"/>\n");
            output.write("\t\t\t<arg value=\"-any_index\"/>\n");
            output.write("\t\t</java>\n");
            output.write("\t</target>\n");
            output.write("</project>");
            output.flush();
            output.close();
            System.out.println("File XML : " + filename + " created !");
        }
        catch (IOException ioe) {
            System.out.print("Erreur : ");
            ioe.printStackTrace();
        }
    }
}

