/*
 * Decompiled with CFR 0.152.
 */
package proper.tester.database;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import proper.tester.database.Column;

public class Table
implements TreeNode {
    Table parent;
    boolean allowsChildren;
    Vector<Table> children;
    String name;
    int nbInstances;
    Vector<Column> columns;

    public Table() {
        this.parent = null;
        this.allowsChildren = true;
        this.children = new Vector();
        this.name = "";
        this.nbInstances = 0;
        this.columns = new Vector();
    }

    public Table(String name) {
        this.parent = null;
        this.allowsChildren = true;
        this.children = new Vector();
        this.name = name;
        this.nbInstances = 0;
        this.columns = new Vector();
    }

    public Table(boolean allowsChildren, String name, int nbInstances) {
        this.parent = null;
        this.allowsChildren = allowsChildren;
        this.children = new Vector();
        this.name = name;
        this.nbInstances = nbInstances;
        this.columns = new Vector();
    }

    public Table(Table parent, boolean allowsChildren, String name, int nbInstances) {
        this.parent = parent;
        this.allowsChildren = allowsChildren;
        this.children = new Vector();
        this.name = name;
        this.nbInstances = nbInstances;
        this.columns = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNbInstances() {
        return this.nbInstances;
    }

    public void setNbInstances(int nbInstances) {
        this.nbInstances = nbInstances;
    }

    public void setParent(Table parent) {
        this.parent = parent;
    }

    public void setAllowsChildren(boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
    }

    public boolean addChild(Table child) {
        boolean result = false;
        if (!this.children.contains(child)) {
            result = this.children.add(child);
        }
        return result;
    }

    public boolean containsChild(Table child) {
        boolean result = false;
        int i = 0;
        while (i < this.children.size() && !result) {
            result = this.children.get(i).equals(child);
            ++i;
        }
        return result;
    }

    public boolean addColumn(Column column) {
        boolean result = false;
        if (!this.columns.contains(column)) {
            result = this.columns.add(column);
        }
        return result;
    }

    public boolean containsColumn(Column column) {
        boolean result = false;
        int i = 0;
        while (i < this.columns.size() && !result) {
            result = this.columns.get(i).equals(column);
            ++i;
        }
        return result;
    }

    public Vector<Column> columns() {
        return this.columns;
    }

    public Column getColumnAt(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getIndex(Column column) {
        return this.columns.indexOf(column);
    }

    public Column getPrimaryKey() {
        Column result = null;
        int i = 0;
        while (i < this.getColumnCount()) {
            Column tmpCol = this.getColumnAt(i);
            if (tmpCol.isPk()) {
                result = tmpCol;
            }
            ++i;
        }
        return result;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int getChildrenMaxDepth() {
        int result = 0;
        int tmpResult = 0;
        int childCount = this.getChildCount();
        int i = 0;
        while (i < childCount) {
            tmpResult = ((Table)this.getChildAt(i)).getChildrenMaxDepth();
            if (tmpResult > result) {
                result = tmpResult;
            }
            ++i;
        }
        if (childCount > 0) {
            ++result;
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    public Enumeration children() {
        return this.children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Table) {
            Table tmp = (Table)obj;
            result = this.name.equals(tmp.getName());
        } else if (obj instanceof String) {
            String tmp = (String)obj;
            result = this.name.equals(tmp);
        }
        return result;
    }
}

