/*
 * Decompiled with CFR 0.152.
 */
package proper.remote.messages;

import java.io.FileReader;
import java.io.Reader;
import java.util.Vector;
import proper.remote.messages.DataMessage;
import proper.remote.messages.Message;
import proper.xml.Element;

public class FileMessage
extends DataMessage {
    public static final String FILENAME = "filename";

    public FileMessage() {
    }

    public FileMessage(Reader reader) {
        super(reader);
    }

    public FileMessage(Message msg) {
        super(msg);
    }

    @Override
    public boolean isOtherMessage(Message msg) {
        return this.getNode(this.getBody(), FILENAME) == null;
    }

    @Override
    public void clearBody() {
        super.clearBody();
        Element node = this.getBody();
        node.add(new Element(FILENAME));
    }

    public String getFilename() {
        return this.getContent(this.getNode(this.getBody(), FILENAME), true);
    }

    public void setFilename(String filename) {
        this.setContent(this.getNode(this.getBody(), FILENAME), filename);
    }

    @Override
    public void setLines(Vector lines) {
        String filename = this.getFilename();
        super.setLines(lines);
        this.setFilename(filename);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: FileMessage <filename>");
            System.exit(1);
        }
        FileMessage msg = new FileMessage();
        msg.setLines(new FileReader(args[0]));
        msg.setFilename(args[0]);
        System.out.println("After loading file '" + args[0] + "' we get this:");
        System.out.println(msg);
        System.out.println("\nBack again: '" + msg.getFilename() + "'");
        Vector lines = msg.getLines();
        int i = 0;
        while (i < lines.size()) {
            System.out.println(lines.get(i));
            ++i;
        }
    }
}

