/*
 * Decompiled with CFR 0.152.
 */
package proper.remote;

import java.net.InetSocketAddress;
import java.net.Socket;
import proper.remote.JobClientProcessor;
import proper.remote.Processor;
import proper.remote.Server;
import proper.remote.messages.Message;

public class JobClient
extends Server {
    public static final int PORT = 31416;
    private boolean running;

    @Override
    protected void defaultParameters() {
        super.defaultParameters();
        this.defaultPort = 31416;
    }

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("server", "the server to retrieve jobs from", true, "<hostname/IP>", false);
        this.addDefinition("server_port", "the port to bind to, default is 31415", true, "<int>", true);
        this.addDefinition("output", " the directory where to store the logfiles, default is '.'", true, "<directory>", true);
    }

    @Override
    public void printDescription() {
        System.out.println("A Client waiting for Jobs sent from the JobServer it gregistered itself to.");
        System.out.println();
    }

    public boolean getRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        if (!running) {
            this.running = running;
        }
    }

    public String getServerHostName() {
        return this.cl.getValue("server");
    }

    public int getServerPort() {
        if (this.cl.exists("server_port")) {
            return Integer.parseInt(this.cl.getValue("server_port"));
        }
        return 31415;
    }

    public String getOutput() {
        if (this.cl.exists("output")) {
            return this.cl.getValue("output");
        }
        return ".";
    }

    @Override
    protected void afterCheckClients() {
        if (this.clients.size() == 0) {
            String msg = "Server unreachable -> terminating!";
            this.addToErrorLog(msg);
            this.println(msg);
            this.running = false;
            this.sender.send(new InetSocketAddress(this.getHostName(), this.getPort()), this.createMessage("nop").toString());
        }
    }

    protected boolean sendToJobServer(Message msg) {
        boolean result;
        try {
            InetSocketAddress addr = new InetSocketAddress(this.getServerHostName(), this.getServerPort());
            this.sender.send(addr, msg.toString());
            result = true;
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        return result;
    }

    public boolean register() {
        return this.sendToJobServer(this.createMessage("register"));
    }

    public boolean unregister() {
        return this.sendToJobServer(this.createMessage("unregister"));
    }

    @Override
    protected boolean startup() {
        this.println("Starting Client...");
        this.running = super.startup();
        if (this.running) {
            this.running = this.register();
        }
        if (this.running) {
            this.clients.add(new InetSocketAddress(this.getServerHostName(), this.getServerPort()));
        }
        return this.running;
    }

    @Override
    public boolean isOperational() {
        return this.running;
    }

    @Override
    protected Processor createProcessor(Socket client) {
        JobClientProcessor proc = new JobClientProcessor(this, client);
        return proc;
    }

    public static void main(String[] args) throws Exception {
        JobClient app = new JobClient();
        app.run(args);
    }
}

