/*
 * Decompiled with CFR 0.152.
 */
package proper.remote;

import proper.io.CommandLine;
import proper.util.Strings;

public class Job {
    public static final String SEPARATOR = ";";
    private String data;
    private String additional;

    public Job(String data) {
        String[] parts = Strings.breakUp(data, SEPARATOR, "\"");
        this.data = parts[0];
        this.additional = "";
        int i = 1;
        while (i < parts.length) {
            if (i > 1) {
                this.additional = String.valueOf(this.additional) + SEPARATOR;
            }
            this.additional = String.valueOf(this.additional) + parts[i];
            ++i;
        }
    }

    public String getClassName() {
        String[] parts = Strings.breakUp(this.data, " ", "\"");
        return parts[0];
    }

    public String[] getParameter() {
        String[] parts;
        if (!this.data.equals("")) {
            String params = this.data.substring(this.getClassName().length(), this.data.length());
            parts = Strings.breakUp(params, " ", "\"");
            int i = 0;
            while (i < parts.length) {
                if (parts[i].indexOf(" ") > 0 && !parts[i].startsWith("\"") && !parts[i].endsWith("\"")) {
                    parts[i] = "\"" + parts[i] + "\"";
                }
                ++i;
            }
        } else {
            parts = null;
        }
        return parts;
    }

    public String[] getAdditional() {
        String[] parts = !this.additional.equals("") ? Strings.breakUp(this.additional, SEPARATOR, "\"") : null;
        return parts;
    }

    public String getLogFilename() {
        CommandLine cl = new CommandLine(this.getParameter());
        return cl.getValue("log");
    }

    public String toString() {
        String result = this.data;
        if (!this.additional.equals("")) {
            result = String.valueOf(result) + SEPARATOR + this.additional;
        }
        return result;
    }
}

