/*
 * Decompiled with CFR 0.152.
 */
package proper.net;

public class Address {
    private String address;
    private String host;
    private int[] ip;
    private int port;

    public Address(String address) {
        this.address = address;
        this.parse();
    }

    private void parse() {
        String tmpPort;
        String tmpIP;
        this.host = "";
        this.ip = new int[4];
        this.port = 0;
        String tmp = this.address;
        if (tmp.indexOf("/") > -1) {
            this.host = tmp.substring(0, tmp.indexOf("/"));
            tmp = tmp.substring(tmp.indexOf("/") + 1, tmp.length());
        }
        if (tmp.indexOf(":") > -1) {
            tmpIP = tmp.substring(0, tmp.indexOf(":"));
            tmpPort = tmp.substring(tmp.indexOf(":") + 1, tmp.length());
        } else {
            tmpIP = tmp;
            tmpPort = "";
        }
        if (!tmpIP.equals("")) {
            int i = 0;
            while (i < this.ip.length) {
                this.ip[i] = tmpIP.indexOf(".") > -1 ? Integer.parseInt(tmpIP.substring(0, tmpIP.indexOf("."))) : Integer.parseInt(tmpIP);
                tmpIP = tmpIP.substring(tmpIP.indexOf(".") + 1, tmpIP.length());
                ++i;
            }
        }
        if (!tmpPort.equals("")) {
            this.port = Integer.parseInt(tmpPort);
        }
    }

    public String getHost() {
        return this.host;
    }

    public static String getHost(String address) {
        return new Address(address).getHost();
    }

    public byte[] getIP() {
        byte[] result = new byte[this.ip.length];
        int i = 0;
        while (i < this.ip.length) {
            result[i] = (byte)this.ip[i];
            ++i;
        }
        return result;
    }

    public static byte[] getIP(String address) {
        return new Address(address).getIP();
    }

    public String getIPStr() {
        String result = "";
        int i = 0;
        while (i < this.ip.length) {
            if (i > 0) {
                result = String.valueOf(result) + ".";
            }
            result = String.valueOf(result) + Integer.toString(this.ip[i]);
            ++i;
        }
        return result;
    }

    public static String getIPStr(String address) {
        return new Address(address).getIPStr();
    }

    public int getPort() {
        return this.port;
    }

    public static int getPort(String address) {
        return new Address(address).getPort();
    }

    public String toString() {
        return "Host=" + this.getHost() + ", " + "IP=" + this.getIPStr() + ", " + "Port=" + this.getPort();
    }

    public static void main(String[] args) {
        System.out.println(new Address("bla.bla.org/192.168.0.1:1234"));
        System.out.println(new Address("/127.0.0.1"));
    }
}

