/*
 * Decompiled with CFR 0.152.
 */
package proper.io;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import proper.io.AntTarget;
import proper.util.CluderInterface;
import proper.util.Excluder;
import proper.util.Includer;
import proper.util.ProperVector;
import proper.util.Strings;

public class Ant {
    public static final String CLASSNAME = "classname";
    public static final String VALUE = "value";
    public static final String JAVA = "java";
    public static final String ARG = "arg";
    private File file;
    private Project project;
    private ProjectHelper helper;

    public Ant(String filename) {
        this.initialize(filename);
    }

    public Ant(File file) {
        this.initialize(file);
    }

    private void initialize(String filename) {
        try {
            this.initialize(new File(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.project = null;
            this.helper = null;
            this.file = null;
        }
    }

    public String getFilename() {
        if (this.isLoaded()) {
            return this.file.getAbsolutePath();
        }
        return null;
    }

    public boolean isLoaded() {
        return this.project != null;
    }

    private void initialize(File file) {
        this.file = file;
        this.project = new Project();
        this.project.init();
        this.project.setUserProperty("ant.file", file.getAbsolutePath());
        this.helper = ProjectHelper.getProjectHelper();
        this.project.addReference("ant.projectHelper", (Object)this.helper);
        this.helper.parse(this.project, (Object)file);
    }

    public boolean reload() {
        this.initialize(this.getFilename());
        return this.isLoaded();
    }

    public String getName() {
        if (this.isLoaded()) {
            return this.project.getName();
        }
        return null;
    }

    public Project getProject() {
        return this.project;
    }

    public Target getTarget(String target) {
        if (this.isLoaded() && this.project.getTargets().containsKey(target)) {
            return (Target)this.project.getTargets().get(target);
        }
        return null;
    }

    public Vector getTargets() {
        return this.getTargets(new Excluder(""));
    }

    public Vector getTargets(CluderInterface cluder) {
        if (!this.isLoaded()) {
            return null;
        }
        ProperVector result = new ProperVector();
        Enumeration enm = this.project.getTargets().keys();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            if (name.equals("")) continue;
            if (cluder instanceof Includer) {
                if (!cluder.contains(name)) continue;
                result.add(name);
                continue;
            }
            if (!(cluder instanceof Excluder) || cluder.contains(name)) continue;
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    public Vector getAntTargets() {
        return this.getAntTargets(new Excluder(""));
    }

    public Vector getAntTargets(CluderInterface cluder) {
        ProperVector result = new ProperVector();
        Vector targets = this.getTargets(cluder);
        int i = 0;
        while (i < targets.size()) {
            String target = targets.get(i).toString();
            if (this.getJavaTasks(target) != null && this.getJavaTasks(target).size() != 0) {
                result.add(new AntTarget(this, target));
            }
            ++i;
        }
        return result;
    }

    public void setProperty(String property, String value) {
        if (this.isLoaded() && this.project.getProperties().containsKey(property)) {
            this.project.setProperty(property, value);
        }
    }

    public String getProperty(String property) {
        if (this.isLoaded() && this.project.getProperties().containsKey(property)) {
            return this.project.getProperties().get(property).toString();
        }
        return null;
    }

    public Vector getProperties() {
        return this.getProperties(new Excluder(""));
    }

    public Vector getProperties(CluderInterface cluder) {
        if (!this.isLoaded()) {
            return null;
        }
        ProperVector result = new ProperVector();
        Enumeration enm = this.project.getProperties().keys();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            if (cluder instanceof Includer) {
                if (!cluder.contains(name)) continue;
                result.add(name);
                continue;
            }
            if (!(cluder instanceof Excluder) || cluder.contains(name)) continue;
            result.add(name);
        }
        return result;
    }

    public Vector getTasks(String target) {
        Target t = this.getTarget(target);
        if (t == null) {
            return null;
        }
        ProperVector result = new ProperVector();
        Task[] tasks = t.getTasks();
        int i = 0;
        while (i < tasks.length) {
            result.add(tasks[i]);
            ++i;
        }
        return result;
    }

    public String expand(String arg) {
        String result = arg;
        Vector props = this.getProperties();
        if (result.indexOf("${") > -1) {
            int i = 0;
            while (i < props.size()) {
                if (result.indexOf("${") == -1) break;
                result = Strings.replaceAll(result, "${" + (String)props.get(i) + "}", this.getProperty((String)props.get(i)));
                ++i;
            }
        }
        return result;
    }

    public Vector expand(Vector args) {
        ProperVector result = new ProperVector();
        int i = 0;
        while (i < args.size()) {
            result.add(this.expand(args.get(i).toString()));
            ++i;
        }
        return result;
    }

    public Vector getJavaTasks(String target) {
        Vector tasks = this.getTasks(target);
        if (tasks == null) {
            return null;
        }
        ProperVector result = new ProperVector();
        int i = 0;
        while (i < tasks.size()) {
            Task t = (Task)tasks.get(i);
            if (t.getTaskName().equals(JAVA)) {
                result.add(tasks.get(i));
            }
            ++i;
        }
        return result;
    }

    public String getClassname(Task task) {
        if (task != null) {
            RuntimeConfigurable rt = task.getRuntimeConfigurableWrapper();
            if (rt.getAttributeMap().containsKey(CLASSNAME)) {
                return this.expand(rt.getAttributeMap().get(CLASSNAME).toString());
            }
            return null;
        }
        return null;
    }

    public Vector getArguments(Task task) {
        if (task == null) {
            return null;
        }
        Vector result = new ProperVector();
        RuntimeConfigurable rt = task.getRuntimeConfigurableWrapper();
        Enumeration enm = rt.getChildren();
        while (enm.hasMoreElements()) {
            RuntimeConfigurable rtChild;
            Object o = enm.nextElement();
            if (!(o instanceof RuntimeConfigurable) || !(rtChild = (RuntimeConfigurable)o).getElementTag().equals(ARG)) continue;
            result.add(rtChild.getAttributeMap().get(VALUE));
        }
        result = this.expand(result);
        return result;
    }

    public String toString() {
        if (!this.isLoaded()) {
            return "-Error-";
        }
        String result = "File: " + this.file.getAbsolutePath() + "\n";
        result = String.valueOf(result) + "Project: " + this.getName() + "\n";
        Vector items = this.getTargets();
        result = String.valueOf(result) + "\nTargets:\n";
        int i = 0;
        while (i < items.size()) {
            result = String.valueOf(result) + " - " + items.get(i) + "\n";
            ++i;
        }
        items = this.getProperties();
        result = String.valueOf(result) + "\nProperties:\n";
        i = 0;
        while (i < items.size()) {
            result = String.valueOf(result) + " - " + items.get(i) + ": " + this.getProperty(items.get(i).toString()) + "\n";
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            Ant ant = args.length == 1 ? new Ant(args[0]) : new Ant("build.xml");
            System.out.println(ant);
            Vector tasks = ant.getJavaTasks("eastwest");
            Task task = null;
            if (tasks != null && tasks.size() > 0) {
                task = (Task)tasks.get(0);
                System.out.println(String.valueOf(ant.getClassname(task)) + ": " + ant.getArguments(task));
            }
            System.out.println(ant.getAntTargets());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

