/*
 * Decompiled with CFR 0.152.
 */
package proper.imp;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import proper.core.ProperObject;
import proper.imp.Data;
import proper.imp.List;
import proper.imp.Predicate;
import proper.util.ProperVector;
import proper.util.RandomID;

public class Traverser
extends ProperObject {
    private Vector predicates;
    private boolean analyzed;
    private Hashtable preds;
    private Hashtable lists;
    private Hashtable indexed;

    public Traverser(Vector predicates) {
        this.predicates = predicates;
        this.analyzed = false;
        this.preds = new Hashtable();
        this.lists = new Hashtable();
        this.indexed = new Hashtable();
    }

    public void invalidate() {
        this.analyzed = false;
    }

    private void analyze(Data d) {
        Vector refs;
        Hashtable table = d instanceof Predicate ? this.preds : this.lists;
        if (!table.containsKey(d.getName())) {
            table.put(d.getName(), new ProperVector());
        }
        if (!(refs = (Vector)table.get(d.getName())).contains(d)) {
            refs.add(d);
        }
        int i = 0;
        while (i < d.size()) {
            Object o = d.get(i);
            if (o instanceof Predicate || o instanceof List) {
                this.analyze((Data)o);
            }
            ++i;
        }
    }

    private void analyze() {
        if (this.analyzed) {
            return;
        }
        this.println("Analyzing structure...");
        this.preds.clear();
        this.lists.clear();
        this.indexed.clear();
        int i = 0;
        while (i < this.predicates.size()) {
            this.analyze((Data)this.predicates.get(i));
            ++i;
        }
        this.analyzed = true;
    }

    public boolean isPredicate(String name) {
        return this.preds.containsKey(name);
    }

    private Vector get(Hashtable table) {
        this.analyze();
        ProperVector result = new ProperVector();
        Enumeration enm = table.keys();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        return result;
    }

    public Vector getAll() {
        Vector result = this.getPredicates();
        result.addAll(this.getLists());
        return result;
    }

    public Vector getPredicates() {
        return this.get(this.preds);
    }

    public Vector getLists() {
        return this.get(this.lists);
    }

    private Data findFirst(Hashtable table, String name) {
        Vector v;
        this.analyze();
        Data result = null;
        if (table.containsKey(name) && (v = (Vector)table.get(name)).size() > 0) {
            result = (Data)v.get(0);
        }
        return result;
    }

    public Data findFirst(String name) {
        if (this.isPredicate(name)) {
            return this.findFirst(this.preds, name);
        }
        return this.findFirst(this.lists, name);
    }

    public Predicate findFirstPredicate(String name) {
        return (Predicate)this.findFirst(this.preds, name);
    }

    public List findFirstList(String name) {
        return (List)this.findFirst(this.lists, name);
    }

    private Vector findAll(Hashtable table, String name) {
        this.analyze();
        Vector result = new ProperVector();
        if (name.equals("")) {
            Vector names = this.get(table);
            int i = 0;
            while (i < names.size()) {
                result.addAll((Vector)table.get(names.get(i)));
                ++i;
            }
        } else if (table.containsKey(name)) {
            result = (Vector)table.get(name);
        }
        return result;
    }

    public Vector findAll(String name) {
        if (this.isPredicate(name)) {
            return this.findAll(this.preds, name);
        }
        return this.findAll(this.lists, name);
    }

    public Vector findAllPredicates(String name) {
        return this.findAll(this.preds, name);
    }

    public Vector findAll() {
        Vector result = this.findAllPredicates();
        result.addAll(this.findAllLists());
        return result;
    }

    public Vector findAllPredicates() {
        return this.findAllPredicates("");
    }

    public Vector findAllLists(String name) {
        return this.findAll(this.lists, name);
    }

    public Vector findAllLists() {
        return this.findAllLists("");
    }

    public Vector findAllArgTypes(String name) {
        ProperVector result = new ProperVector();
        Vector datas = this.findAll(name);
        if (datas.size() == 0) {
            return result;
        }
        int argCount = ((Data)datas.get(0)).size();
        int i = 0;
        while (i < argCount) {
            result.add("NULL");
            int n = 0;
            while (n < datas.size()) {
                Data d = (Data)datas.get(n);
                if (i < d.size() && !d.get(i).toString().equals("NULL")) {
                    result.set(i, d.get(i));
                    break;
                }
                ++n;
            }
            if (!this.isPredicate(name)) break;
            ++i;
        }
        return result;
    }

    public int getMaxLength(String name, int index) {
        this.analyze();
        Vector datas = this.findAll(name);
        int result = -1;
        int i = 0;
        while (i < datas.size()) {
            int len;
            Data d = (Data)datas.get(i);
            if (d.get(index) != null && !d.isNull(index) && (len = d.get(index).toString().length()) > result) {
                result = len;
            }
            ++i;
        }
        return result;
    }

    public Vector getAllValues(String name, int index) {
        this.analyze();
        ProperVector result = new ProperVector();
        Vector datas = this.findAll(name);
        int i = 0;
        while (i < datas.size()) {
            Data d = (Data)datas.get(i);
            Object v = d.get(index);
            if (v != null && !result.contains(v)) {
                result.add(v);
            }
            ++i;
        }
        return result;
    }

    private void shuffleIDs(Hashtable table) {
        this.analyze();
        Vector datas = this.findAll(table, "");
        Enumeration enm = datas.elements();
        RandomID randID = new RandomID(datas.size());
        while (randID.hasMoreElements()) {
            Data d = (Data)enm.nextElement();
            d.setID((Integer)randID.nextElement());
        }
    }

    public void shuffleIDs() {
        this.shuffleIDs(this.preds);
        this.shuffleIDs(this.lists);
    }

    public boolean keyIsUnique(String name) {
        HashSet<Object> keys = new HashSet<Object>();
        Vector preds = this.findAllPredicates(name);
        boolean result = true;
        int i = 0;
        while (i < preds.size()) {
            Predicate p = (Predicate)preds.get(i);
            keys.add(p.get(0));
            if (keys.size() != i + 1) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public void remove(Data d) {
        int index = this.predicates.indexOf(d);
        if (index > -1) {
            this.predicates.remove(index);
            this.analyzed = false;
        }
    }

    public void add(Predicate p) {
        this.predicates.add(p);
        this.analyzed = false;
    }

    public Hashtable indexPredicate(String name, int index) {
        if (this.indexed.containsKey(name)) {
            Hashtable result = (Hashtable)this.indexed.get(name);
            return result;
        }
        this.println("Indexing " + name + " over index " + index + "...");
        Hashtable<Object, Predicate> result = new Hashtable<Object, Predicate>();
        Vector preds = this.findAllPredicates(name);
        int i = 0;
        while (i < preds.size()) {
            Predicate p = (Predicate)preds.get(i);
            result.put(p.get(index), p);
            ++i;
        }
        this.indexed.put(name, result);
        return result;
    }

    @Override
    public String toString() {
        String result = "";
        int i = 0;
        while (i < this.predicates.size()) {
            result = String.valueOf(result) + this.predicates.get(i);
            ++i;
        }
        return result;
    }
}

