/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import proper.gui.core.dialog.FileChooser;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.table.JTableHelper;
import proper.gui.core.table.LoggerTableModel;

public class Logger
extends ChildFrame
implements ChangeListener,
ListSelectionListener {
    private static final String ACTION_LOAD = "load";
    private static final String ACTION_SEARCH = "search";
    private static final String ACTION_GOTO = "goto";
    private static final String ACTION_UNFOLD = "unfold";
    private JTabbedPane tabbedPane;
    private JPanel panelFile;
    private JPanel panelEntry;
    private JTextField textFilter;
    private JTextField textGoto;
    private JButton buttonFilter;
    private JButton buttonGoto;
    private JButton buttonLoad;
    private JButton buttonUnfold;
    private JTable tableLog;
    private JTextArea areaEntry;
    private JScrollPane paneEntry;
    private FileChooser fileChooser;
    private String filename;

    public Logger(ApplicationFrame parent) {
        super(parent, "Logger");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.filename = "";
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.setConfirmExit(false);
        this.fileChooser = new FileChooser(new File(System.getProperty("user.dir")));
        this.panelFile = new JPanel(new BorderLayout());
        this.panelEntry = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.addTab("File", ImageLoader.getImageIcon("explorer.gif"), this.panelFile);
        this.tabbedPane.addTab("Entry", ImageLoader.getImageIcon("preview.gif"), this.panelEntry);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.tableLog = new JTable(new LoggerTableModel(null));
        this.tableLog.setAutoResizeMode(0);
        JTableHelper.setOptimalColumnWidth(this.tableLog);
        this.tableLog.getSelectionModel().addListSelectionListener(this);
        this.tableLog.addMouseListener(this);
        JScrollPane pane = new JScrollPane(this.tableLog);
        this.panelFile.add((Component)pane, "Center");
        this.textGoto = new JTextField("", 10);
        this.buttonGoto = new JButton("Goto", ImageLoader.getImageIcon("back.gif"));
        this.buttonGoto.setActionCommand(ACTION_GOTO);
        this.buttonGoto.addActionListener(this);
        this.textFilter = new JTextField("", 20);
        this.buttonFilter = new JButton("Filter", ImageLoader.getImageIcon("find.gif"));
        this.buttonFilter.setActionCommand(ACTION_SEARCH);
        this.buttonFilter.addActionListener(this);
        this.buttonUnfold = new JButton("Unfold", ImageLoader.getImageIcon("tree.gif"));
        this.buttonUnfold.setActionCommand(ACTION_UNFOLD);
        this.buttonUnfold.addActionListener(this);
        this.buttonLoad = new JButton("Load", ImageLoader.getImageIcon("open.gif"));
        this.buttonLoad.setActionCommand(ACTION_LOAD);
        this.buttonLoad.addActionListener(this);
        JSeparator separator = new JSeparator(1);
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(this.textGoto);
        panel.add(this.buttonGoto);
        panel.add(this.textFilter);
        panel.add(this.buttonFilter);
        panel.add(this.buttonUnfold);
        panel.add(separator);
        panel.add(this.buttonLoad);
        this.getContentPane().add((Component)panel, "North");
        this.areaEntry = new JTextArea();
        this.areaEntry.setLineWrap(true);
        this.areaEntry.setFont(Font.decode(this.getCustomFont()));
        this.paneEntry = new JScrollPane(this.areaEntry);
        this.panelEntry.add((Component)this.paneEntry, "Center");
    }

    @Override
    protected void setFrameTitle() {
        if (this.filename.equals("")) {
            this.setTitle("Logger");
        } else {
            this.setTitle("Logger - " + this.filename);
        }
        super.setFrameTitle();
    }

    private void loadFile() {
        int retVal;
        if (!this.filename.equals("")) {
            try {
                this.fileChooser.setSelectedFile(new File(this.filename));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((retVal = this.fileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        this.filename = this.fileChooser.getSelectedFile().getAbsolutePath();
        this.setFrameTitle();
        LoggerTableModel model = new LoggerTableModel(this.filename);
        this.tableLog.setModel(model);
        JTableHelper.setOptimalColumnWidth(this.tableLog);
    }

    private void search() {
        this.search(-1);
    }

    private void search(int col) {
        this.search(col, this.textFilter.getText());
    }

    private void search(int col, String text) {
        LoggerTableModel model = (LoggerTableModel)this.tableLog.getModel();
        model.filter(text, false, col);
        this.refresh();
    }

    private void clear() {
        int line;
        if (this.tableLog.getSelectedRow() > -1) {
            LoggerTableModel model = (LoggerTableModel)this.tableLog.getModel();
            line = model.getLineNumber(this.tableLog.getSelectedRow());
        } else {
            line = -1;
        }
        this.search(-1, "");
        if (line > 0) {
            this.gotoLine(line);
        }
    }

    private void gotoLine() {
        if (this.textGoto.getText().equals("")) {
            return;
        }
        this.gotoLine(Integer.parseInt(this.textGoto.getText()));
    }

    private void gotoLine(int line) {
        LoggerTableModel model = (LoggerTableModel)this.tableLog.getModel();
        line = model.getIndex(line);
        this.tableLog.getSelectionModel().setSelectionInterval(line, line);
        JTableHelper.scrollToVisible(this.tableLog, line, 0);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.tabbedPane.getModel().getSelectedIndex() == 1) {
            int[] indices = this.tableLog.getSelectedRows();
            LoggerTableModel model = (LoggerTableModel)this.tableLog.getModel();
            Vector entries = model.getEntries(indices);
            String tmp = "";
            int i = 0;
            while (i < entries.size()) {
                tmp = String.valueOf(tmp) + entries.get(i).toString() + "\n";
                ++i;
            }
            this.areaEntry.setText(tmp);
            this.refresh();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        LoggerTableModel model;
        int line;
        if (this.tableLog.getSelectedRow() > -1 && (line = (model = (LoggerTableModel)this.tableLog.getModel()).getLineNumber(this.tableLog.getSelectedRow())) > 0) {
            this.textGoto.setText(Integer.toString(line));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getComponent() == this.tableLog) {
            int row = this.tableLog.rowAtPoint(e.getPoint());
            if (e.getClickCount() == 2 && row > -1) {
                e.consume();
                this.tabbedPane.setSelectedIndex(1);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ACTION_LOAD)) {
            this.loadFile();
        } else if (action.equals(ACTION_SEARCH)) {
            this.search();
        } else if (action.equals(ACTION_UNFOLD)) {
            this.clear();
        } else if (action.equals(ACTION_GOTO)) {
            this.gotoLine();
        }
    }

    @Override
    public void printDescription() {
        System.out.println("A little tool for handling logfiles.");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        Logger frame = new Logger(null);
        frame.run(args);
    }
}

