/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.text;

import java.io.PrintStream;
import javax.swing.JTextArea;

public class JTextAreaPrintStream
extends PrintStream {
    private JTextArea area;
    private boolean moveToEnd;

    public JTextAreaPrintStream(JTextArea area) {
        super(System.out);
        this.area = area;
        this.moveToEnd = true;
    }

    public void setMoveToEnd(boolean moveToEnd) {
        this.moveToEnd = moveToEnd;
        if (this.getMoveToEnd()) {
            this.updateCaretPosition();
        }
    }

    public boolean getMoveToEnd() {
        return this.moveToEnd;
    }

    private void updateCaretPosition() {
        try {
            this.area.setCaretPosition(this.area.getText().length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void print(boolean b) {
        this.print("" + b);
    }

    @Override
    public void print(char c) {
        this.print("" + c);
    }

    @Override
    public void print(char[] s) {
        this.print(new String(s));
    }

    @Override
    public void print(double d) {
        this.print("" + d);
    }

    @Override
    public void print(float f) {
        this.print("" + f);
    }

    @Override
    public void print(int i) {
        this.print("" + i);
    }

    @Override
    public void print(long l) {
        this.print("" + l);
    }

    @Override
    public void print(Object obj) {
        this.print(obj.toString());
    }

    @Override
    public void print(String s) {
        this.area.append(s);
        if (this.getMoveToEnd()) {
            this.updateCaretPosition();
        }
    }

    @Override
    public void println() {
        this.print("\n");
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(Object x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.println();
    }

    @Override
    protected void setError() {
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        int i = off;
        while (i < off + len) {
            this.write(buf[i]);
            ++i;
        }
    }

    @Override
    public void write(int b) {
        this.print(b);
    }
}

