/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.panel;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import proper.database.Connector;
import proper.database.TableLister;
import proper.gui.core.dialog.DataBaseConnectDialog;
import proper.gui.core.dialog.ProperDialog;
import proper.gui.core.panel.ProperPanel;

public class TableChooserPanel
extends ProperPanel
implements ActionListener {
    private Connector conn;
    private ProperDialog parent;
    private JPanel jp_tables;
    private JLabel jl_tables;
    private JComboBox jcb_tables;

    public TableChooserPanel(ProperDialog parent, Connector conn) {
        this.conn = conn;
        this.parent = parent;
        this.initComponent();
    }

    private void initComponent() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.jp_tables = new JPanel(new FlowLayout(3));
        TitledBorder t1 = new TitledBorder("Select a table");
        this.jp_tables.setBorder(t1);
        this.jl_tables = new JLabel("Tables : ");
        this.jcb_tables = new JComboBox();
        this.jcb_tables.addActionListener(this);
        this.jcb_tables.addItem("Choose...");
        this.jcb_tables.setSelectedIndex(0);
        this.jcb_tables.setEditable(false);
        this.jp_tables.add(this.jl_tables);
        this.jp_tables.add(this.jcb_tables);
        this.add((Component)this.jp_tables, "Center");
        if (this.conn.getConnection() != null) {
            this.listedTables();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jcb_tables) {
            this.changeTable();
        }
    }

    private void listedTables() {
        if (this.conn != null) {
            try {
                TableLister lister = new TableLister(this.conn);
                lister.setSort(true);
                Vector list = lister.getList();
                int i = 0;
                while (i < list.size()) {
                    this.jcb_tables.addItem(list.get(i).toString());
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void changeTable() {
        if (this.jcb_tables.getSelectedIndex() > 0) {
            ((DataBaseConnectDialog)this.parent).changeOkButtonStatus(true);
            this.conn.setTable(this.jcb_tables.getSelectedItem().toString());
        } else {
            ((DataBaseConnectDialog)this.parent).changeOkButtonStatus(false);
        }
    }
}

