/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.list;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import proper.gui.core.list.JListHelper;

public class List
extends JList
implements ActionListener,
MouseListener {
    private JListHelper helper;
    private JPopupMenu popup;
    private JMenuItem menuSelect;
    private JMenuItem menuInvert;
    private boolean usePopup;

    public List() {
        this.initialize();
    }

    public List(ListModel dataModel) {
        super(dataModel);
        this.initialize();
    }

    public List(Object[] listData) {
        super(listData);
        this.initialize();
    }

    public List(Vector listData) {
        super(listData);
        this.initialize();
    }

    protected void initialize() {
        this.helper = new JListHelper(this);
        this.usePopup = false;
        this.popup = new JPopupMenu();
        this.popup.addMouseListener(this);
        this.menuSelect = new JMenuItem("Select...");
        this.menuSelect.addActionListener(this);
        this.popup.add(this.menuSelect);
        this.popup.addSeparator();
        this.menuInvert = new JMenuItem("Invert Selection");
        this.menuInvert.addActionListener(this);
        this.popup.add(this.menuInvert);
        this.addMouseListener(this);
    }

    public JListHelper getListHelper() {
        return this.helper;
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setPopupMenuEnabled(boolean enable) {
        this.usePopup = enable;
    }

    public boolean isPopupMenuEnabled() {
        return this.usePopup;
    }

    public void select() {
        String searchString = JOptionPane.showInputDialog(this.getParent(), (Object)"Enter the string to search for");
        if (searchString != null) {
            this.select(searchString);
        }
    }

    public void select(String searchString) {
        this.setSelectedIndices(this.getListHelper().getMatches(searchString));
    }

    public void invertSelection() {
        this.setSelectedIndices(this.getListHelper().getInverseSelectedIndices());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.menuSelect) {
            this.select();
        } else if (source == this.menuInvert) {
            this.invertSelection();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.usePopup && e.getSource() == this && e.getButton() == 3 && e.getClickCount() == 1) {
            e.consume();
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

