/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.frame;

import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import proper.core.CommandLineInterface;
import proper.gui.core.dialog.MessageBox;
import proper.gui.core.frame.ProperFrame;
import proper.io.CommandLine;
import proper.io.CommandLineParameter;
import proper.util.ProperVector;
import proper.util.Strings;

public class CommandLineFrame
extends ProperFrame
implements CommandLineInterface {
    protected CommandLine cl;
    protected boolean confirmExit;
    protected String font;
    protected int indention;
    protected Vector parameters;
    protected Vector notes;

    public CommandLineFrame(String title) {
        super(title);
    }

    protected String getCustomFont() {
        return this.font;
    }

    protected void setCustomFont(String font) {
        this.font = font;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.cl = new CommandLine();
        this.font = "Monospaced-PLAIN-12";
        this.setConfirmExit(true);
        this.parameters = new ProperVector();
        this.notes = new ProperVector();
        this.indention = 1;
        this.defaultParameters();
        this.defineParameters();
        this.setDefinitions(this.cl);
    }

    protected void addDefinition(String name, String description, boolean hasArgument, String argDesc, boolean optional) {
        CommandLineParameter p = new CommandLineParameter(name, description, hasArgument, argDesc, optional);
        p.setIndention(this.indention);
        this.parameters.add(p);
    }

    protected void addNote(String note) {
        this.notes.add(note);
    }

    protected void defaultParameters() {
    }

    protected void defineParameters() {
        this.addDefinition("verbose", "sets the verbose flag of the specified class(es), 'all' matches them all", true, "class[,class[,..]]", true);
        this.addDefinition("log", "redirects the output into the specified file", true, "<filename>", true);
        this.addDefinition("append_log", "with this the file is not deleted at the beginning", true, "yes | no", true);
        this.addDefinition("font", "the font to use in lists etc., default is " + this.getCustomFont(), true, "<name-face-size>", true);
        this.addDefinition("help", "to print this help", false, "", true);
    }

    protected void setDefinitions(CommandLine cl) {
        cl.clearParameterDefinitions();
        int i = 0;
        while (i < this.parameters.size()) {
            cl.addParameterDefinition((CommandLineParameter)this.parameters.get(i));
            ++i;
        }
    }

    @Override
    public void setArgs(CommandLine cl) {
        this.cl.setArguments(cl.toArray());
        this.checkCommandLine();
    }

    @Override
    public void checkCommandLine() {
        if (this.cl.exists("help")) {
            this.printUsage();
            System.exit(0);
        }
        if (!this.cl.isComplete()) {
            this.parameterError();
        }
    }

    @Override
    public void parameterError() {
        int i;
        this.printUsage();
        if (this.cl.getMissing().size() > 0) {
            System.out.println("The following parameter(s) are missing:");
            i = 0;
            while (i < this.cl.getMissing().size()) {
                System.out.println(" -" + this.cl.getMissing().get(i));
                ++i;
            }
            System.out.println();
        }
        if (this.cl.getErroneous().size() > 0) {
            System.out.println("The following parameter(s) are incorrect:");
            i = 0;
            while (i < this.cl.getErroneous().size()) {
                System.out.println(" -" + this.cl.getErroneous().get(i));
                ++i;
            }
            System.out.println();
        }
        System.exit(1);
    }

    @Override
    public void printDescription() {
    }

    @Override
    public void printUsage() {
        System.out.println("\n" + this.getClass().getName() + "\n" + this.getClass().getName().replaceAll(".", "=") + "\n");
        this.printDescription();
        System.out.println("Parameters:\n");
        int i = 0;
        while (i < this.parameters.size()) {
            System.out.println(this.parameters.get(i) + "\n");
            ++i;
        }
        if (this.notes.size() > 0) {
            System.out.println("Notes:\n");
            i = 0;
            while (i < this.notes.size()) {
                Vector lines = Strings.breakUpVector(this.notes.get(i).toString(), "\n");
                int n = 0;
                while (n < lines.size()) {
                    System.out.println(String.valueOf(Strings.stringOf(" ", this.indention)) + lines.get(n).toString());
                    ++n;
                }
                System.out.println();
                ++i;
            }
        }
    }

    public void setConfirmExit(boolean confirm) {
        this.confirmExit = confirm;
    }

    public boolean getConfirmExit() {
        return this.confirmExit;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.confirmExit) {
            int button = this.showMessageBox("Quit - " + this.getTitle(), "Do you really want to quit?", MessageBox.BUTTONS_YESNO, "question.gif");
            if (button == 0) {
                this.dispose();
            } else {
                this.setDefaultCloseOperation(0);
            }
        } else {
            this.dispose();
        }
        super.windowClosing(e);
    }

    protected boolean beforeCreate() {
        return true;
    }

    protected boolean afterCreate() {
        return true;
    }

    public String fixAdditionalArg(String arg) {
        StringTokenizer tok = new StringTokenizer(arg, " ");
        arg = "";
        while (tok.hasMoreTokens()) {
            String tmp = tok.nextToken();
            if (tmp.startsWith("=")) {
                tmp = "-" + tmp.substring(1);
            }
            arg = String.valueOf(arg) + tmp + " ";
        }
        arg = arg.trim();
        return arg;
    }

    @Override
    public boolean run(String[] args) throws Exception {
        this.setArgs(new CommandLine(args));
        if (this.cl.exists("verbose")) {
            this.setVerboseString(this.cl.getValue("verbose"));
        }
        if (this.cl.exists("log") && !this.cl.getValue("log").equals("")) {
            System.out.println("Output is redirected to '" + this.cl.getValue("log") + "'...");
            this.setOutput(new PrintStream(new BufferedOutputStream(new FileOutputStream(this.cl.getValue("log"), this.cl.getValue("append_log").equals("yes")))));
        }
        this.font = this.cl.getValue("font", this.font);
        this.println(this);
        boolean result = this.beforeCreate();
        if (result) {
            this.createFrame();
            result = this.afterCreate();
        }
        if (result) {
            this.setVisible(true);
        }
        return result;
    }

    @Override
    public String toString() {
        String result = String.valueOf(this.getClass().getName()) + ":";
        Vector params = this.cl.getParameters();
        int i = 0;
        while (i < params.size()) {
            String param = (String)params.get(i);
            result = String.valueOf(result) + " -" + param;
            if (!this.cl.getValue(param).equals("")) {
                result = String.valueOf(result) + " \"" + this.cl.getValue(param) + "\"";
            }
            ++i;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        CommandLineFrame frame = new CommandLineFrame("Frame-Test");
        frame.run(args);
    }
}

