/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.util.Arrays;
import java.util.Vector;
import proper.database.ColumnLister;
import proper.database.Dropper;
import proper.database.Join;
import proper.database.JoinTreeNode;
import proper.database.Joiner;
import proper.database.RelationDiscoverer;
import proper.database.Table;
import proper.database.TableLister;
import proper.engine.DatabaseEngine;
import proper.engine.Flattener;
import proper.relaggs.RelaggsConfig;
import proper.relaggs.RelaggsStructure;
import proper.relaggs.RelaggsTable;
import proper.relaggs.SqlEngine;
import proper.util.ProperVector;
import proper.util.Set;
import proper.util.TemporaryName;

public class Relaggs
extends DatabaseEngine {
    private static final String TMPPREFIX = "_relaggsed_";
    public static final String COLUMN_PREFIX = "dup";
    private SqlEngine sql;
    private RelationDiscoverer discoverer;
    private TableLister tabLister;
    private ColumnLister colLister;
    private Dropper dropper;
    private TemporaryName tmpName;

    public Relaggs() {
        this.setParameter("database", "relaggs");
        this.setParameter("table", "tab_loan");
        this.setParameter("result_table", "_relaggs");
        this.setParameter("field", "status");
        this.setParameter("join", "natural");
        this.setParameter("any_index", "no");
        this.setParameter("index", "");
        this.setParameter("exclude_tables", "");
        this.setParameter("max_depth", "1");
        this.setParameter("instead_null", "");
        this.setParameter("tree", "");
        this.setParameter("properties", "");
    }

    private void dropTables(boolean onlyTemporary) {
        Vector tables = this.tabLister.getList(this.getParameter("result_table") + "tmp" + "%");
        tables.addAll(this.tabLister.getList("_relaggsed_%"));
        if (!onlyTemporary) {
            tables.add(this.getParameter("result_table"));
        }
        this.dropper.drop(tables);
    }

    private String addToExcludes(String excludes, String table) {
        if (!excludes.equals("")) {
            excludes = String.valueOf(excludes) + ",";
        }
        excludes = String.valueOf(excludes) + table;
        return excludes;
    }

    private String buildExcludes(JoinTreeNode node) {
        String result = this.getStringParameter("exclude_tables");
        Vector all = this.tabLister.getList();
        Vector others = node.getAllTables();
        all = Set.minus(all, others);
        int i = 0;
        while (i < all.size()) {
            result = this.addToExcludes(result, all.get(i).toString());
            ++i;
        }
        return result;
    }

    private RelaggsTable aggregateAttributes(RelaggsTable main, RelaggsTable aggr, Join join) throws IllegalArgumentException {
        String new_table = this.sql.aggregateAttributes(main, aggr, join, this.getParameter("result_table") + "tmp", this.sql.getTmpNumber());
        RelaggsStructure struct = this.sql.getAttributes(aggr, aggr.getAttribute(join.getRightColumn()));
        RelaggsTable res_table = this.sql.getTable(new_table);
        res_table.setShortName(this.sql.getTmpNumber(), new_table.startsWith(this.getParameter("result_table") + "tmp"));
        this.sql.addAggregatedAttributes(res_table, aggr, struct, join);
        res_table = this.sql.getTable(res_table.getName());
        res_table.setShortName(this.sql.getTmpNumber(), new_table.startsWith(this.getParameter("result_table") + "tmp"));
        this.sql.incTmpNumber();
        return res_table;
    }

    private boolean flatten(JoinTreeNode node, String result_table) {
        if (this.getVerbose()) {
            this.println("Flattening: " + node.getJoin().getLeftTable() + " -> " + result_table);
        }
        Flattener flattener = new Flattener();
        this.addListener(flattener);
        flattener.setParameter("driver", this.getParameter("driver"));
        flattener.setParameter("url", this.getParameter("url"));
        flattener.setParameter("database", this.getParameter("database"));
        flattener.setParameter("user", this.getParameter("user"));
        flattener.setParameter("password", this.getParameter("password"));
        flattener.setParameter("table", node.getJoin().getLeftTable().toString());
        flattener.setParameter("field", "");
        flattener.setParameter("join", this.getParameter("join"));
        flattener.setParameter("result_table", result_table);
        flattener.setParameter("exclude_tables", this.buildExcludes(node));
        flattener.setParameter("max_depth", "-1");
        flattener.setParameter("tree", node.toTreeString(true));
        flattener.setParameter("instead_null", this.getParameter("instead_null"));
        flattener.setTemporaryName(this.tmpName);
        flattener.setShowRelations(false);
        if (this.exists("use_foreign_keys")) {
            flattener.setParameter("use_foreign_keys", this.getStringParameter("use_foreign_keys"));
        }
        boolean result = flattener.execute();
        Join oldJoin = node.getJoin();
        node.getJoin().assign(new Join(result_table, oldJoin.getLeftColumn(), oldJoin.getSize(), oldJoin.getRightTable(), oldJoin.getRightColumn()));
        node.removeAllChildren();
        return result;
    }

    private boolean flatten(JoinTreeNode root) {
        boolean result = true;
        this.println("\nRelations for flattening:\n");
        this.println(root.toString(true));
        this.println("Left over tables: " + this.discoverer.leftOverTables(root));
        int i = 0;
        while (i < root.getChildCount()) {
            JoinTreeNode node = (JoinTreeNode)root.getChildAt(i);
            if (node.getChildCount() > 0) {
                result = this.flatten(node, this.tmpName.next());
                if (!result) break;
                node.removeAllChildren();
            }
            ++i;
        }
        return result;
    }

    private boolean relaggs(JoinTreeNode root) {
        this.println("\nRelations for RELAGGS:\n");
        this.println(root.toString(true));
        this.println("Left over tables: " + this.discoverer.leftOverTables(root));
        Vector all = this.tabLister.getList();
        ProperVector others = new ProperVector();
        if (root.isJoin()) {
            others.add(new Table(root.getJoin().getLeftTable()));
        } else {
            others.add(new Table(root.getTable().getName()));
        }
        int i = 0;
        while (i < root.getChildCount()) {
            others.add(new Table(root.getChildJoinAt(i).getLeftTable()));
            ++i;
        }
        all = Set.minus(all, others);
        String excl = "";
        i = 0;
        while (i < all.size()) {
            excl = this.addToExcludes(excl, all.get(i).toString());
            ++i;
        }
        RelaggsConfig.setPropertiesList(this.getStringParameter("properties"));
        this.sql.setLeftOuterJoin(Joiner.parseType(this.getStringParameter("join")) == 1);
        this.sql.setUseAnyIndex(this.valueEquals("any_index", "yes"));
        this.sql.setUseIndex(this.getStringParameter("index"));
        this.sql.setExcludedTables(excl);
        if (this.getStringParameter("exclude_fields") != null && !this.getStringParameter("exclude_fields").isEmpty()) {
            this.sql.setExcludedFields(this.getStringParameter("exclude_fields"));
        }
        this.sql.setTargetTable(this.getStringParameter("table"));
        this.sql.setTargetField(this.getStringParameter("field"));
        this.sql.setTmpNumber(1);
        RelaggsTable table = this.sql.getTable(root.getTable().getName());
        RelaggsTable result = (RelaggsTable)table.clone();
        boolean performed = false;
        i = 0;
        while (i < root.getChildCount()) {
            performed = true;
            Join join = root.getChildJoinAt(i);
            RelaggsTable child = this.sql.getTable(join.getLeftTable());
            String tmp_table = result.getName();
            result = this.aggregateAttributes(result, child, join);
            Table oldTable = root.getTable();
            root.getTable().assign(new Table(result.getName(), oldTable.getSize()));
            root.updateChildren();
            if (tmp_table.startsWith(this.getParameter("result_table") + "tmp")) {
                this.sql.dropTable(tmp_table);
            }
            ++i;
        }
        if (performed) {
            this.sql.renameTable(result.getName(), this.getStringParameter("result_table"));
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean result;
        super.execute();
        try {
            if (this.getStringParameter("driver").equals("")) {
                this.setParameter("driver", "org.gjt.mm.mysql.Driver");
            }
            if (this.getStringParameter("url").equals("")) {
                this.setParameter("url", "org.gjt.mm.mysql.Driver");
            }
            this.sql = new SqlEngine(this.conn);
            this.colLister = new ColumnLister(this.conn);
            this.colLister.setSort(true);
            this.tabLister = new TableLister(this.conn);
            this.tabLister.setSort(true);
            this.dropper = new Dropper(this.conn);
            this.discoverer = new RelationDiscoverer(this.conn);
            this.discoverer.setTable(this.getStringParameter("table"));
            this.discoverer.setExcludes(this.getStringParameter("exclude_tables"));
            this.discoverer.setMaxDepth(Integer.parseInt(this.getStringParameter("max_depth")));
            this.discoverer.setUseForeignKeys(this.exists("use_foreign_keys"));
            if (this.getStringParameter("associated_tables") != null && !this.getStringParameter("associated_tables").isEmpty()) {
                this.discoverer.setAssociatedTables(Arrays.asList(this.getStringParameter("associated_tables").split(",")));
            }
            this.dropTables(false);
            JoinTreeNode root = !this.getStringParameter("tree").equals("") ? JoinTreeNode.parseTreeString(this.getStringParameter("tree")) : this.discoverer.discover();
            String targetTable = root.toString();
            this.tmpName = new TemporaryName(TMPPREFIX);
            result = this.flatten(root) && this.relaggs(root);
            this.println("\nRecord-Count (" + targetTable + "/" + this.getStringParameter("result_table") + "): " + this.exec.getRecordCount(targetTable, this.getStringParameter("field"), true) + "/" + this.exec.getRecordCount(this.getStringParameter("result_table"), this.getStringParameter("field"), true) + "\n");
            this.dropTables(true);
            this.conn.disconnect();
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        return result;
    }
}

