/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.util.Vector;
import proper.database.Dropper;
import proper.database.Join;
import proper.database.Joiner;
import proper.database.Modifier;
import proper.engine.DatabaseEngine;
import proper.util.ProperVector;

public class ReMilker
extends DatabaseEngine {
    public static final String PREFIX_MILK = "b_milk_";
    public static final String PREFIX_RELAGGS = "a_relaggs_";

    public ReMilker() {
        this.setParameter("result_table", "_remilk");
        this.setParameter("result_table_relaggs", "_relaggs");
        this.setParameter("result_table_milk", "_flat");
        this.setParameter("field", "train0");
        this.setParameter("bag", "train_id");
    }

    @Override
    public boolean execute() {
        super.execute();
        boolean result = true;
        try {
            Dropper dropper = new Dropper(this.getConnector());
            Joiner joiner = new Joiner(this.getConnector());
            Modifier modifier = new Modifier(this.getConnector());
            Vector joinColumns = new ProperVector();
            this.println("Dropping table...");
            dropper.drop(this.getStringParameter("result_table"));
            this.println("Performing join...");
            if (this.getStringParameter("bag").equals("")) {
                joinColumns = joiner.determineColumns(this.getStringParameter("result_table_milk"), true, this.getStringParameter("result_table_relaggs"), true);
            } else {
                joinColumns.add(new Join(this.getStringParameter("result_table_milk"), this.getStringParameter("bag"), this.getStringParameter("result_table_relaggs"), this.getStringParameter("bag")));
            }
            joiner.setJoinType(1);
            joiner.setUseForeignKeys(this.exists("use_foreign_keys"));
            result = joiner.join(this.getStringParameter("result_table_milk"), PREFIX_MILK, this.getStringParameter("result_table_relaggs"), PREFIX_RELAGGS, joinColumns, this.getStringParameter("result_table"));
            this.println("   = " + result);
            if (!result) {
                this.println(joiner.getLastException());
            }
            if (result) {
                this.println("Deleting duplicate target column...");
                result = modifier.deleteColumn(this.getStringParameter("result_table"), PREFIX_RELAGGS + this.getStringParameter("field"));
                if (this.getVerbose()) {
                    this.println("   = " + result);
                }
                if (!result) {
                    this.println(modifier.getLastException());
                }
            }
            if (result) {
                this.println("Renaming target column...");
                result = modifier.renameColumn(this.getStringParameter("result_table"), PREFIX_MILK + this.getStringParameter("field"), this.getStringParameter("field"));
                if (this.getVerbose()) {
                    this.println("   = " + result);
                }
                if (!result) {
                    this.println(modifier.getLastException());
                }
            }
            this.println("\nRecord-Count (" + this.getStringParameter("result_table_milk") + "/" + this.getStringParameter("result_table_relaggs") + "/" + this.getStringParameter("result_table") + "): " + this.exec.getRecordCount(this.getStringParameter("result_table_milk"), this.getStringParameter("field"), true) + "/" + this.exec.getRecordCount(this.getStringParameter("result_table_relaggs"), this.getStringParameter("field"), true) + "/" + this.exec.getRecordCount(this.getStringParameter("result_table"), this.getStringParameter("field"), true) + "\n");
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        return result;
    }
}

