/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import milk.classifiers.MIClassifier;
import milk.core.Exemplars;
import milk.experiment.MIClassifierSplitEvaluator;
import milk.experiment.MICrossValidationResultProducer;
import milk.experiment.MIExperiment;
import milk.experiment.MIInstancesResultListener;
import milk.experiment.MIResultListener;
import milk.experiment.MIResultProducer;
import milk.experiment.MISplitEvaluator;
import proper.engine.Engine;
import proper.engine.Milk;
import proper.util.MilkHelper;
import proper.util.Stopwatch;
import proper.util.Strings;
import weka.core.Instances;
import weka.experiment.PropertyNode;

public class MilkExperimenter
extends Engine {
    public MilkExperimenter() {
        this.setParameter("classifier", "milk.classifiers.MIWrapper");
        this.setParameter("additional", "=W weka.classifiers.trees.J48");
        this.setParameter("input", "tmp/input.arff");
        this.setParameter("output", "tmp/output.arff");
        this.setParameter("type", "cv");
        this.setParameter("runs", "10");
        this.setParameter("folds", "10");
    }

    private void printClassifier() {
        this.println("\nMI-Classifier\n=============\n");
        Milk engine = new Milk();
        this.addListener(engine);
        engine.setParameter("classifier", this.getStringParameter("classifier"));
        engine.setParameter("additional", this.getStringParameter("additional"));
        engine.setParameter("type", "output");
        engine.setParameter("train", this.getStringParameter("input"));
        engine.setParameter("folds", this.getStringParameter("folds"));
        ((Engine)engine).execute();
    }

    private int determineRuns() {
        this.print("Determining Runs... ");
        int result = new Integer(this.getStringParameter("runs"));
        if (this.getStringParameter("type") != null && this.getStringParameter("type").equals("loo")) {
            result = 1;
        }
        this.println(result);
        return result;
    }

    private int determineFolds() {
        this.print("Determining Folds... ");
        if (this.getStringParameter("type") != null && this.getStringParameter("type").equals("loo")) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.getStringParameter("input")));
                Instances inst = new Instances((Reader)reader);
                if (inst.classIndex() == -1) {
                    inst.setClassIndex(inst.numAttributes() - 1);
                }
                Exemplars exempl = new Exemplars(inst);
                this.setParameter("folds", Integer.toString(exempl.numExemplars()));
                reader.close();
            }
            catch (Exception e) {
                this.println(e);
            }
        }
        int result = new Integer(this.getStringParameter("folds"));
        this.println(result);
        return result;
    }

    @Override
    public boolean execute() {
        MIClassifier[] cArray;
        super.execute();
        int runs = this.determineRuns();
        int folds = this.determineFolds();
        this.printClassifier();
        this.println("\nMI-Experimenter\n===============\n");
        MIExperiment exp = new MIExperiment();
        exp.setPropertyArray((Object)new MIClassifier[0]);
        exp.setUsePropertyIterator(true);
        exp.setRunLower(1);
        exp.setRunUpper(runs);
        exp.setNotes("");
        exp.setAdvanceDataSetFirst(true);
        MIClassifierSplitEvaluator se = new MIClassifierSplitEvaluator();
        MIClassifier sec = se.getClassifier();
        MICrossValidationResultProducer cvrp = new MICrossValidationResultProducer();
        cvrp.setNumFolds(folds);
        cvrp.setSplitEvaluator((MISplitEvaluator)se);
        PropertyNode[] propertyPath = new PropertyNode[2];
        try {
            propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", MICrossValidationResultProducer.class), MICrossValidationResultProducer.class);
            propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
        exp.setResultProducer((MIResultProducer)cvrp);
        exp.setPropertyPath(propertyPath);
        exp.getDatasets().addElement(new File(this.getStringParameter("input")));
        try {
            cArray = new MIClassifier[]{MilkHelper.getClassifierInstance(this.getStringParameter("classifier"))};
            exp.setPropertyArray((Object)cArray);
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
        String[] adds = Strings.breakUp(this.getStringParameter("additional"));
        MilkHelper.setOptions((Object)cArray[0], adds);
        MIInstancesResultListener irl = new MIInstancesResultListener();
        irl.setOutputFile(new File(this.getStringParameter("output")));
        exp.setResultListener((MIResultListener)irl);
        this.println("\nStarting experiment...\n");
        Stopwatch watchOverall = new Stopwatch();
        watchOverall.start();
        Stopwatch watch = new Stopwatch();
        try {
            exp.initialize();
            while (exp.hasMoreIterations()) {
                watch.start();
                this.print(String.valueOf(exp.getCurrentRunNumber()) + ". " + exp.getDatasets().elementAt(exp.getCurrentDatasetNumber()) + "... ");
                exp.nextIteration();
                this.println(String.valueOf(watch.getSeconds()) + "s");
            }
            exp.postProcess();
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
        this.println("\nOverall time: " + watchOverall.getSeconds() + "s");
        this.println("\nResult can be found in: " + this.getStringParameter("output"));
        return true;
    }
}

