/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.util.Collections;
import java.util.Vector;
import proper.database.ColumnLister;
import proper.database.Dropper;
import proper.database.Join;
import proper.database.JoinComparator;
import proper.database.JoinTreeNode;
import proper.database.Joiner;
import proper.database.RelationDiscoverer;
import proper.database.Table;
import proper.database.TableLister;
import proper.engine.DatabaseEngine;
import proper.util.ProperVector;
import proper.util.TemporaryName;

public class Flattener
extends DatabaseEngine {
    public static final String TMPPREFIX = "_flattened_";
    private ColumnLister col;
    private TableLister tab;
    private Joiner join;
    private Dropper drop;
    private RelationDiscoverer discoverer;
    private JoinTreeNode root;
    private String currentTmp;
    private TemporaryName tmpName;
    private boolean showRelations;

    public Flattener() {
        this.setParameter("database", "eastwest");
        this.setParameter("table", "train_");
        this.setParameter("field", "train0");
        this.setParameter("result_table", "_flat");
        this.setParameter("join", "leftouter");
        this.setParameter("exclude_tables", "");
        this.setParameter("max_depth", "1");
        this.setParameter("instead_null", "");
        this.setParameter("tree", "");
        this.tmpName = new TemporaryName(TMPPREFIX);
        this.showRelations = true;
    }

    @Override
    protected boolean initialize() {
        boolean result;
        if (this.initialized) {
            result = true;
        } else {
            super.initialize();
            this.col = new ColumnLister(this.conn);
            this.tab = new TableLister(this.conn);
            this.join = new Joiner(this.conn);
            this.drop = new Dropper(this.conn);
            this.discoverer = new RelationDiscoverer(this.conn);
            result = true;
        }
        return result;
    }

    public void setTemporaryName(TemporaryName tmpName) {
        if (tmpName != null) {
            this.tmpName = tmpName;
        }
    }

    public TemporaryName getTemporaryName() {
        return this.tmpName;
    }

    public void setShowRelations(boolean showRelations) {
        this.showRelations = showRelations;
    }

    public boolean getShowRelations() {
        return this.showRelations;
    }

    private void dropTables(boolean onlyTemporary) {
        Vector tables = this.tab.getList("_flattened_%");
        if (!onlyTemporary) {
            tables.add(this.getStringParameter("result_table"));
        }
        this.drop.drop(tables);
    }

    private Vector orderTablesBySize(Vector tables) {
        ProperVector result = new ProperVector();
        result.addAll(tables);
        Collections.sort(result, new JoinComparator(true));
        if (this.getVerbose()) {
            this.println("Reordering: " + tables + " -> " + result);
        }
        return result;
    }

    private boolean execute(JoinTreeNode source_node, Vector joins, String result_table) {
        String source_table = source_node.isJoin() ? source_node.getJoin().getLeftTable() : source_node.getTable().getName();
        String currTmp = "";
        String prevTmp = "";
        boolean result = false;
        Vector joinCols = new Vector();
        if (joins.size() > 1) {
            joins = this.orderTablesBySize(joins);
        }
        int i = 0;
        while (i < joins.size()) {
            String table2;
            String table1;
            currTmp = this.tmpName.next();
            if (i == joins.size() - 1) {
                currTmp = result_table;
            }
            if (i == 0) {
                table1 = source_table;
                table2 = joins.get(i).toString();
            } else {
                table1 = prevTmp;
                table2 = joins.get(i).toString();
            }
            joinCols.clear();
            joinCols.add(joins.get(i));
            this.println("Joining: " + table1 + " + " + table2 + " = " + currTmp);
            result = this.join.join(table1, table2, joinCols, currTmp, this.getStringParameter("field"));
            if (source_node.isJoin()) {
                Join oldJoin = source_node.getJoin();
                source_node.getJoin().assign(new Join(currTmp, oldJoin.getLeftColumn(), oldJoin.getSize(), oldJoin.getRightTable(), oldJoin.getRightColumn()));
            } else {
                Table oldTable = source_node.getTable();
                source_node.getTable().assign(new Table(currTmp, oldTable.getSize()));
            }
            source_node.updateChildren();
            if (!prevTmp.equals("")) {
                this.drop.drop(prevTmp);
            }
            prevTmp = currTmp;
            if (!result) break;
            ++i;
        }
        return result;
    }

    private boolean execute(JoinTreeNode node) {
        boolean result = true;
        boolean ok = !node.isLeaf();
        int i = 0;
        while (i < node.getChildCount()) {
            boolean bl = ok = ok && node.getChildAt(i).isLeaf();
            if (!ok) break;
            ++i;
        }
        if (!ok) {
            i = 0;
            while (i < node.getChildCount()) {
                if (!node.getChildAt(i).isLeaf()) {
                    boolean bl = result = result && this.execute((JoinTreeNode)node.getChildAt(i));
                }
                if (!result) break;
                ++i;
            }
        }
        if (!result) {
            return result;
        }
        this.currentTmp = this.tmpName.next();
        if (node.isRoot()) {
            this.currentTmp = this.getStringParameter("result_table");
        }
        ProperVector joins = new ProperVector();
        i = 0;
        while (i < node.getChildCount()) {
            joins.add(node.getChildJoinAt(i));
            ++i;
        }
        result = this.execute(node, joins, this.currentTmp);
        while (node.getChildCount() > 0) {
            if (node.getChildAt(0).toString().startsWith(TMPPREFIX)) {
                this.drop.drop(node.getChildAt(0).toString());
            }
            node.remove(0);
        }
        if (node.isJoin()) {
            Join oldJoin = node.getJoin();
            node.getJoin().assign(new Join(this.currentTmp, oldJoin.getLeftColumn(), oldJoin.getSize(), oldJoin.getRightTable(), oldJoin.getRightColumn()));
        } else {
            Table oldTable = node.getTable();
            node.getTable().assign(new Table(this.currentTmp, oldTable.getSize()));
        }
        node.updateChildren();
        return result;
    }

    @Override
    public boolean execute() {
        boolean result;
        super.execute();
        try {
            this.col.setSort(true);
            this.join.setJoinType(Joiner.parseType(this.getStringParameter("join")));
            this.join.setInsteadOfNull(this.getStringParameter("instead_null"));
            this.join.setUseForeignKeys(this.exists("use_foreign_keys"));
            this.discoverer.setTable(this.getStringParameter("table"));
            this.discoverer.setExcludes(this.getStringParameter("exclude_tables"));
            this.discoverer.setUseForeignKeys(this.exists("use_foreign_keys"));
            this.discoverer.setMaxDepth(Integer.parseInt(this.getStringParameter("max_depth")));
            if (this.getVerbose()) {
                this.println(this.discoverer);
            }
            this.root = !this.getStringParameter("tree").equals("") ? JoinTreeNode.parseTreeString(this.getStringParameter("tree")) : this.discoverer.discover();
            String targetTable = this.root.toString();
            if (this.getShowRelations()) {
                this.println("Relations:\n");
                this.println(this.root.toString(true));
                this.println("Left over tables: " + this.discoverer.leftOverTables(this.root));
            }
            this.currentTmp = "";
            result = this.execute(this.root);
            if (this.getShowRelations()) {
                this.println("\nRecord-Count (" + targetTable + "/" + this.getStringParameter("result_table") + "): " + this.exec.getRecordCount(targetTable, this.getStringParameter("field"), true) + "/" + this.exec.getRecordCount(this.getStringParameter("result_table"), this.getStringParameter("field"), true) + "\n");
            }
            this.conn.disconnect();
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        this.println("Finished = " + result);
        return result;
    }
}

