/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import proper.database.Connector;
import proper.database.Executor;
import proper.engine.Engine;

public abstract class DatabaseEngine
extends Engine {
    protected Connector conn;
    protected Executor exec;

    public DatabaseEngine() {
        this.setParameter("driver", "org.gjt.mm.mysql.Driver");
        this.setParameter("url", "jdbc:mysql://localhost:3306/");
        this.setParameter("sql_limit", "LIMIT %ROWS%");
        this.setParameter("user", "nobody");
        this.setParameter("password", "");
    }

    protected Connector getConnector() {
        return this.conn;
    }

    protected Executor getExecutor() {
        return this.exec;
    }

    @Override
    protected boolean initialize() {
        boolean result;
        if (this.initialized) {
            result = true;
        } else {
            super.initialize();
            try {
                this.conn = new Connector();
                this.conn.connect(this.getStringParameter("driver"), this.getStringParameter("url"), this.getStringParameter("database"), this.getStringParameter("user"), this.getStringParameter("password"));
                this.conn.setLimit(this.getStringParameter("sql_limit"));
                this.addListener(this.conn);
                this.exec = new Executor(this.conn);
                result = true;
            }
            catch (Exception e) {
                this.println(e);
                result = false;
            }
        }
        return result;
    }
}

