/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import proper.database.Join;
import proper.database.Table;
import proper.util.ProperVector;

public class JoinTreeNode
extends DefaultMutableTreeNode {
    public JoinTreeNode() {
    }

    public JoinTreeNode(Join j) {
        this.setJoin(j);
    }

    public JoinTreeNode(Table t) {
        this.setTable(t);
    }

    public JoinTreeNode(String s) {
        if (this.stringIsJoin(s)) {
            this.setJoin(Join.parseString(s));
        } else {
            this.setTable(new Table(s));
        }
    }

    protected boolean stringIsJoin(String s) {
        return s.indexOf("(") > -1;
    }

    public void setJoin(Join j) {
        this.setUserObject(j);
    }

    public void setTable(Table t) {
        this.setUserObject(t);
    }

    public boolean isJoin() {
        return this.getUserObject() != null && this.getUserObject() instanceof Join;
    }

    public boolean isTable() {
        return this.getUserObject() != null && this.getUserObject() instanceof Table;
    }

    public Join getJoin() {
        if (this.isJoin()) {
            return (Join)this.getUserObject();
        }
        return null;
    }

    public Table getTable() {
        if (this.isTable()) {
            return (Table)this.getUserObject();
        }
        return null;
    }

    public Join getChildJoinAt(int index) {
        return ((JoinTreeNode)this.getChildAt(index)).getJoin();
    }

    public boolean isInPath(Join j) {
        Vector joins = this.getJoinsAlongPath();
        return joins.indexOf(j.toStringNode()) > -1;
    }

    public Vector getJoinsAlongPath() {
        ProperVector result = new ProperVector();
        JoinTreeNode node = this;
        while (node != null) {
            if (node.isJoin()) {
                result.add(node.getJoin().toStringNode());
            } else {
                result.add(node.getTable().toString());
            }
            node = (JoinTreeNode)node.getParent();
        }
        return result;
    }

    public Vector getTablesAlongPath() {
        ProperVector result = new ProperVector();
        Vector joins = this.getJoinsAlongPath();
        int i = 0;
        while (i < joins.size()) {
            Table table;
            String tmpStr = (String)joins.get(i);
            if (this.stringIsJoin(tmpStr)) {
                Join join = Join.parseString(tmpStr);
                table = new Table(join.getLeftTable(), join.getSize());
            } else {
                table = new Table(tmpStr);
            }
            if (!result.contains(table)) {
                result.add(table);
            }
            ++i;
        }
        return result;
    }

    public Vector getAllNodes() {
        ProperVector result = new ProperVector();
        Enumeration<TreeNode> enm = this.depthFirstEnumeration();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        return result;
    }

    public Vector getAllJoins() {
        ProperVector result = new ProperVector();
        Vector nodes = this.getAllNodes();
        int i = 0;
        while (i < nodes.size()) {
            JoinTreeNode anode = (JoinTreeNode)nodes.get(i);
            if (anode.isJoin()) {
                result.add(anode.getJoin().toStringNode());
            } else {
                result.add(anode.getTable().toString());
            }
            ++i;
        }
        return result;
    }

    public Vector getAllTables() {
        ProperVector result = new ProperVector();
        Vector joins = this.getAllJoins();
        int i = 0;
        while (i < joins.size()) {
            Table table;
            String tmpStr = (String)joins.get(i);
            if (this.stringIsJoin(tmpStr)) {
                Join join = Join.parseString(tmpStr);
                table = new Table(join.getLeftTable(), join.getSize());
            } else {
                table = new Table(tmpStr);
            }
            if (!result.contains(table)) {
                result.add(table);
            }
            ++i;
        }
        return result;
    }

    public void updateChildren() {
        String name = this.isJoin() ? this.getJoin().getLeftTable() : this.getTable().getName();
        int i = 0;
        while (i < this.getChildCount()) {
            JoinTreeNode node = (JoinTreeNode)this.getChildAt(i);
            if (node.isJoin()) {
                Join oldJoin = node.getJoin();
                node.getJoin().assign(new Join(oldJoin.getLeftTable(), oldJoin.getLeftColumn(), oldJoin.getSize(), name, oldJoin.getRightColumn()));
            } else {
                Table oldTable = node.getTable();
                node.getTable().assign(new Table(name, oldTable.getSize()));
            }
            ++i;
        }
    }

    private static String getNextStructure(String tree) {
        int commaPos;
        String result = "";
        int bracketPos = tree.indexOf("[");
        if (bracketPos == -1) {
            bracketPos = tree.length();
        }
        if ((commaPos = tree.indexOf(",")) == -1) {
            commaPos = tree.length();
        }
        if (commaPos < bracketPos) {
            result = tree.substring(0, commaPos);
        } else if (bracketPos < commaPos) {
            if (bracketPos > 0) {
                result = tree.substring(0, bracketPos);
            } else {
                int openCount = 0;
                int closeCount = 0;
                int i = 0;
                while (i < tree.length()) {
                    String chr = tree.substring(i, i + 1);
                    result = String.valueOf(result) + chr;
                    if (chr.equals("[")) {
                        ++openCount;
                    }
                    if (chr.equals("]")) {
                        ++closeCount;
                    }
                    if (openCount <= 0 || openCount != closeCount) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            result = tree;
        }
        return result;
    }

    private static JoinTreeNode parseTreeString(JoinTreeNode parent, String tree) {
        if (parent == null) {
            String part = JoinTreeNode.getNextStructure(tree);
            parent = new JoinTreeNode(part);
            String newTree = tree.substring(part.length() + 1, tree.length() - 1);
            JoinTreeNode.parseTreeString(parent, newTree);
        } else {
            String newTree = tree;
            while (!newTree.equals("")) {
                String part = JoinTreeNode.getNextStructure(newTree);
                if ((newTree = newTree.substring(part.length(), newTree.length())).startsWith(",")) {
                    newTree = newTree.substring(1, newTree.length());
                    if (part.equals("")) continue;
                    parent.add(new JoinTreeNode(part));
                    continue;
                }
                if (newTree.startsWith("[")) {
                    if (!part.equals("")) {
                        parent.add(new JoinTreeNode(part));
                    }
                    String tmp = JoinTreeNode.getNextStructure(newTree);
                    JoinTreeNode.parseTreeString((JoinTreeNode)parent.getChildAt(parent.getChildCount() - 1), tmp.substring(1, tmp.length() - 1));
                    newTree = newTree.substring(tmp.length(), newTree.length());
                    continue;
                }
                if (part.equals("")) continue;
                parent.add(new JoinTreeNode(part));
            }
        }
        return parent;
    }

    public static JoinTreeNode parseTreeString(String tree) {
        return JoinTreeNode.parseTreeString(null, tree.replaceAll(" ", ""));
    }

    public String toTreeString() {
        return this.toTreeString(false);
    }

    public String toTreeString(boolean full) {
        return JoinTreeNode.toTreeString(this, full);
    }

    public static String toTreeString(JoinTreeNode node) {
        return JoinTreeNode.toTreeString(node, false);
    }

    public static String toTreeString(JoinTreeNode node, boolean full) {
        StringBuffer result = new StringBuffer();
        if (full) {
            if (node.isJoin()) {
                result.append(node.getJoin().toStringNode());
            } else {
                result.append(node.getTable().toString());
            }
        } else if (node.isJoin()) {
            result.append(node.getJoin().toString());
        } else {
            result.append(node.getTable().toString());
        }
        int i = 0;
        while (i < node.getChildCount()) {
            if (i == 0) {
                result.append("[");
            }
            if (!result.toString().endsWith("[")) {
                result.append(",");
            }
            result.append(JoinTreeNode.toTreeString((JoinTreeNode)node.getChildAt(i), full));
            if (i == node.getChildCount() - 1) {
                result.append("]");
            }
            ++i;
        }
        return result.toString();
    }

    private String toString(JoinTreeNode node, String str) {
        StringBuffer tmp = new StringBuffer(str);
        int i = 0;
        while (i < node.getLevel()) {
            if (i > 0) {
                tmp.append(" ");
            }
            tmp.append("|");
            ++i;
        }
        if (node.getLevel() > 0) {
            tmp.append("-");
        }
        if (node.isJoin()) {
            tmp.append(String.valueOf(node.getJoin().toString()) + "\n");
        } else {
            tmp.append(String.valueOf(node.getTable().toString()) + "\n");
        }
        i = 0;
        while (i < node.getChildCount()) {
            tmp = new StringBuffer(this.toString((JoinTreeNode)node.getChildAt(i), tmp.toString()));
            ++i;
        }
        return tmp.toString();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean all) {
        if (all) {
            return this.toString(this, "");
        }
        if (this.isJoin()) {
            return this.getJoin().toString();
        }
        return this.getTable().toString();
    }

    public static void main(String[] args) {
        String tree = "a[b,c[d,e]]";
        JoinTreeNode node = JoinTreeNode.parseTreeString(tree);
        System.out.println("\n" + tree + ":\n" + node.toString(true));
        System.out.println(String.valueOf(tree) + "\n -> " + node.toTreeString());
        System.out.println(String.valueOf(tree) + "\n -> " + node.toTreeString(true));
        tree = "a[b(2;b.b1;a.a1),c(3;c.c1;a.a2)[d(4;d.d1;c.c2),e(5;e.e1;c.c3)]]";
        node = JoinTreeNode.parseTreeString(tree);
        System.out.println("\n" + tree + ":\n" + node.toString(true));
        System.out.println(String.valueOf(tree) + "\n -> " + node.toTreeString());
        System.out.println(String.valueOf(tree) + "\n -> " + node.toTreeString(true));
    }
}

