/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import proper.database.Column;
import proper.database.Connector;
import proper.database.ExecutorObject;
import proper.database.Lister;
import proper.util.Excluder;
import proper.util.ProperVector;

public class ColumnLister
extends ExecutorObject
implements Lister {
    private String table;
    private boolean sort;
    private Excluder excluder;
    private boolean onlyNominal;
    private boolean onlySimpleTypes;
    private boolean onlyIndexes;
    private boolean onlyPrimary;
    private boolean onlyExportedKeys;
    private boolean onlyImportedKeys;
    private boolean addTable;
    private boolean includeBlobs;

    public ColumnLister(Connector conn) {
        this(conn, "");
    }

    public ColumnLister(Connector conn, String table) {
        super(conn);
        this.table = table;
        this.clear();
    }

    @Override
    public void clear() {
        this.sort = false;
        this.onlyNominal = false;
        this.onlySimpleTypes = false;
        this.onlyIndexes = false;
        this.onlyPrimary = false;
        this.onlyExportedKeys = false;
        this.onlyImportedKeys = false;
        this.addTable = false;
        this.includeBlobs = false;
        this.excluder = new Excluder("");
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    @Override
    public void setSort(boolean sort) {
        this.sort = sort;
    }

    @Override
    public boolean getSort() {
        return this.sort;
    }

    public void setAddTable(boolean value) {
        this.addTable = value;
    }

    public boolean getAddTable() {
        return this.addTable;
    }

    public void setOnlyNominal(boolean value) {
        this.onlyNominal = value;
    }

    public boolean getOnlyNominal() {
        return this.onlyNominal;
    }

    public void setOnlySimpleTypes(boolean value) {
        this.onlySimpleTypes = value;
    }

    public boolean getOnlySimpleTypes() {
        return this.onlySimpleTypes;
    }

    public void setOnlyIndexes(boolean value) {
        this.onlyIndexes = value;
        if (this.onlyIndexes) {
            this.onlyPrimary = false;
            this.onlyExportedKeys = false;
            this.onlyImportedKeys = false;
        }
    }

    public boolean getOnlyIndexes() {
        return this.onlyIndexes;
    }

    public void setOnlyPrimary(boolean value) {
        this.onlyPrimary = value;
        if (this.onlyPrimary) {
            this.onlyIndexes = false;
            this.onlyExportedKeys = false;
            this.onlyImportedKeys = false;
        }
    }

    public boolean getOnlyPrimary() {
        return this.onlyPrimary;
    }

    public void setOnlyExportedKeys(boolean value) {
        this.onlyExportedKeys = value;
        this.setAddTable(true);
        if (this.onlyExportedKeys) {
            this.onlyPrimary = false;
            this.onlyIndexes = false;
            this.onlyImportedKeys = false;
        }
    }

    public boolean getOnlyExportedKeys() {
        return this.onlyExportedKeys;
    }

    public void setOnlyImportedKeys(boolean value) {
        this.onlyImportedKeys = value;
        this.setAddTable(true);
        if (this.onlyImportedKeys) {
            this.onlyPrimary = false;
            this.onlyIndexes = false;
            this.onlyExportedKeys = false;
        }
    }

    public boolean getOnlyImportedKeys() {
        return this.onlyImportedKeys;
    }

    public void setIncludeBlobs(boolean blobs) {
        this.includeBlobs = blobs;
    }

    public boolean getIncludeBlobs() {
        return this.includeBlobs;
    }

    public void setExcludes(Vector excludes) {
        this.excluder = new Excluder(excludes);
    }

    public void setExcludes(String excludes) {
        this.excluder = new Excluder(excludes);
    }

    private ResultSet getSet() throws Exception {
        ResultSet rs = this.getOnlyExportedKeys() ? this.conn.getConnection().getMetaData().getExportedKeys(null, null, this.getTable()) : (this.getOnlyImportedKeys() ? this.conn.getConnection().getMetaData().getImportedKeys(null, null, this.getTable()) : (this.getOnlyPrimary() ? this.conn.getConnection().getMetaData().getIndexInfo(null, null, this.getTable(), true, false) : (this.getOnlyIndexes() ? this.conn.getConnection().getMetaData().getIndexInfo(null, null, this.getTable(), false, false) : this.conn.getConnection().getMetaData().getColumns(null, null, this.getTable(), ""))));
        return rs;
    }

    @Override
    public Vector getList() {
        ProperVector result = new ProperVector();
        try {
            Column col;
            String name;
            ResultSet rs = this.getSet();
            ProperVector colList = new ProperVector();
            ProperVector tableList = new ProperVector();
            while (rs.next()) {
                String tmpName = null;
                if (this.getOnlyExportedKeys() || this.getOnlyImportedKeys()) {
                    if (this.getAddTable()) {
                        name = String.valueOf(rs.getString("PKTABLE_NAME")) + "." + rs.getString("PKCOLUMN_NAME");
                    } else {
                        tmpName = String.valueOf(rs.getString("PKTABLE_NAME")) + "." + rs.getString("PKCOLUMN_NAME");
                        name = rs.getString("PKCOLUMN_NAME");
                    }
                } else if (this.getAddTable()) {
                    name = String.valueOf(rs.getString("TABLE_NAME")) + "." + rs.getString("COLUMN_NAME");
                } else {
                    tmpName = String.valueOf(rs.getString("TABLE_NAME")) + "." + rs.getString("COLUMN_NAME");
                    name = rs.getString("COLUMN_NAME");
                }
                if (this.excluder.contains(name) || tmpName != null && this.excluder.contains(tmpName)) continue;
                col = new Column(name);
                colList.add(col);
                if (!this.getAddTable() || tableList.contains(col.getTable())) continue;
                tableList.add(col.getTable());
                Collections.sort(tableList);
            }
            rs.close();
            if (colList.size() > 0) {
                try {
                    ResultSetMetaData meta;
                    String sql = "SELECT ";
                    int i = 0;
                    while (i < colList.size()) {
                        if (i > 0) {
                            sql = String.valueOf(sql) + ", ";
                        }
                        sql = String.valueOf(sql) + ((Column)colList.get(i)).getName();
                        ++i;
                    }
                    sql = String.valueOf(sql) + " FROM ";
                    sql = this.getAddTable() ? String.valueOf(sql) + new ProperVector((Collection)tableList).toCommaList() : String.valueOf(sql) + this.getTable();
                    sql = String.valueOf(sql) + " " + this.getConnector().getLimit(1);
                    rs = this.getExecutor().select(sql);
                    if (rs != null && (meta = rs.getMetaData()) != null) {
                        i = 1;
                        while (i <= meta.getColumnCount()) {
                            String typeName;
                            int type;
                            String table;
                            try {
                                table = meta.getTableName(i);
                                if (table.equals("")) {
                                    table = ((Column)colList.get(i - 1)).getTable();
                                }
                                name = meta.getColumnName(i);
                                type = meta.getColumnType(i);
                                typeName = meta.getColumnTypeName(i);
                            }
                            catch (Exception e) {
                                table = ((Column)colList.get(i - 1)).getTable();
                                name = ((Column)colList.get(i - 1)).getName();
                                type = 1111;
                                typeName = "";
                            }
                            col = this.getAddTable() ? new Column(String.valueOf(table) + "." + name, type, typeName) : new Column(name, type, typeName);
                            if (!(result.contains(col) || this.getOnlyNominal() && !col.isNominal() && !col.isBoolean() || this.getOnlySimpleTypes() && (col.typeToString() == null || col.typeToString().equals("")) || !this.getIncludeBlobs() && col.isBlob())) {
                                result.add(col);
                            }
                            ++i;
                        }
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    this.println(e);
                    result.clear();
                }
            }
            if (this.getSort() && result.size() > 1) {
                Collections.sort(result);
            }
        }
        catch (Exception e) {
            this.println(e);
            result.clear();
        }
        if (this.getVerbose()) {
            this.println("Fields: " + result);
        }
        return result;
    }

    public Vector getColumnNamesForImportedKey(String colName) {
        ProperVector result = new ProperVector();
        try {
            Column col = new Column(colName);
            ResultSet rs = this.getSet();
            while (rs.next()) {
                if (!rs.getString("PKCOLUMN_NAME").equals(col.getName())) continue;
                result.add(new Column(String.valueOf(rs.getString("FKTABLE_NAME")) + "." + rs.getString("FKCOLUMN_NAME")));
            }
            rs.close();
        }
        catch (Exception e) {
            this.println(e);
        }
        return result;
    }

    @Override
    public String toString() {
        String result = this.conn + "\n" + "Table            : " + this.getTable() + "\n" + "Sort             : " + this.getSort() + "\n" + "only Nominal     : " + this.getOnlyNominal() + "\n" + "only Indices     : " + this.getOnlyIndexes() + "\n" + "only Primary     : " + this.getOnlyPrimary() + "\n" + "only Simple Types: " + this.getOnlySimpleTypes() + "\n" + "only imp. Keys   : " + this.getOnlyImportedKeys() + "\n" + "only exp. Keys   : " + this.getOnlyExportedKeys() + "\n" + "include Blobs    : " + this.getIncludeBlobs() + "\n" + "Excluder         : " + this.excluder;
        return result;
    }
}

