/*
 * Decompiled with CFR 0.152.
 */
package proper.cardinalization;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import proper.cardinalization.CardinalizerTable;
import proper.database.Column;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.database.ConnectorObject;
import proper.database.Join;

public class SqlEngine
extends ConnectorObject {
    private ColumnLister colLister;
    private boolean usePrimaryKey = true;
    private String excludes = null;
    public static final String INFINITY = "9999999";

    public SqlEngine(Connector conn) {
        super(conn);
        this.colLister = new ColumnLister(conn);
        this.colLister.setSort(true);
    }

    private void connect() throws Exception {
        if (!this.conn.isConnected()) {
            this.conn.connect();
        }
    }

    public void setUsePrimaryKey(boolean usePrimaryKey) {
        this.usePrimaryKey = usePrimaryKey;
    }

    public boolean getUsePrimaryKey() {
        return this.usePrimaryKey;
    }

    public void setExcludes(String stringParameter) {
        this.excludes = stringParameter;
    }

    public CardinalizerTable getTable(String tableName) {
        Column tmp;
        Object o;
        CardinalizerTable result = new CardinalizerTable(tableName);
        this.colLister.setTable(tableName);
        if (this.excludes != null) {
            this.colLister.setExcludes(this.excludes);
        }
        if (this.usePrimaryKey) {
            this.colLister.setOnlyPrimary(this.usePrimaryKey);
        } else {
            this.colLister.setOnlyIndexes(!this.usePrimaryKey);
        }
        Vector columns = this.colLister.getList();
        int i = 0;
        while (i < columns.size()) {
            o = columns.get(i);
            if (o instanceof Column) {
                tmp = (Column)o;
                result.addColumn(tmp, true);
            }
            ++i;
        }
        this.colLister.setOnlyPrimary(false);
        this.colLister.setOnlyIndexes(false);
        columns = this.colLister.getList();
        i = 0;
        while (i < columns.size()) {
            o = columns.get(i);
            if (o instanceof Column) {
                tmp = (Column)o;
                result.addColumn(tmp);
            }
            ++i;
        }
        return result;
    }

    public void sqlCopyColumnValues(CardinalizerTable source, CardinalizerTable destination, String columnName) {
        String copySql = "INSERT INTO " + destination.getName() + "(" + columnName + ") SELECT " + columnName + " FROM " + source.getName() + ";";
        try {
            if (source.getColumn(columnName).getType() != destination.getColumn(columnName).getType()) {
                throw new Exception("Error: duplicated columns are not of the same type.");
            }
            this.connect();
            Statement copyStatement = this.conn.getConnection().createStatement(1004, 1008);
            copyStatement.executeUpdate(copySql);
            copyStatement.close();
        }
        catch (SQLException sqlE) {
            System.err.println("SQL error in Cardinalizer.SqlEngine.sqlCopyColumnValues : ");
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlCopyColumnValues :");
            e.printStackTrace();
        }
    }

    public CardinalizerTable sqlCreateAsSelect(Vector<CardinalizerTable> tables, String name) {
        CardinalizerTable result;
        if (tables.size() > 0) {
            result = new CardinalizerTable(name);
            CardinalizerTable joinTbl = tables.get(0);
            Column joinCol = joinTbl.getJoinColumn();
            String insertSql = "INSERT INTO " + name + "(";
            String selectSql = " SELECT ";
            String fromSql = " FROM " + tables.get(0).getName();
            int i = 0;
            while (i < tables.size()) {
                CardinalizerTable tmpTable = tables.get(i);
                int j = 0;
                while (j < tmpTable.columnCount()) {
                    Column tmpCol = tmpTable.getColumn(j);
                    if (!tmpCol.equals(joinCol) || i == 0) {
                        if (i != 0 || j != 0) {
                            insertSql = String.valueOf(insertSql) + ", ";
                            selectSql = String.valueOf(selectSql) + ", ";
                        }
                        result.addColumn(tmpCol, tmpCol.equals(tmpTable.getJoinColumn()) && i == 0);
                        insertSql = String.valueOf(insertSql) + tmpCol.getName();
                        selectSql = String.valueOf(selectSql) + tmpTable.getName() + "." + tmpCol.getName();
                    }
                    ++j;
                }
                if (i != 0) {
                    fromSql = String.valueOf(fromSql) + " JOIN " + tmpTable.getName() + " on " + joinTbl.getName() + "." + joinCol.getName() + " = " + tmpTable.getName() + "." + joinCol.getName();
                }
                ++i;
            }
            insertSql = String.valueOf(insertSql) + ")" + selectSql + fromSql;
            this.sqlCreateTable(result);
            try {
                this.connect();
                Statement copyStatement = this.conn.getConnection().createStatement(1004, 1008);
                copyStatement.executeUpdate(insertSql);
                copyStatement.close();
            }
            catch (SQLException sqlE) {
                System.err.println("SQL error in Cardinalizer.SqlEngine.sqlCreateAsSelect : ");
                sqlE.printStackTrace();
            }
            catch (Exception e) {
                System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlCreateAsSelect :");
                e.printStackTrace();
            }
        } else {
            result = null;
        }
        return result;
    }

    public void sqlCopyTableValues(CardinalizerTable source, CardinalizerTable destination) {
        Column tmpCol;
        String copySql = "INSERT INTO " + destination.getName() + " (";
        int i = 0;
        while (i < source.columnCount()) {
            if (i != 0) {
                copySql = String.valueOf(copySql) + ", ";
            }
            tmpCol = source.getColumn(i);
            copySql = String.valueOf(copySql) + tmpCol.getName();
            ++i;
        }
        copySql = String.valueOf(copySql) + ") SELECT ";
        i = 0;
        while (i < source.columnCount()) {
            if (i != 0) {
                copySql = String.valueOf(copySql) + ", ";
            }
            tmpCol = source.getColumn(i);
            copySql = String.valueOf(copySql) + tmpCol.getName();
            ++i;
        }
        copySql = String.valueOf(copySql) + " FROM " + source.getName() + ";";
        try {
            this.connect();
            Statement copyStatement = this.conn.getConnection().createStatement(1004, 1008);
            copyStatement.executeUpdate(copySql);
            copyStatement.close();
        }
        catch (SQLException sqlE) {
            System.err.println("SQL error in Cardinalizer.SqlEngine.sqlCopyTableValues : ");
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlCopyTableValues :");
            e.printStackTrace();
        }
    }

    public void sqlCreateTable(CardinalizerTable table) {
        ArrayList<String> indexSql = new ArrayList<String>();
        String createSql = "CREATE TABLE " + table.getName() + "(";
        int i = 0;
        while (i < table.columnCount()) {
            if (i != 0) {
                createSql = String.valueOf(createSql) + ", ";
            }
            Column tmpCol = table.getColumn(i);
            createSql = String.valueOf(createSql) + tmpCol.getName() + " " + tmpCol.typeToString();
            if (table.isJoinColumn(tmpCol)) {
                indexSql.add("CREATE INDEX ind_" + table.getName() + "_" + tmpCol.getName() + " ON " + table.getName() + "(" + tmpCol.getName() + ");");
            }
            ++i;
        }
        createSql = String.valueOf(createSql) + ");";
        try {
            this.connect();
            Statement createStatement = this.conn.getConnection().createStatement(1004, 1008);
            createStatement.executeUpdate(createSql);
            createStatement.close();
            Statement indexStatement = this.conn.getConnection().createStatement(1004, 1008);
            i = 0;
            while (i < indexSql.size()) {
                indexStatement.executeUpdate((String)indexSql.get(i));
                ++i;
            }
            indexStatement.close();
        }
        catch (SQLException sqlE) {
            System.err.println("SQL error in Cardinalizer.SqlEngine.sqlCreateTable : ");
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlCreateTable :");
            e.printStackTrace();
        }
    }

    public boolean cardinalize(CardinalizerTable mainTable, CardinalizerTable aggrTable, CardinalizerTable cardzTable, Join join, boolean discretize, int discretizeParts, int nbThresEqFreq) {
        boolean result = true;
        String selectIdSql = "SELECT " + cardzTable.getJoinColumn().getName() + " as cardzId FROM " + cardzTable.getName() + " GROUP BY cardzId;";
        String quote = "";
        int countId = 0;
        int totalId = this.sqlCountInstance(mainTable);
        if (cardzTable.getJoinColumn().isNominal()) {
            quote = "'";
        }
        try {
            this.connect();
            Statement selectIdStatement = this.conn.getConnection().createStatement(1004, 1008);
            Statement selectMinStatement = this.conn.getConnection().createStatement(1004, 1008);
            Statement updateStatement = this.conn.getConnection().createStatement(1004, 1008);
            Set<Integer> thresEqFreqList = null;
            if (nbThresEqFreq != -1) {
                thresEqFreqList = this.sqlCountInstance(mainTable, aggrTable, join, 10);
            }
            ResultSet selectIdSet = selectIdStatement.executeQuery(selectIdSql);
            while (selectIdSet.next()) {
                String currId = selectIdSet.getString("cardzId");
                ++countId;
                int i = 0;
                while (i < aggrTable.columnCount()) {
                    Column tmpCol = aggrTable.getColumn(i);
                    if (tmpCol.isNumerical() && !tmpCol.equals(aggrTable.getJoinColumn()) && !tmpCol.equals(mainTable.getJoinColumn()) && !tmpCol.getName().contains("id")) {
                        String columnName;
                        int j;
                        double minValue;
                        String updateSql;
                        int maxColumnCount;
                        ResultSet selectMinSet;
                        String selectMinSql;
                        if (discretize) {
                            int p;
                            selectMinSql = "SELECT aggr." + tmpCol.getName() + " AS minimum, aggr." + aggrTable.getJoinColumn().getName() + " AS aggr_id, main." + mainTable.getJoinColumn().getName() + " AS main_id FROM " + aggrTable.getName() + " aggr JOIN " + mainTable.getName() + " main ON aggr." + join.getLeftColumn() + " = main." + join.getRightColumn() + " WHERE main." + mainTable.getJoinColumn().getName() + "=" + quote + currId + quote + " ORDER BY minimum;";
                            selectMinSet = selectMinStatement.executeQuery(selectMinSql);
                            selectMinSet.last();
                            double idColumnCount = selectMinSet.getRow();
                            selectMinSet.first();
                            maxColumnCount = discretizeParts == -1 ? this.sqlCountAvgInstance(mainTable, aggrTable, join) : discretizeParts;
                            updateSql = "";
                            if (idColumnCount > 0.0) {
                                double xi;
                                double xiplus1;
                                int index;
                                if (idColumnCount == 1.0) {
                                    index = 1;
                                    xi = xiplus1 = (minValue = selectMinSet.getDouble("minimum"));
                                } else {
                                    index = 0;
                                    xi = xiplus1 = selectMinSet.getDouble("minimum");
                                    minValue = xiplus1;
                                }
                                p = 1;
                                while (p < maxColumnCount) {
                                    j = (int)Math.floor((double)p * idColumnCount / (double)maxColumnCount);
                                    double g = 1.0 * (double)p * idColumnCount / (double)maxColumnCount - (double)j;
                                    while (index < j) {
                                        selectMinSet.next();
                                        xi = xiplus1;
                                        xiplus1 = selectMinSet.getDouble("minimum");
                                        ++index;
                                    }
                                    if (idColumnCount > 1.0) {
                                        minValue = g == 0.0 ? xi : xiplus1;
                                    }
                                    columnName = String.valueOf(aggrTable.getName()) + "_min_" + p + "_" + maxColumnCount + "_" + tmpCol.getName();
                                    if (updateSql != "") {
                                        updateSql = String.valueOf(updateSql) + ", ";
                                    }
                                    updateSql = String.valueOf(updateSql) + columnName + "=" + minValue;
                                    ++p;
                                }
                            } else {
                                p = 1;
                                while (p < maxColumnCount) {
                                    columnName = String.valueOf(aggrTable.getName()) + "_min_" + p + "_" + maxColumnCount + "_" + tmpCol.getName();
                                    if (updateSql != "") {
                                        updateSql = String.valueOf(updateSql) + ", ";
                                    }
                                    updateSql = String.valueOf(updateSql) + columnName + "=" + INFINITY;
                                    ++p;
                                }
                            }
                            updateSql = "UPDATE " + cardzTable.getName() + " SET " + updateSql + " WHERE " + cardzTable.getJoinColumn().getName() + "=" + quote + currId + quote + ";";
                            updateStatement.executeUpdate(updateSql);
                            selectMinSet.close();
                        } else {
                            maxColumnCount = this.sqlCountMaxInstance(mainTable, aggrTable, join);
                            selectMinSql = "SELECT aggr." + tmpCol.getName() + " AS minimum, aggr." + aggrTable.getJoinColumn().getName() + " AS aggr_id, main." + mainTable.getJoinColumn().getName() + " AS main_id FROM " + aggrTable.getName() + " aggr JOIN " + mainTable.getName() + " main ON aggr." + join.getLeftColumn() + " = main." + join.getRightColumn() + " WHERE main." + mainTable.getJoinColumn().getName() + "=" + quote + currId + quote + " ORDER BY minimum;";
                            selectMinSet = selectMinStatement.executeQuery(selectMinSql);
                            updateSql = "";
                            j = 1;
                            while (selectMinSet.next()) {
                                if (nbThresEqFreq == -1 || thresEqFreqList.contains(j)) {
                                    minValue = selectMinSet.getDouble("minimum");
                                    columnName = String.valueOf(aggrTable.getName()) + "_min_" + j + "_" + tmpCol.getName();
                                    if (updateSql != "") {
                                        updateSql = String.valueOf(updateSql) + ", ";
                                    }
                                    updateSql = String.valueOf(updateSql) + columnName + "=" + minValue;
                                }
                                ++j;
                            }
                            selectMinSet.close();
                            while (j <= maxColumnCount) {
                                if (nbThresEqFreq == -1 || thresEqFreqList.contains(j)) {
                                    columnName = String.valueOf(aggrTable.getName()) + "_min_" + j + "_" + tmpCol.getName();
                                    if (updateSql != "") {
                                        updateSql = String.valueOf(updateSql) + ", ";
                                    }
                                    updateSql = String.valueOf(updateSql) + columnName + "=" + INFINITY;
                                }
                                ++j;
                            }
                            updateSql = "UPDATE " + cardzTable.getName() + " SET " + updateSql + " WHERE " + cardzTable.getJoinColumn().getName() + "=" + quote + currId + quote + ";";
                            updateStatement.executeUpdate(updateSql);
                        }
                    }
                    ++i;
                }
                if (countId % 50 != 0 && countId != totalId) continue;
                this.println(String.valueOf(countId) + "/" + totalId + " rows");
            }
            updateStatement.close();
            selectMinStatement.close();
            selectIdSet.close();
            selectIdStatement.close();
        }
        catch (SQLException sqlE) {
            result = false;
            System.err.println("SQL error in Cardinalizer.SqlEngine.cardinalize : ");
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            result = false;
            System.err.println("Unknown error in Cardinalizer.SqlEngine.cardinalize :");
            e.printStackTrace();
        }
        return result;
    }

    public int sqlCountJoinedInstance(CardinalizerTable mainTable, CardinalizerTable aggrTable, Join join, Object currentMainPkValue) {
        int result = 0;
        String countSql = "SELECT COUNT(aggr." + aggrTable.getJoinColumn().getName() + ") AS counted FROM " + aggrTable.getName() + " aggr JOIN " + mainTable + " main ON aggr." + join.getLeftColumn() + "= main." + join.getRightColumn() + " WHERE main." + mainTable.getJoinColumn() + "= '" + currentMainPkValue + "'";
        try {
            this.connect();
            Statement countStatement = this.conn.getConnection().createStatement(1004, 1008);
            ResultSet countResult = countStatement.executeQuery(countSql);
            while (countResult.next()) {
                result = countResult.getInt("counted");
            }
            countResult.close();
            countStatement.close();
        }
        catch (SQLException sqlE) {
            System.err.println("SQL error in Cardinalizer.SqlEngine.sqlCountJoinedInstance : ");
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlCountJoinedInstance :");
            e.printStackTrace();
        }
        return result;
    }

    public int sqlCountMaxInstance(CardinalizerTable mainTable, CardinalizerTable aggrTable, Join join) {
        int result = 0;
        String countSql = "SELECT MAX(counted) as maximum FROM (SELECT COUNT(" + aggrTable.getJoinColumn().getName() + ") AS counted FROM " + aggrTable.getName() + " GROUP BY " + join.getLeftColumn() + ")counting";
        try {
            this.connect();
            Statement countStatement = this.conn.getConnection().createStatement(1004, 1008);
            ResultSet countResult = countStatement.executeQuery(countSql);
            while (countResult.next()) {
                result = countResult.getInt("maximum");
            }
            countResult.close();
            countStatement.close();
        }
        catch (SQLException sqlE) {
            System.err.println("SQL error in Cardinalizer.SqlEngine.sqlCountMaxInstance : ");
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlCountMaxInstance :");
            e.printStackTrace();
        }
        return result;
    }

    public Set<Integer> sqlCountInstance(CardinalizerTable mainTable, CardinalizerTable aggrTable, Join join, int numThreshs) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String countSql = "SELECT COUNT(" + aggrTable.getJoinColumn().getName() + ") AS counted FROM " + aggrTable.getName() + " GROUP BY " + join.getLeftColumn();
        try {
            this.connect();
            Statement countStatement = this.conn.getConnection().createStatement(1004, 1008);
            ResultSet countResult = countStatement.executeQuery(countSql);
            while (countResult.next()) {
                result.add(countResult.getInt("counted"));
            }
            countResult.close();
            countStatement.close();
        }
        catch (SQLException sqlE) {
            System.err.println("SQL error in Cardinalizer.SqlEngine.sqlCountMaxInstance : ");
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlCountMaxInstance :");
            e.printStackTrace();
        }
        return SqlEngine.discretizeCardinalities(result, numThreshs);
    }

    public static Set<Integer> discretizeCardinalities(List<Integer> allCardinalitiesNTimes, int numThreshs) {
        long sumCardValue = 0L;
        int remainingCardCounts = allCardinalitiesNTimes.size();
        TreeMap<Integer, Integer> CardCountsMap = new TreeMap<Integer, Integer>();
        int previousCardCount = 0;
        for (Integer currCardValue : allCardinalitiesNTimes) {
            sumCardValue += (long)currCardValue.intValue();
            previousCardCount = CardCountsMap.containsKey(currCardValue) ? (Integer)CardCountsMap.get(currCardValue) : 0;
            CardCountsMap.put(currCardValue, previousCardCount + 1);
        }
        TreeSet<Integer> thresholdList = new TreeSet<Integer>();
        int currCardValue = 0;
        int currCardCount = 0;
        int currThreshold = 0;
        long currSumCardCounts = 0L;
        for (Map.Entry ent : CardCountsMap.entrySet()) {
            currCardValue = (Integer)ent.getKey();
            currCardCount = (Integer)ent.getValue();
            while (currThreshold < currCardValue) {
                ++currThreshold;
                if ((currSumCardCounts += (long)remainingCardCounts) >= sumCardValue * (long)(thresholdList.size() + 1) / (long)(numThreshs + 1)) {
                    thresholdList.add(currThreshold);
                }
                if (thresholdList.size() >= numThreshs) break;
            }
            if (thresholdList.size() >= numThreshs) break;
            remainingCardCounts -= currCardCount;
        }
        return thresholdList;
    }

    public int sqlCountAvgInstance(CardinalizerTable mainTable, CardinalizerTable aggrTable, Join join) {
        int result = 0;
        String countSql = "SELECT FLOOR(AVG(counted)) as average FROM (SELECT COUNT(" + aggrTable.getJoinColumn().getName() + ") AS counted FROM " + aggrTable.getName() + " GROUP BY " + join.getLeftColumn() + ")counting";
        try {
            this.connect();
            Statement countStatement = this.conn.getConnection().createStatement(1004, 1008);
            ResultSet countResult = countStatement.executeQuery(countSql);
            while (countResult.next()) {
                result = countResult.getInt("average");
            }
            countResult.close();
            countStatement.close();
        }
        catch (SQLException sqlE) {
            System.err.println("SQL error in Cardinalizer.SqlEngine.sqlCountAvgInstance : ");
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlCountAvgInstance :");
            e.printStackTrace();
        }
        return result;
    }

    public int sqlCountInstance(CardinalizerTable table) {
        int result = 0;
        String countSql = "SELECT COUNT(" + table.getJoinColumn().getName() + ") as counted FROM " + table.getName() + ";";
        try {
            this.connect();
            Statement countStatement = this.conn.getConnection().createStatement(1004, 1008);
            ResultSet countResult = countStatement.executeQuery(countSql);
            while (countResult.next()) {
                result = countResult.getInt("counted");
            }
            countResult.close();
            countStatement.close();
        }
        catch (SQLException sqlE) {
            System.err.println("SQL error in Cardinalizer.SqlEngine.sqlCountInstance : ");
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlCountInstance :");
            e.printStackTrace();
        }
        return result;
    }

    public Vector<String> sqlGetNominalValues(String tableName, Column column) {
        Vector<String> result = null;
        if (column.isNominal()) {
            result = new Vector<String>();
            String selectSql = "SELECT " + column.getName() + "as value FROM " + tableName;
            try {
                this.connect();
                Statement selectStatement = this.conn.getConnection().createStatement(1004, 1008);
                ResultSet selectSet = selectStatement.executeQuery(selectSql);
                while (selectSet.next()) {
                    result.add(selectSet.getString("value"));
                }
                selectSet.close();
                selectStatement.close();
            }
            catch (SQLException sqlE) {
                System.err.println("SQL error in Cardinalizer.SqlEngine.sqlGetNominalValues : ");
                sqlE.printStackTrace();
            }
            catch (Exception e) {
                System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlGetNominalValues :");
                e.printStackTrace();
            }
        }
        return result;
    }

    public int sqlCountNominalValue(String tableName, Column column, String value) {
        int result = 0;
        if (column.isNominal()) {
            String countSql = "SELECT COUNT(" + column.getName() + ") as counted FROM " + tableName + " WHERE " + column.getName() + "='" + value + "';";
            try {
                this.connect();
                Statement countStatement = this.conn.getConnection().createStatement(1004, 1008);
                ResultSet countSet = countStatement.executeQuery(countSql);
                while (countSet.next()) {
                    result = countSet.getInt("value");
                }
                countSet.close();
                countStatement.close();
            }
            catch (SQLException sqlE) {
                System.err.println("SQL error in Cardinalizer.SqlEngine.sqlCountNominalValue : ");
                sqlE.printStackTrace();
            }
            catch (Exception e) {
                System.err.println("Unknown error in Cardinalizer.SqlEngine.sqlCountNominalValue :");
                e.printStackTrace();
            }
        }
        return result;
    }

    public void cardinalizeGeo(CardinalizerTable mainTable, CardinalizerTable aggrTable, CardinalizerTable cardzTable, Join join, boolean discretize, int discretizeParts) {
        String selectIdSql = "SELECT " + cardzTable.getJoinColumn().getName() + " as cardzId FROM " + cardzTable.getName() + ";";
        int countId = 0;
        int totalId = this.sqlCountInstance(mainTable);
        try {
            this.connect();
            Statement selectIdStatement = this.conn.getConnection().createStatement(1004, 1008);
            Statement selectMinStatement = this.conn.getConnection().createStatement(1004, 1008);
            Statement updateStatement = this.conn.getConnection().createStatement(1004, 1008);
            ResultSet selectIdSet = selectIdStatement.executeQuery(selectIdSql);
            while (selectIdSet.next()) {
                int currId = selectIdSet.getInt("cardzId");
                ++countId;
                int i = 0;
                while (i < aggrTable.columnCount()) {
                    Column tmpCol = aggrTable.getColumn(i);
                    if (!(tmpCol.equals(aggrTable.getJoinColumn()) || tmpCol.equals(mainTable.getJoinColumn()) || tmpCol.getName().contains("id"))) {
                        if (tmpCol.isNumerical()) {
                            String updateSql;
                            String columnName;
                            Object minValue;
                            int j;
                            ResultSet selectMinSet;
                            String selectMinSql;
                            double maxColumnCount;
                            if (discretize) {
                                double idColumnCount = this.sqlCountJoinedInstance(mainTable, aggrTable, join, currId);
                                maxColumnCount = discretizeParts == -1 ? (double)this.sqlCountAvgInstance(mainTable, aggrTable, join) : (double)discretizeParts;
                                double columnMult = idColumnCount / maxColumnCount;
                                selectMinSql = "SELECT MIN(aggr." + tmpCol.getName() + ") AS minimum, aggr." + aggrTable.getJoinColumn().getName() + " AS aggr_id, main." + mainTable.getJoinColumn().getName() + " AS main_id FROM " + aggrTable.getName() + " aggr JOIN " + mainTable.getName() + " main ON aggr." + join.getLeftColumn() + " = main." + join.getRightColumn() + " WHERE main." + mainTable.getJoinColumn().getName() + "=" + currId + " GROUP BY aggr_id, main_id ORDER BY minimum;";
                                selectMinSet = selectMinStatement.executeQuery(selectMinSql);
                                j = 1;
                                while (selectMinSet.next()) {
                                    int c = 0;
                                    while ((double)c < maxColumnCount) {
                                        if ((double)j == Math.ceil(columnMult * (double)c) || j == 1 && c == 0) {
                                            minValue = selectMinSet.getObject("minimum");
                                            columnName = String.valueOf(aggrTable.getName()) + "_min_" + (c + 1) + "_" + tmpCol.getName();
                                            updateSql = "UPDATE " + cardzTable.getName() + " SET " + columnName + "=" + minValue + " WHERE " + cardzTable.getJoinColumn().getName() + "=" + currId + ";";
                                            updateStatement.executeUpdate(updateSql);
                                        }
                                        ++c;
                                    }
                                    ++j;
                                }
                                selectMinSet.close();
                            } else {
                                maxColumnCount = this.sqlCountMaxInstance(mainTable, aggrTable, join);
                                selectMinSql = "SELECT MIN(aggr." + tmpCol.getName() + ") AS minimum, aggr." + aggrTable.getJoinColumn().getName() + " AS aggr_id, main." + mainTable.getJoinColumn().getName() + " AS main_id FROM " + aggrTable.getName() + " aggr JOIN " + mainTable.getName() + " main ON aggr." + join.getLeftColumn() + " = main." + join.getRightColumn() + " WHERE main." + mainTable.getJoinColumn().getName() + "=" + currId + " GROUP BY aggr_id, main_id ORDER BY minimum;";
                                selectMinSet = selectMinStatement.executeQuery(selectMinSql);
                                j = 1;
                                while (selectMinSet.next()) {
                                    minValue = selectMinSet.getObject("minimum");
                                    columnName = String.valueOf(aggrTable.getName()) + "_min_" + j + "_" + tmpCol.getName();
                                    updateSql = "UPDATE " + cardzTable.getName() + " SET " + columnName + "=" + minValue + " WHERE " + cardzTable.getJoinColumn().getName() + "=" + currId + ";";
                                    updateStatement.executeUpdate(updateSql);
                                    ++j;
                                }
                                selectMinSet.close();
                                while ((double)j <= maxColumnCount) {
                                    columnName = String.valueOf(aggrTable.getName()) + "_min_" + j + "_" + tmpCol.getName();
                                    updateSql = "UPDATE " + cardzTable.getName() + " SET " + columnName + "=" + INFINITY + " WHERE " + cardzTable.getJoinColumn().getName() + "=" + currId + ";";
                                    updateStatement.executeUpdate(updateSql);
                                    ++j;
                                }
                            }
                        } else {
                            tmpCol.isNominal();
                        }
                    }
                    ++i;
                }
                if (countId % 50 != 0 && countId != totalId) continue;
                this.println(String.valueOf(countId) + "/" + totalId + " rows");
            }
            updateStatement.close();
            selectMinStatement.close();
            selectIdSet.close();
            selectIdStatement.close();
        }
        catch (SQLException sqlE) {
            System.err.println("SQL error in Cardinalizer.SqlEngine.cardinalize : ");
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Unknown error in Cardinalizer.SqlEngine.cardinalize :");
            e.printStackTrace();
        }
    }
}

