/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import proper.app.DatabaseApplication;
import proper.engine.Engine;
import proper.engine.Propagator;

public class Propagation
extends DatabaseApplication {
    private int maxDepth;
    private String joinType;

    @Override
    protected void defaultParameters() {
        super.defaultParameters();
        this.joinType = "leftouter";
        this.maxDepth = 1;
    }

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("table", "the table to use as central table for flattening", true, "<name>", false);
        this.addDefinition("field", "the class field in the central table", true, "<name>", false);
        this.addDefinition("exclude_tables", "tables you want to exclude from the flattening process", true, "<name[,name...]>", true);
        this.addDefinition("join", "the type of join to perform, available are 'leftouter', 'rightouter'\n'bestouter' (determines the outer join with the least information loss) or\n'natural'\ndefault is: " + this.joinType, true, "<type>", true);
        this.addDefinition("max_depth", "defines the maximal depth the search for relations does, -1 means unlimited\ndefault is: " + this.maxDepth, true, "<int>", true);
        this.addDefinition("use_foreign_keys", "uses foreign key relations to determine relations between tables rather \nthan matching column names", false, "", true);
        this.addDefinition("tree", "instead of discovering the structure of the DB itself a tree structure can\nbe defined by the user. It starts with the root node, the children are\nseparated by ',' and a substree is surrounded by '[' and ']', e.g.:\na[b,c,d[e,f[g,h]]", true, "<tree-string>", true);
    }

    @Override
    public void printDescription() {
        System.out.println("Propagates the keys to outlying tables, i.e. it creates a star scheme out of");
        System.out.println("tree structure.");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        this.println("\nPropagation\n===========\n");
        Propagator engine = new Propagator();
        this.initEngine(engine);
        engine.setParameter("table", this.cl.getValue("table"));
        engine.setParameter("field", this.cl.getValue("field"));
        engine.setParameter("join", this.cl.getValue("join", this.joinType));
        engine.setParameter("exclude_tables", this.cl.getValue("exclude_tables"));
        engine.setParameter("max_depth", this.fixAdditionalArg(this.cl.getValue("max_depth", Integer.toString(this.maxDepth))));
        engine.setParameter("tree", this.cl.getValue("tree"));
        if (this.cl.exists("use_foreign_keys")) {
            engine.setParameter("use_foreign_keys", "yes");
        }
        return ((Engine)engine).execute();
    }

    public static void main(String[] args) throws Exception {
        Propagation app = new Propagation();
        app.run(args);
    }
}

