/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import proper.app.DatabaseApplication;
import proper.database.Connector;
import proper.database.Dropper;
import proper.database.Joiner;

public class JOIN
extends DatabaseApplication {
    private String joinType;

    @Override
    protected void defaultParameters() {
        super.defaultParameters();
        this.joinType = "leftouter";
    }

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("target_table", "The table that contains the target attribute.", true, "<name>", false);
        this.addDefinition("joined_table", "The table that will be joined to the target table.", true, "<name>", false);
        this.addDefinition("result_table", "the table to stores the cardinalized data in", true, "<name>", false);
        this.addDefinition("use_foreign_keys", "uses foreign key relations to determine relations between tables rather \nthan matching column names", false, "", true);
        this.addDefinition("join", "the type of join to perform, available are 'leftouter', 'rightouter'\n'bestouter' (determines the outer join with the least information loss) or\n'natural'\ndefault is: " + this.joinType, true, "<type>", true);
        this.addDefinition("instead_null", "defines the values for columns (type is determined automatically) which is\nused instead of NULL values after a Join.", true, "col=value[,col=value[,...]]", true);
    }

    @Override
    public void printDescription() {
        System.out.println("");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        Connector conn = new Connector();
        this.println("\nJoining\n==========");
        conn.connect(this.cl.getValue("driver"), this.cl.getValue("url"), this.cl.getValue("database"), this.cl.getValue("user"), this.cl.getValue("password"));
        conn.setLimit(this.cl.getValue("sql_limit"));
        Joiner join = new Joiner(conn);
        if (this.cl.exists("use_foreign_keys")) {
            join.setUseForeignKeys(true);
        }
        join.setInsteadOfNull(this.cl.getValue("instead_null"));
        join.setJoinType(Joiner.parseType(this.cl.getValue("join", this.joinType)));
        Dropper dropper = new Dropper(conn);
        if (this.cl.getValue("result_table").startsWith("_")) {
            dropper.drop(this.cl.getValue("result_table"));
        }
        return join.join(this.cl.getValue("target_table"), this.cl.getValue("joined_table"), this.cl.getValue("result_table"));
    }

    public static void main(String[] args) throws Exception {
        JOIN app = new JOIN();
        app.run(args);
    }
}

