/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import proper.app.Application;
import proper.io.TextFile;
import proper.util.Cells;
import proper.util.Includer;
import proper.util.ProperVector;
import proper.util.Set;
import proper.util.Strings;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class ArffComparer
extends Application {
    private Hashtable instances = new Hashtable();
    private Hashtable filetypes = new Hashtable();
    private Hashtable filenames = new Hashtable();
    private Hashtable leftovers = new Hashtable();
    private Vector attFile1 = new ProperVector();
    private Vector attFile2 = new ProperVector();
    private Hashtable attCommon = new Hashtable();

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("file0", "the first ARFF file", true, "<name>", false);
        this.addDefinition("file0_type", "the type of the file, currently 'milk' and 'relaggs' are supported", true, "<type>", false);
        this.addDefinition("attribute0", "comma separated list of attribute names to use instead of all", true, "name[,name[,...]]", true);
        this.addDefinition("file1", "the second ARFF file", true, "<name>", false);
        this.addDefinition("file1_type", "see '-file1_type'", true, "<type>", false);
        this.addDefinition("attribute1", "comma separated list of attribute names to use instead of all", true, "name[,name[,...]]", true);
        this.addDefinition("denote_equal", "", false, "indicates with '[equal]' that both values are the same", true);
        this.addDefinition("denote_missing", "", false, "indicates with '[missing]' that both values are missing", true);
        this.addDefinition("output", "if an output file is specified the result is printed to this file in CSV", true, "<name>", true);
    }

    @Override
    public void printDescription() {
        System.out.println("Compares two ARFF files and outputs the difference in attributes and in common");
        System.out.println("attributes the different instances.");
        System.out.println("A prerequisite is that both files have the number of instances.");
        System.out.println();
    }

    private boolean loadFiles() {
        this.print("Loading files... ");
        boolean result = false;
        try {
            String name = this.cl.getValue("file0");
            String type = this.cl.getValue("file0_type");
            BufferedReader reader = new BufferedReader(new FileReader(name));
            Instances inst = new Instances((Reader)reader);
            reader.close();
            this.instances.put("0", inst);
            this.filetypes.put("0", type);
            this.filenames.put("0", name);
            name = this.cl.getValue("file1");
            type = this.cl.getValue("file1_type");
            reader = new BufferedReader(new FileReader(name));
            inst = new Instances((Reader)reader);
            reader.close();
            this.instances.put("1", inst);
            this.filetypes.put("1", type);
            this.filenames.put("1", name);
            if (this.cl.getValue("file0_type").equals("milk") && this.cl.getValue("file1_type").equals("relaggs")) {
                inst = (Instances)this.instances.get("0");
                this.instances.put("0", this.instances.get("1"));
                this.instances.put("1", inst);
                type = (String)this.filetypes.get("0");
                this.filetypes.put("0", this.filetypes.get("1"));
                this.filetypes.put("1", type);
                name = (String)this.filenames.get("0");
                this.filenames.put("0", this.filenames.get("1"));
                this.filenames.put("1", name);
            }
            result = true;
            this.println(result);
        }
        catch (Exception e) {
            this.println(result);
            this.println(e);
            result = false;
        }
        return result;
    }

    private Vector getNames(String id) {
        Vector result = new ProperVector();
        if (this.cl.exists("attribute" + id)) {
            result = Strings.fromCommalistVector(this.cl.getValue("attribute" + id));
        } else {
            Instances inst = (Instances)this.instances.get(id);
            if (inst != null) {
                int i = 0;
                while (i < inst.numAttributes()) {
                    result.add(inst.attribute(i).name());
                    ++i;
                }
            }
        }
        return result;
    }

    private int getInstanceCount(String id) {
        if (this.instances.containsKey(id)) {
            return ((Instances)this.instances.get(id)).numInstances();
        }
        return -1;
    }

    private boolean checkInstanceCount() {
        this.print("\nChecking instance count... ");
        boolean result = this.getInstanceCount("0") == this.getInstanceCount("1");
        this.println(result);
        if (!result) {
            this.println("  0: " + this.getInstanceCount("0"));
            this.println("  1: " + this.getInstanceCount("1"));
        }
        return result;
    }

    private void saveRelation(Object key, Object value) {
        if (!this.attCommon.containsKey(key)) {
            this.attCommon.put(key, new HashSet());
        }
        HashSet names = (HashSet)this.attCommon.get(key);
        names.add(value);
    }

    private void checkRelaggsName(String name, String pattern, Includer includer, boolean regexp) {
        if (includer.contains(pattern, regexp)) {
            this.saveRelation(name, includer.getList().get(includer.matchIndex(pattern, regexp)));
        }
    }

    private boolean compareNames() {
        this.print("\nComparing names... ");
        String[] type = new String[2];
        Vector[] names = new Vector[2];
        Vector[] namesLeftOver = new Vector[2];
        boolean result = false;
        type[0] = (String)this.filetypes.get("0");
        type[1] = (String)this.filetypes.get("1");
        namesLeftOver[0] = null;
        namesLeftOver[1] = null;
        if (type[0].equals(type[1])) {
            result = true;
            names[0] = this.getNames("0");
            names[1] = this.getNames("1");
            Vector v = Set.intersect(names[0], names[1]);
            namesLeftOver[0] = Set.minus(names[0], v);
            namesLeftOver[1] = Set.minus(names[1], v);
            int i = 0;
            while (i < v.size()) {
                this.saveRelation(v.get(i).toString(), v.get(i).toString());
                ++i;
            }
        } else if (type[0].equals("relaggs") && type[1].equals("milk")) {
            String name;
            result = true;
            names[0] = this.getNames("0");
            names[1] = this.getNames("1");
            Vector v = (Vector)names[1].clone();
            int i = 0;
            while (i < v.size()) {
                v.set(i, v.get(i).toString().toLowerCase());
                ++i;
            }
            Includer includer = new Includer(v);
            v = names[0];
            Vector v2 = names[1];
            i = 0;
            while (i < v.size()) {
                name = v.get(i).toString().toLowerCase();
                int pos = name.indexOf("_");
                if (name.matches("t[0-9]+_.*")) {
                    name = name.substring(pos + 1, name.length());
                }
                name = name.replaceAll("_avg$", "");
                name = name.replaceAll("_cnt_val$", "");
                name = name.replaceAll("_max$", "");
                name = name.replaceAll("_median$", "");
                name = name.replaceAll("_min$", "");
                name = name.replaceAll("_quart1$", "");
                name = name.replaceAll("_quart3$", "");
                name = name.replaceAll("_range$", "");
                name = name.replaceAll("_stddev$", "");
                String tmp = name = name.replaceAll("_sum$", "");
                this.checkRelaggsName(v.get(i).toString(), tmp, includer, false);
                tmp = "m[0-9]+_" + tmp;
                this.checkRelaggsName(v.get(i).toString(), tmp, includer, true);
                pos = name.lastIndexOf("_");
                if (!name.matches(".*_[0-9]+") && pos > -1) {
                    int n = 0;
                    while (n < v2.size()) {
                        tmp = String.valueOf(v2.get(n).toString().replaceAll("^m[0-9]+_", "")) + "_";
                        if (name.startsWith(tmp) && name.substring(tmp.length() + 1, name.length()).indexOf("_") == -1) {
                            this.saveRelation(v.get(i), v2.get(n));
                        }
                        ++n;
                    }
                    String suffix = name.substring(pos + 1, name.length());
                    name = name.substring(0, pos);
                    tmp = String.valueOf(name) + "=" + suffix;
                    this.checkRelaggsName(v.get(i).toString(), tmp, includer, false);
                    tmp = "m[0-9]+_" + tmp;
                    this.checkRelaggsName(v.get(i).toString(), tmp, includer, true);
                }
                ++i;
            }
            v = new ProperVector();
            Enumeration<Object> enm = this.attCommon.keys();
            while (enm.hasMoreElements()) {
                v.add(enm.nextElement());
            }
            namesLeftOver[0] = Set.minus(names[0], v);
            v = new ProperVector();
            enm = this.attCommon.elements();
            while (enm.hasMoreElements()) {
                Iterator iter = ((HashSet)enm.nextElement()).iterator();
                while (iter.hasNext()) {
                    name = iter.next().toString();
                    if (v.contains(name)) continue;
                    v.add(name);
                }
            }
            namesLeftOver[1] = Set.minus(names[1], v);
        }
        this.println(result);
        if (result) {
            this.leftovers.put("0", namesLeftOver[0]);
            this.leftovers.put("1", namesLeftOver[1]);
            this.println("\nCommon Names:\n" + this.attCommon);
            this.println("\nLeftOver " + this.filenames.get("0") + ":\n" + namesLeftOver[0]);
            this.println("\nLeftOver " + this.filenames.get("1") + ":\n" + namesLeftOver[1]);
        }
        return result;
    }

    private boolean compareValues() {
        int i;
        this.print("\nComparing values");
        Instances inst1 = (Instances)this.instances.get("0");
        Instances inst2 = (Instances)this.instances.get("1");
        Cells matrix = new Cells(inst1.numInstances(), this.attCommon.size());
        matrix.setRowNumbers(true);
        ProperVector names = new ProperVector();
        Enumeration enm = this.attCommon.keys();
        int n = 0;
        while (enm.hasMoreElements()) {
            this.print(".");
            String name1 = enm.nextElement().toString();
            Iterator iter = ((HashSet)this.attCommon.get(name1)).iterator();
            while (iter.hasNext()) {
                String name2 = iter.next().toString();
                if (name1.equals(name2)) {
                    names.add(name1);
                } else {
                    names.add(String.valueOf(name1) + " = " + name2);
                }
                i = 0;
                while (i < matrix.getRowCount()) {
                    String cell = "";
                    Attribute att1 = inst1.attribute(name1);
                    Attribute att2 = inst2.attribute(name2);
                    Instance in1 = inst1.instance(i);
                    Instance in2 = inst2.instance(i);
                    if (in1.isMissing(att1) && in2.isMissing(att2)) {
                        if (this.cl.exists("denote_missing")) {
                            cell = "[missing]";
                        }
                    } else if (in1.value(att1) == in2.value(att2)) {
                        if (this.cl.exists("denote_equal")) {
                            cell = "[equal]";
                        }
                    } else {
                        cell = in1.isMissing(att1) ? String.valueOf(cell) + "?" : (att1.isNominal() ? String.valueOf(cell) + in1.stringValue(att1) : String.valueOf(cell) + Double.toString(in1.value(att1)));
                        cell = String.valueOf(cell) + " = ";
                        cell = in2.isMissing(att2) ? String.valueOf(cell) + "?" : (att2.isNominal() ? String.valueOf(cell) + in2.stringValue(att2) : String.valueOf(cell) + Double.toString(in2.value(att2)));
                    }
                    matrix.setCellAt(i, n, cell);
                    ++i;
                }
                ++n;
            }
        }
        this.println();
        matrix.setNames(names);
        if (this.cl.exists("output")) {
            ProperVector v = new ProperVector();
            v.add("filename;type;leftover");
            i = 0;
            while (i < 2) {
                String id = Integer.toString(i);
                String tmp = this.leftovers.get(id).toString().replaceAll(", ", ";");
                if (tmp.length() > 2) {
                    tmp = tmp.substring(1, tmp.length() - 1);
                }
                v.add(this.filenames.get(id) + ";" + this.filetypes.get(id) + ";" + tmp);
                ++i;
            }
            v.add("");
            v.add("mismatches");
            v.addAll(matrix.toCSV());
            this.println("\nSaving to '" + this.cl.getValue("output") + "'...");
            TextFile.save(this.cl.getValue("output"), v, false);
        } else {
            this.println(matrix.toString());
        }
        return true;
    }

    @Override
    protected boolean process() throws Exception {
        this.println("\nComparing\n=========\n");
        boolean result = this.loadFiles();
        if (result) {
            result = this.checkInstanceCount();
        }
        if (result) {
            result = this.compareNames();
        }
        if (result) {
            result = this.compareValues();
        }
        if (result) {
            this.println("\nFinished!");
        } else {
            this.println("\nFailed!");
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        ArffComparer app = new ArffComparer();
        app.run(args);
    }
}

