define(["exports","events","connectionManager","playbackManager","timeSyncManager","toast","globalize"],(function(_exports,_events,_connectionManager,_playbackManager,_timeSyncManager,_toast,_globalize){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}function waitForEventOnce(emitter,eventType,timeout){var _arguments=arguments;return new Promise((function(resolve,reject){var rejectTimeout;timeout&&(rejectTimeout=setTimeout((function(){reject("Timed out.")}),timeout));_events.default.on(emitter,eventType,(function callback(){_events.default.off(emitter,eventType,callback),rejectTimeout&&clearTimeout(rejectTimeout),resolve(_arguments)}))}))}function getActivePlayerId(){var info=_playbackManager.default.getPlayerInfo();return info?info.id:null}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_events=_interopRequireDefault(_events),_connectionManager=_interopRequireDefault(_connectionManager),_playbackManager=_interopRequireDefault(_playbackManager),_timeSyncManager=_interopRequireDefault(_timeSyncManager),_toast=_interopRequireDefault(_toast),_globalize=_interopRequireDefault(_globalize);var _default=new(function(){function SyncPlayManager(){var _this=this;!function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,SyncPlayManager),this.playbackRateSupported=!1,this.syncEnabled=!1,this.playbackDiffMillis=0,this.syncMethod="None",this.syncAttempts=0,this.lastSyncTime=new Date,this.syncWatcherTimeout=null,this.lastPlaybackWaiting=null,this.minBufferingThresholdMillis=1e3,this.currentPlayer=null,this.localPlayerPlaybackRate=1,this.syncPlayEnabledAt=null,this.syncPlayReady=!1,this.lastCommand=null,this.queuedCommand=null,this.scheduledCommand=null,this.syncTimeout=null,this.timeOffsetWithServer=0,this.roundTripDuration=0,this.notifySyncPlayReady=!1,_events.default.on(_playbackManager.default,"playbackstart",(function(player,state){_this.onPlaybackStart(player,state)})),_events.default.on(_playbackManager.default,"playbackstop",(function(stopInfo){_this.onPlaybackStop(stopInfo)})),_events.default.on(_playbackManager.default,"playerchange",(function(){_this.onPlayerChange()})),this.bindToPlayer(_playbackManager.default.getCurrentPlayer()),_events.default.on(this,"timeupdate",(function(event){_this.syncPlaybackTime()})),_events.default.on(_timeSyncManager.default,"update",(function(event,error,timeOffset,ping){if(error)console.debug("SyncPlay, time update issue",error);else if(_this.timeOffsetWithServer=timeOffset,_this.roundTripDuration=2*ping,_this.notifySyncPlayReady&&(_this.syncPlayReady=!0,_events.default.trigger(_this,"ready"),_this.notifySyncPlayReady=!1),_this.syncEnabled){var apiClient=_connectionManager.default.currentApiClient();if(!getActivePlayerId())return _this.signalError(),void(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayErrorMissingSession")});apiClient.sendSyncPlayPing({Ping:ping})}}))}return function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Constructor}(SyncPlayManager,[{key:"onPlaybackStart",value:function onPlaybackStart(player,state){_events.default.trigger(this,"playbackstart",[player,state])}},{key:"onPlaybackStop",value:function onPlaybackStop(stopInfo){_events.default.trigger(this,"playbackstop",[stopInfo]),this.isSyncPlayEnabled()&&this.disableSyncPlay(!1)}},{key:"onPlayerChange",value:function onPlayerChange(){this.bindToPlayer(_playbackManager.default.getCurrentPlayer()),_events.default.trigger(this,"playerchange",[this.currentPlayer])}},{key:"onPlayerUnpause",value:function onPlayerUnpause(){_events.default.trigger(this,"unpause",[this.currentPlayer])}},{key:"onPlayerPause",value:function onPlayerPause(){_events.default.trigger(this,"pause",[this.currentPlayer])}},{key:"onTimeUpdate",value:function onTimeUpdate(e){_events.default.trigger(this,"timeupdate",[e])}},{key:"onPlaying",value:function onPlaying(){this.lastPlaybackWaiting=null,_events.default.trigger(this,"playing")}},{key:"onWaiting",value:function onWaiting(){this.lastPlaybackWaiting||(this.lastPlaybackWaiting=new Date),_events.default.trigger(this,"waiting")}},{key:"isBuffering",value:function isBuffering(){return null!==this.lastPlaybackWaiting&&new Date-this.lastPlaybackWaiting>this.minBufferingThresholdMillis}},{key:"bindToPlayer",value:function bindToPlayer(player){if(player===this.currentPlayer||(this.releaseCurrentPlayer(),this.currentPlayer=player,player)){var self=this;this._onPlayerUnpause=function(){self.onPlayerUnpause()},this._onPlayerPause=function(){self.onPlayerPause()},this._onTimeUpdate=function(e){self.onTimeUpdate(e)},this._onPlaying=function(){self.onPlaying()},this._onWaiting=function(){self.onWaiting()},_events.default.on(player,"unpause",this._onPlayerUnpause),_events.default.on(player,"pause",this._onPlayerPause),_events.default.on(player,"timeupdate",this._onTimeUpdate),_events.default.on(player,"playing",this._onPlaying),_events.default.on(player,"waiting",this._onWaiting),player.supports&&player.supports("PlaybackRate")&&(this.localPlayerPlaybackRate=player.getPlaybackRate())}}},{key:"releaseCurrentPlayer",value:function releaseCurrentPlayer(){var player=this.currentPlayer;player&&(_events.default.off(player,"unpause",this._onPlayerUnpause),_events.default.off(player,"pause",this._onPlayerPause),_events.default.off(player,"timeupdate",this._onTimeUpdate),_events.default.off(player,"playing",this._onPlaying),_events.default.off(player,"waiting",this._onWaiting),this.playbackRateSupported&&(player.setPlaybackRate(this.localPlayerPlaybackRate),this.localPlayerPlaybackRate=1),this.currentPlayer=null,this.playbackRateSupported=!1)}},{key:"processGroupUpdate",value:function processGroupUpdate(cmd,apiClient){switch(cmd.Type){case"PrepareSession":this.prepareSession(apiClient,cmd.GroupId,cmd.Data);break;case"UserJoined":(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayUserJoined",cmd.Data)});break;case"UserLeft":(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayUserLeft",cmd.Data)});break;case"GroupJoined":this.enableSyncPlay(apiClient,new Date(cmd.Data),!0);break;case"NotInGroup":case"GroupLeft":this.disableSyncPlay(!0);break;case"GroupWait":(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayGroupWait",cmd.Data)});break;case"GroupDoesNotExist":(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayGroupDoesNotExist")});break;case"CreateGroupDenied":(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayCreateGroupDenied")});break;case"JoinGroupDenied":(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayJoinGroupDenied")});break;case"LibraryAccessDenied":(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayLibraryAccessDenied")});break;default:console.error("processSyncPlayGroupUpdate: command is not recognised: "+cmd.Type)}}},{key:"processCommand",value:function processCommand(cmd,apiClient){if(null!==cmd)if(this.isSyncPlayEnabled()){if(!this.syncPlayReady)return console.debug("SyncPlay processCommand: SyncPlay not ready, queued command",cmd),void(this.queuedCommand=cmd);if(cmd.When=new Date(cmd.When),cmd.EmittedAt=new Date(cmd.EmitttedAt),cmd.EmitttedAt<this.syncPlayEnabledAt)console.debug("SyncPlay processCommand: ignoring old command",cmd);else if(this.lastCommand&&this.lastCommand.When===cmd.When&&this.lastCommand.PositionTicks===cmd.PositionTicks&&this.Command===cmd.Command)console.debug("SyncPlay processCommand: ignoring duplicate command",cmd);else switch(this.lastCommand=cmd,console.log("SyncPlay will",cmd.Command,"at",cmd.When,"PositionTicks",cmd.PositionTicks),cmd.Command){case"Play":this.schedulePlay(cmd.When,cmd.PositionTicks);break;case"Pause":this.schedulePause(cmd.When,cmd.PositionTicks);break;case"Seek":this.scheduleSeek(cmd.When,cmd.PositionTicks);break;default:console.error("processCommand: command is not recognised: "+cmd.Type)}}else console.debug("SyncPlay processCommand: SyncPlay not enabled, ignoring command",cmd)}},{key:"prepareSession",value:function prepareSession(apiClient,groupId,sessionData){var _this2=this,serverId=apiClient.serverInfo().Id;_playbackManager.default.play({ids:sessionData.ItemIds,startPositionTicks:sessionData.StartPositionTicks,mediaSourceId:sessionData.MediaSourceId,audioStreamIndex:sessionData.AudioStreamIndex,subtitleStreamIndex:sessionData.SubtitleStreamIndex,startIndex:sessionData.StartIndex,serverId:serverId}).then((function(){waitForEventOnce(_this2,"playbackstart",3e4).then((function(){var playingItemId;if(!getActivePlayerId())return console.error("Missing sessionId!"),void(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayErrorMissingSession")});try{var playState=_playbackManager.default.getPlayerState();playingItemId=playState.NowPlayingItem.Id}catch(error){playingItemId=""}waitForEventOnce(_playbackManager.default,"reportplayback",3e4).then((function(success){_this2.localPause(),success||console.warning("Error reporting playback state to server. Joining group will fail."),apiClient.joinSyncPlayGroup({GroupId:groupId,PlayingItemId:playingItemId})})).catch((function(){console.error("Timed out while waiting for `reportplayback` event!"),(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayErrorMedia")})}))})).catch((function(){console.error("Timed out while waiting for `playbackstart` event!"),_this2.isSyncPlayEnabled()||(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayErrorMedia")})}))})).catch((function(error){console.error(error),(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayErrorMedia")})}))}},{key:"enableSyncPlay",value:function enableSyncPlay(apiClient,enabledAt){var _this3=this,showMessage=arguments.length>2&&void 0!==arguments[2]&&arguments[2];this.syncPlayEnabledAt=enabledAt,this.injectPlaybackManager(),_events.default.trigger(this,"enabled",[!0]),waitForEventOnce(this,"ready").then((function(){_this3.processCommand(_this3.queuedCommand,apiClient),_this3.queuedCommand=null})),this.syncPlayReady=!1,this.notifySyncPlayReady=!0,_timeSyncManager.default.forceUpdate(),showMessage&&(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayEnabled")})}},{key:"disableSyncPlay",value:function disableSyncPlay(){var showMessage=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.syncPlayEnabledAt=null,this.syncPlayReady=!1,this.lastCommand=null,this.queuedCommand=null,this.syncEnabled=!1,_events.default.trigger(this,"enabled",[!1]),this.restorePlaybackManager(),showMessage&&(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayDisabled")})}},{key:"isSyncPlayEnabled",value:function isSyncPlayEnabled(){return null!==this.syncPlayEnabledAt}},{key:"schedulePlay",value:function schedulePlay(playAtTime,positionTicks){var _this4=this;this.clearScheduledCommand();var currentTime=new Date,playAtTimeLocal=_timeSyncManager.default.serverDateToLocal(playAtTime);if(playAtTimeLocal>currentTime){var playTimeout=playAtTimeLocal-currentTime;this.localSeek(positionTicks),this.scheduledCommand=setTimeout((function(){_this4.localUnpause(),_this4.syncTimeout=setTimeout((function(){_this4.syncEnabled=!0}),1e3)}),playTimeout),console.debug("Scheduled play in",playTimeout/1e3,"seconds.")}else{var serverPositionTicks=positionTicks+1e4*(currentTime-playAtTimeLocal);waitForEventOnce(this,"unpause").then((function(){_this4.localSeek(serverPositionTicks)})),this.localUnpause(),this.syncTimeout=setTimeout((function(){_this4.syncEnabled=!0}),1e3)}}},{key:"schedulePause",value:function schedulePause(pauseAtTime,positionTicks){var _this5=this;this.clearScheduledCommand();var currentTime=new Date,pauseAtTimeLocal=_timeSyncManager.default.serverDateToLocal(pauseAtTime),callback=function callback(){waitForEventOnce(_this5,"pause",500).then((function(){_this5.localSeek(positionTicks)})).catch((function(){_this5.localSeek(positionTicks)})),_this5.localPause()};if(pauseAtTimeLocal>currentTime){var pauseTimeout=pauseAtTimeLocal-currentTime;this.scheduledCommand=setTimeout(callback,pauseTimeout),console.debug("Scheduled pause in",pauseTimeout/1e3,"seconds.")}else callback()}},{key:"scheduleSeek",value:function scheduleSeek(seekAtTime,positionTicks){this.schedulePause(seekAtTime,positionTicks)}},{key:"clearScheduledCommand",value:function clearScheduledCommand(){clearTimeout(this.scheduledCommand),clearTimeout(this.syncTimeout),this.syncEnabled=!1,this.currentPlayer&&this.currentPlayer.setPlaybackRate(1),this.clearSyncIcon()}},{key:"injectPlaybackManager",value:function injectPlaybackManager(){this.isSyncPlayEnabled()&&(_playbackManager.default.syncPlayEnabled||(_playbackManager.default._localUnpause=_playbackManager.default.unpause,_playbackManager.default._localPause=_playbackManager.default.pause,_playbackManager.default._localSeek=_playbackManager.default.seek,_playbackManager.default.unpause=this.playRequest,_playbackManager.default.pause=this.pauseRequest,_playbackManager.default.seek=this.seekRequest,_playbackManager.default.syncPlayEnabled=!0))}},{key:"restorePlaybackManager",value:function restorePlaybackManager(){this.isSyncPlayEnabled()||_playbackManager.default.syncPlayEnabled&&(_playbackManager.default.unpause=_playbackManager.default._localUnpause,_playbackManager.default.pause=_playbackManager.default._localPause,_playbackManager.default.seek=_playbackManager.default._localSeek,_playbackManager.default.syncPlayEnabled=!1)}},{key:"playRequest",value:function playRequest(player){_connectionManager.default.currentApiClient().requestSyncPlayStart()}},{key:"pauseRequest",value:function pauseRequest(player){_connectionManager.default.currentApiClient().requestSyncPlayPause(),_playbackManager.default._localUnpause(player)}},{key:"seekRequest",value:function seekRequest(PositionTicks,player){_connectionManager.default.currentApiClient().requestSyncPlaySeek({PositionTicks:PositionTicks})}},{key:"localUnpause",value:function localUnpause(player){_playbackManager.default.syncPlayEnabled?_playbackManager.default._localUnpause(player):_playbackManager.default.unpause(player)}},{key:"localPause",value:function localPause(player){_playbackManager.default.syncPlayEnabled?_playbackManager.default._localPause(player):_playbackManager.default.pause(player)}},{key:"localSeek",value:function localSeek(PositionTicks,player){_playbackManager.default.syncPlayEnabled?_playbackManager.default._localSeek(PositionTicks,player):_playbackManager.default.seek(PositionTicks,player)}},{key:"syncPlaybackTime",value:function syncPlaybackTime(){var _this6=this;if(this.lastCommand&&"Play"===this.lastCommand.Command&&!this.isBuffering()){var currentTime=new Date;if(!(currentTime-this.lastSyncTime<1e3)){this.lastSyncTime=currentTime;var playAtTime=this.lastCommand.When,currentPositionTicks=_playbackManager.default.currentTime(),serverPositionTicks=this.lastCommand.PositionTicks+1e4*(currentTime-playAtTime+this.timeOffsetWithServer),diffMillis=(serverPositionTicks-currentPositionTicks)/1e4;if(this.playbackDiffMillis=diffMillis,this.syncEnabled){var absDiffMillis=Math.abs(diffMillis);if(this.playbackRateSupported&&absDiffMillis>50&&absDiffMillis<2e3){this.syncAttempts>3&&(this.playbackRateSupported=!1);var speed=1+diffMillis/1e3;this.currentPlayer.setPlaybackRate(speed),this.syncEnabled=!1,this.syncAttempts++,this.showSyncIcon("SpeedToSync (x"+speed+")"),this.syncTimeout=setTimeout((function(){_this6.currentPlayer.setPlaybackRate(1),_this6.syncEnabled=!0,_this6.clearSyncIcon()}),1e3)}else absDiffMillis>300?(this.syncAttempts>5&&(this.syncEnabled=!1,this.showSyncIcon("Sync disabled (too many attempts)")),this.localSeek(serverPositionTicks),this.syncEnabled=!1,this.syncAttempts++,this.showSyncIcon("SkipToSync ("+this.syncAttempts+")"),this.syncTimeout=setTimeout((function(){_this6.syncEnabled=!0,_this6.clearSyncIcon()}),1e3)):(this.syncAttempts>0&&console.debug("Playback has been synced after",this.syncAttempts,"attempts."),this.syncAttempts=0)}}}}},{key:"getStats",value:function getStats(){return{TimeOffset:this.timeOffsetWithServer,PlaybackDiff:this.playbackDiffMillis,SyncMethod:this.syncMethod}}},{key:"showSyncIcon",value:function showSyncIcon(syncMethod){this.syncMethod=syncMethod,_events.default.trigger(this,"syncing",[!0,this.syncMethod])}},{key:"clearSyncIcon",value:function clearSyncIcon(){this.syncMethod="None",_events.default.trigger(this,"syncing",[!1,this.syncMethod])}},{key:"signalError",value:function signalError(){this.disableSyncPlay()}}]),SyncPlayManager}());_exports.default=_default}));
//# sourceMappingURL=syncPlayManager.js.map
