import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialLibraryVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the credential store that this library belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_library_vault#credential_store_id CredentialLibraryVault#credential_store_id}
    */
    readonly credentialStoreId: string;
    /**
    * The type of credential the library generates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_library_vault#credential_type CredentialLibraryVault#credential_type}
    */
    readonly credentialType?: string;
    /**
    * The Vault credential library description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_library_vault#description CredentialLibraryVault#description}
    */
    readonly description?: string;
    /**
    * The HTTP method the library uses when requesting credentials from Vault. Defaults to 'GET'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_library_vault#http_method CredentialLibraryVault#http_method}
    */
    readonly httpMethod?: string;
    /**
    * The body of the HTTP request the library sends to Vault when requesting credentials. Only valid if `http_method` is set to `POST`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_library_vault#http_request_body CredentialLibraryVault#http_request_body}
    */
    readonly httpRequestBody?: string;
    /**
    * The Vault credential library name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_library_vault#name CredentialLibraryVault#name}
    */
    readonly name?: string;
    /**
    * The path in Vault to request credentials from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_library_vault#path CredentialLibraryVault#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/credential_library_vault boundary_credential_library_vault}
*/
export declare class CredentialLibraryVault extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_credential_library_vault";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/credential_library_vault boundary_credential_library_vault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialLibraryVaultConfig
    */
    constructor(scope: Construct, id: string, config: CredentialLibraryVaultConfig);
    private _credentialStoreId?;
    get credentialStoreId(): string;
    set credentialStoreId(value: string);
    get credentialStoreIdInput(): string | undefined;
    private _credentialType?;
    get credentialType(): string;
    set credentialType(value: string);
    resetCredentialType(): void;
    get credentialTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _httpMethod?;
    get httpMethod(): string;
    set httpMethod(value: string);
    resetHttpMethod(): void;
    get httpMethodInput(): string | undefined;
    private _httpRequestBody?;
    get httpRequestBody(): string;
    set httpRequestBody(value: string);
    resetHttpRequestBody(): void;
    get httpRequestBodyInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
